/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.offer.gui.extension.esslinger;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.client.model.base.CustomerModel;
import de.datomino.peppergis.client.model.offer.OfferAreaRelationModel;
import de.datomino.peppergis.client.model.offer.OfferExtension1Model;
import de.datomino.peppergis.client.model.offer.OfferModel;
import de.datomino.peppergis.simplebasearea.special.GraphicalMultiAreaSelectionPane;
import de.datomino.util.swing.SpringUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SpringLayout;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.commons.collections.ComparatorUtils;
import org.apache.commons.collections.Transformer;
import org.ktde.util.StringUtil;

public class EsslingerMultiAreaObjectSelectionPane
extends GraphicalMultiAreaSelectionPane {
    private static final long serialVersionUID = -2102665735702622917L;
    private JCheckBox retailCityActive;
    private JCheckBox retailCountryActive;
    private JCheckBox stationBookStoreActive;
    private JFormattedTextField retailCity;
    private JFormattedTextField retailCountry;
    private JFormattedTextField stationBookStore;
    private JTextField offerPreSelection;
    private JComboBox offerComboBox;
    private List<OfferModel> offers;

    public EsslingerMultiAreaObjectSelectionPane(ModelEnviroment modelEnviroment) {
        super(modelEnviroment);
        Collection<OfferModel> allOffers = modelEnviroment.getAllCaller().getOfferCaller().getAllOffers();
        DefaultComboBoxModel dcm = (DefaultComboBoxModel)this.offerComboBox.getModel();
        dcm.addElement(" ");
        this.offers = new ArrayList<OfferModel>(allOffers.size());
        for (OfferModel offerModel : allOffers) {
            dcm.addElement(offerModel);
            this.offers.add(offerModel);
        }
        this.offerComboBox.addActionListener(new OfferActionListener());
    }

    @Override
    protected Component getSouthComponent() {
        JPanel panel = new JPanel(new SpringLayout());
        panel.add(new JLabel("Auftr\u00e4ge"));
        this.offerPreSelection = new JTextField(30);
        this.offerPreSelection.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.update();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.update();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.update();
            }

            private void update() {
                String text = EsslingerMultiAreaObjectSelectionPane.this.offerPreSelection.getText().toLowerCase();
                DefaultComboBoxModel dcm = (DefaultComboBoxModel)EsslingerMultiAreaObjectSelectionPane.this.offerComboBox.getModel();
                dcm.removeAllElements();
                dcm.addElement(" ");
                for (OfferModel offer : EsslingerMultiAreaObjectSelectionPane.this.offers) {
                    String offerCustomerStringRepresentation = EsslingerMultiAreaObjectSelectionPane.this.getOfferCustomerStringRepresentation(offer);
                    if (!offer.getOfferNumber().toLowerCase().startsWith(text) && !offerCustomerStringRepresentation.toLowerCase().contains(text)) continue;
                    dcm.addElement(offer);
                }
                EsslingerMultiAreaObjectSelectionPane.this.offerComboBox.showPopup();
            }
        });
        panel.add(this.offerPreSelection);
        panel.add(new JLabel());
        this.offerComboBox = new JComboBox(new DefaultComboBoxModel());
        this.offerComboBox.setRenderer(new OfferRenderer(this.offerComboBox.getRenderer()));
        panel.add(this.offerComboBox);
        this.retailCityActive = new JCheckBox("Einzelverkauf Stadt");
        panel.add(this.retailCityActive);
        this.retailCity = new JFormattedTextField(new DecimalFormat());
        this.retailCity.setColumns(10);
        this.retailCity.setValue(500);
        panel.add(this.retailCity);
        this.retailCountryActive = new JCheckBox("Einzelverkauf Land");
        panel.add(this.retailCountryActive);
        this.retailCountry = new JFormattedTextField(new DecimalFormat());
        this.retailCountry.setColumns(10);
        this.retailCountry.setValue(1000);
        panel.add(this.retailCountry);
        this.stationBookStoreActive = new JCheckBox("Einzelverkauf gesamt");
        panel.add(this.stationBookStoreActive);
        this.stationBookStore = new JFormattedTextField(new DecimalFormat());
        this.stationBookStore.setColumns(10);
        this.stationBookStore.setValue(5000);
        panel.add(this.stationBookStore);
        SpringUtilities.makeCompactGrid(panel, 5, 2, 2, 2, 2, 2);
        JPanel outerPanel = new JPanel(new BorderLayout());
        outerPanel.add((Component)panel, "North");
        return outerPanel;
    }

    public boolean adaptSpecialValuesToOffer(OfferModel offerModel, OfferExtension1Model esslingerOfferExtensionModel) {
        Number number;
        boolean b = false;
        if (this.retailCityActive.isSelected() && (number = (Number)this.retailCity.getValue()) != null) {
            esslingerOfferExtensionModel.setRetailCity(number.intValue());
            b = true;
        }
        if (this.retailCountryActive.isSelected() && (number = (Number)this.retailCountry.getValue()) != null) {
            esslingerOfferExtensionModel.setRetailCountry(number.intValue());
            b = true;
        }
        if (this.stationBookStoreActive.isSelected() && (number = (Number)this.stationBookStore.getValue()) != null) {
            esslingerOfferExtensionModel.setStationBookStore(number.intValue());
            b = true;
        }
        return b;
    }

    public void setOfferValues(OfferExtension1Model offerExtension1Model) {
        Integer retailCity = offerExtension1Model.getRetailCity();
        this.retailCityActive.setSelected(retailCity != null);
        this.retailCity.setValue(retailCity);
        Integer retailCountry = offerExtension1Model.getRetailCountry();
        this.retailCountryActive.setSelected(retailCountry != null);
        this.retailCountry.setValue(retailCountry);
        Integer stationBookStore = offerExtension1Model.getStationBookStore();
        this.stationBookStoreActive.setSelected(stationBookStore != null);
        this.stationBookStore.setValue(stationBookStore);
    }

    JCheckBox getRetailCityActive() {
        return this.retailCityActive;
    }

    JCheckBox getRetailCountryActive() {
        return this.retailCountryActive;
    }

    JCheckBox getStationBookStoreActive() {
        return this.stationBookStoreActive;
    }

    Integer getRetailCity() {
        Number number = (Number)this.retailCity.getValue();
        return number == null ? 0 : number.intValue();
    }

    Integer getRetailCountry() {
        Number number = (Number)this.retailCountry.getValue();
        return number == null ? 0 : number.intValue();
    }

    Integer getStationBookStore() {
        Number number = (Number)this.stationBookStore.getValue();
        return number == null ? 0 : number.intValue();
    }

    private String getOfferCustomerStringRepresentation(OfferModel offerModel) {
        CustomerModel customer = offerModel.getCustomer();
        StringBuilder sb = new StringBuilder();
        if (customer != null) {
            String companyName = customer.getCompanyName();
            String lastName = customer.getLastName();
            boolean companyBlank = StringUtil.isBlank(companyName);
            boolean lastBlank = StringUtil.isBlank(lastName);
            if (!companyBlank && !lastBlank) {
                sb.append(" - ").append(companyName).append("/").append(lastName);
            } else if (!companyBlank) {
                sb.append(" - ").append(companyName);
            } else if (!lastBlank) {
                sb.append(" - ").append(lastName);
            }
        }
        return sb.toString();
    }

    private class OfferActionListener
    implements ActionListener {
        private OfferActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object selectedItem = EsslingerMultiAreaObjectSelectionPane.this.offerComboBox.getSelectedItem();
            if (selectedItem instanceof OfferModel) {
                OfferModel offer = (OfferModel)selectedItem;
                DefaultListModel listModel = (DefaultListModel)EsslingerMultiAreaObjectSelectionPane.this.getSelectedAreaObjectList().getModel();
                listModel.clear();
                ArrayList<AreaObjectModel> areaObjects = new ArrayList<AreaObjectModel>(offer.countOfferAreaRelations());
                for (OfferAreaRelationModel offerAreaRelationModel : offer.iterableOfferAreaRelations()) {
                    areaObjects.add(offerAreaRelationModel.getArea());
                }
                Collections.sort(areaObjects, ComparatorUtils.transformedComparator(ComparatorUtils.naturalComparator(), new Transformer(){

                    @Override
                    public Object transform(Object input) {
                        String shortcut = ((AreaObjectModel)input).getShortcut();
                        return shortcut == null ? " " : shortcut;
                    }
                }));
                for (AreaObjectModel areaObjectModel : areaObjects) {
                    listModel.addElement(areaObjectModel);
                }
            }
        }
    }

    private class OfferRenderer
    implements ListCellRenderer {
        private ListCellRenderer listCellRenderer;

        public OfferRenderer(ListCellRenderer listCellRenderer) {
            this.listCellRenderer = listCellRenderer;
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Object sValue = value;
            if (value instanceof OfferModel) {
                OfferModel offerModel = (OfferModel)value;
                StringBuilder sb = new StringBuilder(offerModel.getOfferNumber());
                sb.append(EsslingerMultiAreaObjectSelectionPane.this.getOfferCustomerStringRepresentation(offerModel));
                sValue = sb.toString();
            }
            return this.listCellRenderer.getListCellRendererComponent(list, sValue, index, isSelected, cellHasFocus);
        }
    }
}

