/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.offer.gui;

import de.datomino.peppergis.client.gui.common.CommonDialog;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.Model;
import de.datomino.peppergis.client.model.offer.OfferModel;
import de.datomino.peppergis.client.util.PdfUtil;
import de.datomino.peppergis.exception.ValidateException;
import de.datomino.peppergis.offer.gui.AbstractOfferPane;
import de.datomino.peppergis.offer.gui.DefaultOfferPane;
import de.datomino.peppergis.offer.print.OfferPrinter;
import de.datomino.util.swing.SwingUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JOptionPane;
import org.ktde.util.StringUtil;
import org.ktde.util.datatypes.Tupel;

public class OfferDialog
extends CommonDialog {
    private static final long serialVersionUID = -7374747994952021252L;
    private ModelEnviroment modelEnviroment;
    private AbstractOfferPane<?> offerPane;

    public OfferDialog(Window parent, ModelEnviroment modelEnviroment) {
        super((Component)parent, ModelEnviroment.getMessageResolver().resolveMessage("messages.offer.newOffer", new Serializable[0]), Dialog.ModalityType.APPLICATION_MODAL);
        this.modelEnviroment = modelEnviroment;
        this.buildLayout();
        this.pack();
        SwingUtils.center(this);
    }

    @Override
    protected Action getCancelAction() {
        return new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.cancel", new Serializable[0])){
            private static final long serialVersionUID = -2607722507835676339L;

            @Override
            public void actionPerformed(ActionEvent e) {
                OfferDialog.this.dispose();
            }
        };
    }

    @Override
    protected Component getMainComponent() {
        String type = ModelEnviroment.getProperties().getProperty("offer.specialType");
        if (StringUtil.isBlank(type)) {
            this.offerPane = new DefaultOfferPane(this.modelEnviroment);
            return this.offerPane;
        }
        String className = OfferDialog.class.getPackage().getName() + ".extension." + StringUtil.constantToJavaIdent(type) + "." + StringUtil.constantToClassname(type) + "OfferPane";
        try {
            Class<?> clazz = Class.forName(className);
            this.offerPane = (AbstractOfferPane)clazz.getConstructor(ModelEnviroment.class).newInstance(this.modelEnviroment);
            return this.offerPane;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected Action getOkAction() {
        return new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.save", new Serializable[0])){
            private static final long serialVersionUID = -2607722507835676339L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (OfferDialog.this.offerPane.checkForSave()) {
                    OfferDialog.this.modelEnviroment.getUndoManager().startTransaction();
                    Tupel tupel = OfferDialog.this.offerPane.getOfferModel();
                    OfferModel offerModel = tupel.getElement1();
                    int d = 0;
                    if (offerModel.getId() != null) {
                        d = JOptionPane.showConfirmDialog(OfferDialog.this, "Soll der Auftrag mit der Nummer " + offerModel.getOfferNumber() + " \u00fcberschrieben werden", "Frage", 0);
                    }
                    if (d == 0) {
                        OfferDialog.this.modelEnviroment.getUndoManager().finishTransaction("");
                        try {
                            OfferDialog.this.modelEnviroment.getUndoManager().storeTransactions();
                        }
                        catch (ValidateException e1) {
                            throw new RuntimeException(e1);
                        }
                    } else {
                        OfferDialog.this.modelEnviroment.getUndoManager().rollbackTransaction();
                    }
                } else {
                    JOptionPane.showMessageDialog(OfferDialog.this, "Bitte \u00fcberpr\u00fcfen Sie, ob Sie alle mit * gekennzeichneten Felder ausgef\u00fcllt haben", "Fehlende Felder", 2);
                }
            }
        };
    }

    @Override
    protected Action[] getAdditionalActions() {
        AbstractAction action = new AbstractAction("Drucken"){
            private static final long serialVersionUID = -3311100737021264455L;

            @Override
            public void actionPerformed(ActionEvent e) {
                OfferDialog.this.modelEnviroment.getUndoManager().startTransaction();
                OfferDialog.this.print();
                OfferDialog.this.modelEnviroment.getUndoManager().rollbackTransaction();
            }
        };
        return new Action[]{action};
    }

    private <T extends Model> void print() {
        if (this.offerPane.checkForPrint()) {
            Tupel<OfferModel, ?> tupel = this.offerPane.getOfferModel();
            String type = ModelEnviroment.getProperties().getProperty("offer.specialType");
            String className = OfferPrinter.class.getPackage().getName() + "." + StringUtil.constantToJavaIdent(type) + "." + StringUtil.constantToClassname(type) + "OfferPrinterImpl";
            try {
                Class<?> clazz = Class.forName(className);
                OfferPrinter offerPrinter = (OfferPrinter)clazz.newInstance();
                Model extension = (Model)tupel.getElement2();
                InputStream printOffer = offerPrinter.printOffer(tupel.getElement1(), extension, this.modelEnviroment);
                PdfUtil.showPdf("Peppergis - Offer", printOffer, ModelEnviroment.getProperties());
            }
            catch (Exception e1) {
                throw new RuntimeException(e1);
            }
        } else {
            JOptionPane.showMessageDialog(this, "Bitte \u00fcberpr\u00fcfen Sie, ob Sie alle mit * gekennzeichneten Felder ausgef\u00fcllt haben", "Fehlende Felder", 2);
        }
    }
}

