/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.job.user;

import de.datomino.logistic.type.RouteBackType;
import de.datomino.logistic.type.RouteVehicleType;
import de.datomino.peppergis.dto.exporter.TourExportFormat;
import de.datomino.peppergis.tour.CalculationWay;
import de.datomino.peppergis.type.LetterDeliveryType;
import de.datomino.peppergis.type.ParcelBlockType;
import de.datomino.peppergis.type.SubscriptionDeliveryType;
import de.datomino.peppergis.type.SubscriptionStatus;
import de.datomino.peppergis.type.areatourtype.AreaCalculationType;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONWriter;
import org.ktde.util.StringUtil;

public class ReviewAreaTourJobParameters {
    private static final String AREA_LAYER_KEY = "areaLayer";
    private static final String AREA_SHORT_CUTS = "areaShortcuts";
    private static final String USE_DELIVERY_ROUND_FROM_LOG_2 = "useDeliveryRoundFromLog2";
    private static final String DELIVERY_ROUND = "deliveryRound";
    private static final String CALCULATION_WAY = "calculationWay";
    private static final String AREA_CALCULATION_TYPE = "areaCalculationType";
    private static final String FIXED_DATE = "fixedDate";
    private static final String DAY_GAP = "dayGap";
    private static final String MINUTES = "minutes";
    private static final String TOUR_EXPORT_FORMAT = "tourExportFormat";
    private static final String PDF = "pdf";
    private static final String ROUTE_VEHICLE_TYPES = "routeVehicleTypes";
    private static final String DEFAULT_POI_ROUTE_VEHICLE_TYPE = "defaultPoiRouteVehicleType";
    private static final String POI_ROUTE_VEHICLE_TYPE = "poiRouteVehicleType";
    private static final String DEFAULT_PICK_POINT_ROUTE_VEHICLE_TYPE = "defaultPickPointRouteVehicleType";
    private static final String PICK_POINT_ROUTE_VEHICLE_TYPE = "pickPointRouteVehicleType";
    private static final String WITH_POI = "withPoi";
    private static final String WITH_PICK_POINT_START = "withPickPointStart";
    private static final String WITH_PICK_POINT_END = "withPickPointEnd";
    private static final String ROUTE_BACK_TYPE = "routeBackType";
    private static final String WITH_DIFFICULTY_LEVEL = "withDifficultyLevel";
    private static final String WITH_PARCEL_LOCATION = "withParcelLocation";
    private static final String SUBSCRIPTION_STATUS = "subscriptionStatus";
    private static final String SUBSCRIPTION_DELIVERY_TYPE = "subscriptionDeliveryType";
    private static final String LETTER_DELIVERY_TYPE = "letterDeliveryType";
    private static final String PREFER_EXCLUSIONS = "preferExclusions";
    private static final String BLOCK_DESCRIPTORS = "blockDescriptors";
    private static final String COST_PER_HOUR = "costPerHour";
    private static final String COST_CAR_PER_KILOMETER = "costCarPerKilometer";
    private static final String COST_BIKE_PER_KILOMETER = "costBikePerKilometer";
    private static final String COST_FOOT_PER_KILOMETER = "costFootPerKilometer";
    private static final String NIGHT_SURCHARGE = "nightSurcharge";
    private static final String NIGHT_SURCHARGE_FROM_MINUTE = "nightSurchargeFromMinute";
    private static final String NIGHT_SURCHARGE_VALID_FROM = "nightSurchargeValidFrom";
    private static final String NIGHT_SURCHARGE_VALID_TILL = "nightSurchargeValidTill";
    private static final String EXTRA_CHARGE = "extraCharge";
    private String areaLayer;
    private Collection<String> areaShortcuts;
    private boolean useDeliveryRoundFromLog2;
    private String deliveryRound;
    private CalculationWay calculationWay;
    private AreaCalculationType areaCalculationType;
    private Date fixedDate;
    private Integer dayGap;
    private Integer minutes;
    private TourExportFormat tourExportFormat;
    private boolean pdf;
    private RouteVehicleType[] routeVehicleTypes;
    private boolean defaultPoiRouteVehicleType;
    private RouteVehicleType poiRouteVehicleType;
    private boolean defaultPickPointRouteVehicleType;
    private RouteVehicleType pickPointRouteVehicleType;
    private boolean withPoi;
    private boolean withPickPointStart;
    private boolean withPickPointEnd;
    private RouteBackType routeBackType;
    private boolean withDifficultyLevel;
    private boolean withParcelLocation;
    private Collection<SubscriptionStatus> subscriptionStatus;
    private Collection<SubscriptionDeliveryType> subscriptionDeliveryType;
    private Collection<LetterDeliveryType> letterDeliveryType;
    private boolean preferExclusions;
    private Collection<BlockDescriptor> blockDescriptors;
    private Double costPerHour;
    private Double costCarPerKilometer;
    private Double costBikePerKilometer;
    private Double costFootPerKilometer;
    private Double nightSurcharge;
    private Integer nightSurchargeFromMinute;
    private Integer nightSurchargeValidFrom;
    private Integer nightSurchargeValidTill;
    private Double extraCharge;

    public ReviewAreaTourJobParameters(String areaLayer, Collection<String> areaShortcuts, boolean useDeliveryRoundFromLog2, String deliveryRound, CalculationWay calculationWay, AreaCalculationType areaCalculationType, Date fixedDate, Integer dayGap, Integer minutes, TourExportFormat tourExportFormat, boolean pdf, RouteVehicleType[] routeVehicleTypes, boolean defaultPoiRouteVehicleType, RouteVehicleType poiRouteVehicleType, boolean defaultPickPointRouteVehicleType, RouteVehicleType pickPointRouteVehicleType, boolean withPoi, boolean withPickPointStart, boolean withPickPointEnd, RouteBackType routeBackType, boolean withDifficultyLevel, boolean withParcelLocation, Collection<SubscriptionStatus> subscriptionStatus, Collection<SubscriptionDeliveryType> subscriptionDeliveryType, Collection<LetterDeliveryType> letterDeliveryType, boolean preferExclusions, Collection<BlockDescriptor> blockDescriptors, Double costPerHour, Double costCarPerKilometer, Double costBikePerKilometer, Double costFootPerKilometer, Double nightSurcharge, Integer nightSurchargeFromMinute, Integer nightSurchargeValidFrom, Integer nightSurchargeValidTill, Double extraCharge) {
        this.areaLayer = areaLayer;
        this.areaShortcuts = areaShortcuts;
        this.useDeliveryRoundFromLog2 = useDeliveryRoundFromLog2;
        this.deliveryRound = deliveryRound;
        this.calculationWay = calculationWay;
        this.areaCalculationType = areaCalculationType;
        this.fixedDate = fixedDate;
        this.dayGap = dayGap;
        this.minutes = minutes;
        this.tourExportFormat = tourExportFormat;
        this.pdf = pdf;
        this.routeVehicleTypes = routeVehicleTypes;
        this.defaultPoiRouteVehicleType = defaultPoiRouteVehicleType;
        this.poiRouteVehicleType = poiRouteVehicleType;
        this.defaultPickPointRouteVehicleType = defaultPickPointRouteVehicleType;
        this.pickPointRouteVehicleType = pickPointRouteVehicleType;
        this.withPoi = withPoi;
        this.withPickPointStart = withPickPointStart;
        this.withPickPointEnd = withPickPointEnd;
        this.routeBackType = routeBackType;
        this.withDifficultyLevel = withDifficultyLevel;
        this.withParcelLocation = withParcelLocation;
        this.subscriptionStatus = subscriptionStatus;
        this.subscriptionDeliveryType = subscriptionDeliveryType;
        this.letterDeliveryType = letterDeliveryType;
        this.preferExclusions = preferExclusions;
        this.blockDescriptors = blockDescriptors;
        this.costPerHour = costPerHour;
        this.costCarPerKilometer = costCarPerKilometer;
        this.costBikePerKilometer = costBikePerKilometer;
        this.costFootPerKilometer = costFootPerKilometer;
        this.nightSurcharge = nightSurcharge;
        this.nightSurchargeFromMinute = nightSurchargeFromMinute;
        this.nightSurchargeValidFrom = nightSurchargeValidFrom;
        this.nightSurchargeValidTill = nightSurchargeValidTill;
        this.extraCharge = extraCharge;
    }

    public String getAreaLayer() {
        return this.areaLayer;
    }

    public Collection<String> getAreaShortcuts() {
        return this.areaShortcuts;
    }

    public boolean isUseDeliveryRoundFromLog2() {
        return this.useDeliveryRoundFromLog2;
    }

    public String getDeliveryRound() {
        return this.deliveryRound;
    }

    public CalculationWay getCalculationWay() {
        return this.calculationWay;
    }

    public AreaCalculationType getAreaCalculationType() {
        return this.areaCalculationType;
    }

    public Date getFixedDate() {
        return this.fixedDate;
    }

    public Integer getDayGap() {
        return this.dayGap;
    }

    public Integer getMinutes() {
        return this.minutes;
    }

    public TourExportFormat getTourExportFormat() {
        return this.tourExportFormat;
    }

    public boolean isPdf() {
        return this.pdf;
    }

    public RouteVehicleType[] getRouteVehicleTypes() {
        return this.routeVehicleTypes;
    }

    public boolean isDefaultPoiRouteVehicleType() {
        return this.defaultPoiRouteVehicleType;
    }

    public RouteVehicleType getPoiRouteVehicleType() {
        return this.poiRouteVehicleType;
    }

    public boolean isDefaultPickPointRouteVehicleType() {
        return this.defaultPickPointRouteVehicleType;
    }

    public RouteVehicleType getPickPointRouteVehicleType() {
        return this.pickPointRouteVehicleType;
    }

    public boolean isWithPoi() {
        return this.withPoi;
    }

    public boolean isWithPickPointStart() {
        return this.withPickPointStart;
    }

    public boolean isWithPickPointEnd() {
        return this.withPickPointEnd;
    }

    public RouteBackType getRouteBackType() {
        return this.routeBackType;
    }

    public boolean isWithDifficultyLevel() {
        return this.withDifficultyLevel;
    }

    public boolean isWithParcelLocation() {
        return this.withParcelLocation;
    }

    public Collection<SubscriptionStatus> getSubscriptionStatus() {
        return this.subscriptionStatus;
    }

    public Collection<SubscriptionDeliveryType> getSubscriptionDeliveryType() {
        return this.subscriptionDeliveryType;
    }

    public Collection<LetterDeliveryType> getLetterDeliveryType() {
        return this.letterDeliveryType;
    }

    public boolean isPreferExclusions() {
        return this.preferExclusions;
    }

    public Collection<BlockDescriptor> getBlockDescriptors() {
        return this.blockDescriptors;
    }

    public Integer getNightSurchargeFromMinute() {
        return this.nightSurchargeFromMinute;
    }

    public Integer getNightSurchargeValidFrom() {
        return this.nightSurchargeValidFrom;
    }

    public Integer getNightSurchargeValidTill() {
        return this.nightSurchargeValidTill;
    }

    public Double getCostCarPerKilometer() {
        return this.costCarPerKilometer;
    }

    public Double getCostBikePerKilometer() {
        return this.costBikePerKilometer;
    }

    public Double getCostFootPerKilometer() {
        return this.costFootPerKilometer;
    }

    public Double getNightSurcharge() {
        return this.nightSurcharge;
    }

    public Double getExtraCharge() {
        return this.extraCharge;
    }

    public Double getCostPerHour() {
        return this.costPerHour;
    }

    private static void addEnum(JSONWriter jw, String key, Enum<?> e) {
        if (e != null) {
            jw.key(key);
            jw.value(e.name());
        }
    }

    private static void addValue(JSONWriter jw, String key, Object value) {
        if (value != null) {
            jw.key(key);
            jw.value(value);
        }
    }

    private static void addBoolean(JSONWriter jw, String key, boolean value) {
        jw.key(key);
        jw.value(value);
    }

    private static void addDouble(JSONWriter jw, String key, Double value) {
        if (value != null) {
            jw.key(key);
            jw.value(value);
        }
    }

    private static void addInteger(JSONWriter jw, String key, Integer value) {
        if (value != null) {
            jw.key(key);
            jw.value(value.longValue());
        }
    }

    public static byte[] toJson(ReviewAreaTourJobParameters parameters) {
        StringWriter sw = new StringWriter();
        JSONWriter jw = new JSONWriter(sw);
        jw.object();
        jw.key(AREA_LAYER_KEY);
        jw.value(parameters.getAreaLayer());
        jw.key(AREA_SHORT_CUTS);
        jw.array();
        for (String area : parameters.getAreaShortcuts()) {
            jw.value(area);
        }
        jw.endArray();
        jw.key(USE_DELIVERY_ROUND_FROM_LOG_2);
        jw.value(parameters.isUseDeliveryRoundFromLog2());
        ReviewAreaTourJobParameters.addValue(jw, DELIVERY_ROUND, parameters.getDeliveryRound());
        ReviewAreaTourJobParameters.addEnum(jw, CALCULATION_WAY, parameters.getCalculationWay());
        ReviewAreaTourJobParameters.addEnum(jw, AREA_CALCULATION_TYPE, parameters.getAreaCalculationType());
        Date fixedDate = parameters.getFixedDate();
        if (fixedDate != null) {
            jw.key(FIXED_DATE);
            jw.value(fixedDate.getTime());
        } else {
            Integer dayGap = parameters.getDayGap();
            if (dayGap == null) {
                dayGap = 0;
            }
            jw.key(DAY_GAP);
            jw.value(dayGap.longValue());
        }
        Integer minutes = parameters.getMinutes();
        if (minutes != null) {
            jw.key(MINUTES);
            jw.value(minutes.longValue());
        }
        ReviewAreaTourJobParameters.addEnum(jw, TOUR_EXPORT_FORMAT, parameters.getTourExportFormat());
        ReviewAreaTourJobParameters.addBoolean(jw, PDF, parameters.isPdf());
        jw.key(ROUTE_VEHICLE_TYPES);
        jw.array();
        RouteVehicleType[] routeVehicleTypes = parameters.getRouteVehicleTypes();
        if (routeVehicleTypes != null) {
            for (RouteVehicleType routeVehicleType : routeVehicleTypes) {
                jw.value(routeVehicleType.name());
            }
        }
        jw.endArray();
        ReviewAreaTourJobParameters.addBoolean(jw, DEFAULT_POI_ROUTE_VEHICLE_TYPE, parameters.isDefaultPoiRouteVehicleType());
        ReviewAreaTourJobParameters.addEnum(jw, POI_ROUTE_VEHICLE_TYPE, parameters.getPoiRouteVehicleType());
        ReviewAreaTourJobParameters.addBoolean(jw, DEFAULT_PICK_POINT_ROUTE_VEHICLE_TYPE, parameters.isDefaultPickPointRouteVehicleType());
        ReviewAreaTourJobParameters.addEnum(jw, PICK_POINT_ROUTE_VEHICLE_TYPE, parameters.getPickPointRouteVehicleType());
        ReviewAreaTourJobParameters.addBoolean(jw, WITH_POI, parameters.isWithPoi());
        ReviewAreaTourJobParameters.addBoolean(jw, WITH_PICK_POINT_START, parameters.isWithPickPointStart());
        ReviewAreaTourJobParameters.addBoolean(jw, WITH_PICK_POINT_END, parameters.isWithPickPointEnd());
        ReviewAreaTourJobParameters.addEnum(jw, ROUTE_BACK_TYPE, parameters.getRouteBackType());
        ReviewAreaTourJobParameters.addBoolean(jw, WITH_DIFFICULTY_LEVEL, parameters.isWithDifficultyLevel());
        ReviewAreaTourJobParameters.addBoolean(jw, WITH_PARCEL_LOCATION, parameters.isWithParcelLocation());
        jw.key(SUBSCRIPTION_STATUS);
        jw.array();
        Collection<SubscriptionStatus> subscriptionStatus = parameters.getSubscriptionStatus();
        if (subscriptionStatus != null) {
            for (SubscriptionStatus s2 : subscriptionStatus) {
                jw.value(s2.name());
            }
        }
        jw.endArray();
        jw.key(SUBSCRIPTION_DELIVERY_TYPE);
        jw.array();
        Collection<SubscriptionDeliveryType> subscriptionDeliveryType = parameters.getSubscriptionDeliveryType();
        if (subscriptionDeliveryType != null) {
            for (SubscriptionDeliveryType subscriptionDeliveryType2 : subscriptionDeliveryType) {
                jw.value(subscriptionDeliveryType2.name());
            }
        }
        jw.endArray();
        jw.key(LETTER_DELIVERY_TYPE);
        jw.array();
        Collection<LetterDeliveryType> letterDeliveryType = parameters.getLetterDeliveryType();
        if (letterDeliveryType != null) {
            for (LetterDeliveryType letterDeliveryType2 : letterDeliveryType) {
                jw.value(letterDeliveryType2.name());
            }
        }
        jw.endArray();
        ReviewAreaTourJobParameters.addBoolean(jw, PREFER_EXCLUSIONS, parameters.isPreferExclusions());
        jw.key(BLOCK_DESCRIPTORS);
        jw.array();
        Collection<BlockDescriptor> collection = parameters.getBlockDescriptors();
        if (collection != null) {
            for (BlockDescriptor blockDescriptor : collection) {
                jw.object();
                ReviewAreaTourJobParameters.addValue(jw, "key", blockDescriptor.getKey());
                Boolean value = blockDescriptor.getValue();
                if (value != null) {
                    ReviewAreaTourJobParameters.addBoolean(jw, "value", value);
                }
                ReviewAreaTourJobParameters.addEnum(jw, "parcelBlockType", blockDescriptor.getParcelBlockType());
                jw.endObject();
            }
        }
        jw.endArray();
        ReviewAreaTourJobParameters.addDouble(jw, COST_PER_HOUR, parameters.getCostPerHour());
        ReviewAreaTourJobParameters.addDouble(jw, COST_CAR_PER_KILOMETER, parameters.getCostCarPerKilometer());
        ReviewAreaTourJobParameters.addDouble(jw, COST_BIKE_PER_KILOMETER, parameters.getCostBikePerKilometer());
        ReviewAreaTourJobParameters.addDouble(jw, COST_FOOT_PER_KILOMETER, parameters.getCostFootPerKilometer());
        ReviewAreaTourJobParameters.addDouble(jw, NIGHT_SURCHARGE, parameters.getNightSurcharge());
        ReviewAreaTourJobParameters.addInteger(jw, NIGHT_SURCHARGE_FROM_MINUTE, parameters.getNightSurchargeFromMinute());
        ReviewAreaTourJobParameters.addInteger(jw, NIGHT_SURCHARGE_VALID_FROM, parameters.getNightSurchargeValidFrom());
        ReviewAreaTourJobParameters.addInteger(jw, NIGHT_SURCHARGE_VALID_TILL, parameters.getNightSurchargeValidTill());
        ReviewAreaTourJobParameters.addDouble(jw, EXTRA_CHARGE, parameters.getExtraCharge());
        jw.endObject();
        sw.flush();
        IOUtils.closeQuietly(sw);
        String string = sw.toString();
        try {
            return string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static ReviewAreaTourJobParameters fromJson(byte[] b) {
        String s;
        try {
            s = new String(b, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        JSONObject json = new JSONObject(s);
        String areaLayer = ReviewAreaTourJobParameters.getString(json, AREA_LAYER_KEY);
        HashSet<String> areas = new HashSet<String>();
        if (json.has(AREA_SHORT_CUTS)) {
            JSONArray array = json.getJSONArray(AREA_SHORT_CUTS);
            int length = array.length();
            for (int i = 0; i < length; ++i) {
                areas.add(array.getString(i));
            }
        }
        boolean useDeliveryRoundFromLog2 = ReviewAreaTourJobParameters.getBoolean(json, USE_DELIVERY_ROUND_FROM_LOG_2);
        String deliveryRound = ReviewAreaTourJobParameters.getString(json, DELIVERY_ROUND);
        CalculationWay calculationWay = ReviewAreaTourJobParameters.getEnum(CalculationWay.class, json, CALCULATION_WAY);
        AreaCalculationType areaCalculationType = ReviewAreaTourJobParameters.getEnum(AreaCalculationType.class, json, AREA_CALCULATION_TYPE);
        Long fixedDateLong = ReviewAreaTourJobParameters.getLong(json, FIXED_DATE);
        Date fixedDate = fixedDateLong == null ? null : new Date(fixedDateLong);
        Integer dayGap = ReviewAreaTourJobParameters.getInteger(json, DAY_GAP);
        Integer minutes = ReviewAreaTourJobParameters.getInteger(json, MINUTES);
        TourExportFormat tourExportFormat = ReviewAreaTourJobParameters.getEnum(TourExportFormat.class, json, TOUR_EXPORT_FORMAT);
        boolean pdf = ReviewAreaTourJobParameters.getBoolean(json, PDF);
        RouteVehicleType[] routeVehicleTypes = new RouteVehicleType[]{};
        if (json.has(ROUTE_VEHICLE_TYPES)) {
            JSONArray array = json.getJSONArray(ROUTE_VEHICLE_TYPES);
            int length = array.length();
            routeVehicleTypes = new RouteVehicleType[length];
            for (int i = 0; i < length; ++i) {
                routeVehicleTypes[i] = RouteVehicleType.valueOf(array.getString(i));
            }
        }
        boolean defaultPoiRouteVehicleType = ReviewAreaTourJobParameters.getBoolean(json, DEFAULT_POI_ROUTE_VEHICLE_TYPE);
        RouteVehicleType poiRouteVehicleType = ReviewAreaTourJobParameters.getEnum(RouteVehicleType.class, json, POI_ROUTE_VEHICLE_TYPE);
        boolean defaultPickPointRouteVehicleType = ReviewAreaTourJobParameters.getBoolean(json, DEFAULT_PICK_POINT_ROUTE_VEHICLE_TYPE);
        RouteVehicleType pickPointRouteVehicleType = ReviewAreaTourJobParameters.getEnum(RouteVehicleType.class, json, PICK_POINT_ROUTE_VEHICLE_TYPE);
        boolean withPoi = ReviewAreaTourJobParameters.getBoolean(json, WITH_POI);
        boolean withPickPointStart = ReviewAreaTourJobParameters.getBoolean(json, WITH_PICK_POINT_START);
        boolean withPickPointEnd = ReviewAreaTourJobParameters.getBoolean(json, WITH_PICK_POINT_END);
        RouteBackType routeBackType = ReviewAreaTourJobParameters.getEnum(RouteBackType.class, json, ROUTE_BACK_TYPE);
        boolean withDifficultyLevel = ReviewAreaTourJobParameters.getBoolean(json, WITH_DIFFICULTY_LEVEL);
        boolean withParcelLocation = ReviewAreaTourJobParameters.getBoolean(json, WITH_PARCEL_LOCATION);
        EnumSet<SubscriptionStatus> subscriptionStatus = EnumSet.noneOf(SubscriptionStatus.class);
        if (json.has(SUBSCRIPTION_STATUS)) {
            JSONArray array = json.getJSONArray(SUBSCRIPTION_STATUS);
            for (int i = 0; i < array.length(); ++i) {
                subscriptionStatus.add(SubscriptionStatus.valueOf(array.getString(i)));
            }
        }
        EnumSet<SubscriptionDeliveryType> subscriptionDeliveryType = EnumSet.noneOf(SubscriptionDeliveryType.class);
        if (json.has(SUBSCRIPTION_DELIVERY_TYPE)) {
            JSONArray array = json.getJSONArray(SUBSCRIPTION_DELIVERY_TYPE);
            for (int i = 0; i < array.length(); ++i) {
                subscriptionDeliveryType.add(SubscriptionDeliveryType.valueOf(array.getString(i)));
            }
        }
        EnumSet<LetterDeliveryType> letterDeliveryType = EnumSet.noneOf(LetterDeliveryType.class);
        if (json.has(LETTER_DELIVERY_TYPE)) {
            JSONArray array = json.getJSONArray(LETTER_DELIVERY_TYPE);
            for (int i = 0; i < array.length(); ++i) {
                letterDeliveryType.add(LetterDeliveryType.valueOf(array.getString(i)));
            }
        }
        boolean preferExclusions = ReviewAreaTourJobParameters.getBoolean(json, PREFER_EXCLUSIONS);
        List<BlockDescriptor> blockDescriptors = Collections.emptyList();
        if (json.has(BLOCK_DESCRIPTORS)) {
            JSONArray array = json.getJSONArray(BLOCK_DESCRIPTORS);
            int length = array.length();
            blockDescriptors = new ArrayList(length);
            for (int i = 0; i < length; ++i) {
                JSONObject blockObject = array.getJSONObject(i);
                String key = ReviewAreaTourJobParameters.getString(blockObject, "key");
                Boolean value = null;
                if (blockObject.has("value")) {
                    value = blockObject.getBoolean("value");
                }
                ParcelBlockType parcelBlockType = ReviewAreaTourJobParameters.getEnum(ParcelBlockType.class, blockObject, "parcelBlockType");
                blockDescriptors.add(new BlockDescriptor(key, value, parcelBlockType));
            }
        }
        Double costPerHour = ReviewAreaTourJobParameters.getDouble(json, COST_PER_HOUR);
        Double costCarPerKilometer = ReviewAreaTourJobParameters.getDouble(json, COST_CAR_PER_KILOMETER);
        Double costBikePerKilometer = ReviewAreaTourJobParameters.getDouble(json, COST_BIKE_PER_KILOMETER);
        Double costFootPerKilometer = ReviewAreaTourJobParameters.getDouble(json, COST_FOOT_PER_KILOMETER);
        Double nightSurcharge = ReviewAreaTourJobParameters.getDouble(json, NIGHT_SURCHARGE);
        Integer nightSurchargeFromMinute = ReviewAreaTourJobParameters.getInteger(json, NIGHT_SURCHARGE_FROM_MINUTE);
        Integer nightSurchargeValidFrom = ReviewAreaTourJobParameters.getInteger(json, NIGHT_SURCHARGE_VALID_FROM);
        Integer nightSurchargeValidTill = ReviewAreaTourJobParameters.getInteger(json, NIGHT_SURCHARGE_VALID_TILL);
        Double extraCharge = ReviewAreaTourJobParameters.getDouble(json, EXTRA_CHARGE);
        return new ReviewAreaTourJobParameters(areaLayer, areas, useDeliveryRoundFromLog2, deliveryRound, calculationWay, areaCalculationType, fixedDate, dayGap, minutes, tourExportFormat, pdf, routeVehicleTypes, defaultPoiRouteVehicleType, poiRouteVehicleType, defaultPickPointRouteVehicleType, pickPointRouteVehicleType, withPoi, withPickPointStart, withPickPointEnd, routeBackType, withDifficultyLevel, withParcelLocation, subscriptionStatus, subscriptionDeliveryType, letterDeliveryType, preferExclusions, blockDescriptors, costPerHour, costCarPerKilometer, costBikePerKilometer, costFootPerKilometer, nightSurcharge, nightSurchargeFromMinute, nightSurchargeValidFrom, nightSurchargeValidTill, extraCharge);
    }

    private static Double getDouble(JSONObject json, String key) {
        if (json.has(key)) {
            return json.getDouble(key);
        }
        return null;
    }

    private static Integer getInteger(JSONObject json, String key) {
        Long l = ReviewAreaTourJobParameters.getLong(json, key);
        return l == null ? null : Integer.valueOf(l.intValue());
    }

    private static Long getLong(JSONObject json, String key) {
        if (json.has(key)) {
            return json.getLong(key);
        }
        return null;
    }

    private static <T extends Enum<T>> T getEnum(Class<T> clazz, JSONObject json, String key) {
        String s = ReviewAreaTourJobParameters.getString(json, key);
        if (!StringUtil.isBlank(s)) {
            return Enum.valueOf(clazz, s);
        }
        return null;
    }

    private static boolean getBoolean(JSONObject json, String key) {
        if (json.has(key)) {
            return json.getBoolean(key);
        }
        return false;
    }

    private static String getString(JSONObject json, String key) {
        if (json.has(key)) {
            return json.getString(key);
        }
        return null;
    }

    public static class BlockDescriptor {
        private static final String KEY_KEY = "key";
        private static final String VALUE_KEY = "value";
        private static final String PARCEL_BLOCK_TYPE_KEY = "parcelBlockType";
        private String key;
        private Boolean value;
        private ParcelBlockType parcelBlockType;

        public BlockDescriptor(String key, Boolean value, ParcelBlockType parcelBlockType) {
            this.key = key;
            this.value = value;
            this.parcelBlockType = parcelBlockType;
        }

        public String getKey() {
            return this.key;
        }

        public Boolean getValue() {
            return this.value;
        }

        public ParcelBlockType getParcelBlockType() {
            return this.parcelBlockType;
        }
    }
}

