/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.job.user;

import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.HashSet;
import org.apache.commons.io.IOUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONWriter;

public class DeprecatedSubscriptionCleanerJobParameters {
    private static final String DAYS_KEY = "days";
    private static final String AREA_LAYERS_KEY = "areaLayers";
    private Collection<Long> areaLayers;
    private int days;

    public DeprecatedSubscriptionCleanerJobParameters(int days, Collection<Long> areaLayers) {
        this.days = days;
        this.areaLayers = areaLayers;
    }

    public int getDays() {
        return this.days;
    }

    public Collection<Long> getAreaLayers() {
        return this.areaLayers;
    }

    public static byte[] toJson(int days, Collection<Long> areaLayerIds) {
        StringWriter sw = new StringWriter();
        JSONWriter jw = new JSONWriter(sw);
        jw.object();
        jw.key(DAYS_KEY);
        jw.value(days);
        if (areaLayerIds != null) {
            jw.key(AREA_LAYERS_KEY);
            jw.array();
            for (Long id : areaLayerIds) {
                jw.value(id);
            }
            jw.endArray();
        }
        jw.endObject();
        sw.flush();
        IOUtils.closeQuietly(sw);
        String s = sw.toString();
        try {
            return s.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static DeprecatedSubscriptionCleanerJobParameters fromJson(byte[] b) {
        String s;
        try {
            s = new String(b, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        JSONObject json = new JSONObject(s);
        int days = 0;
        try {
            days = json.getInt(DAYS_KEY);
        }
        catch (JSONException ex) {
            throw new RuntimeException(ex);
        }
        HashSet<Long> areaLayerIds = null;
        try {
            JSONArray jsonArray = json.getJSONArray(AREA_LAYERS_KEY);
            areaLayerIds = new HashSet<Long>();
            for (Object o : jsonArray) {
                areaLayerIds.add(((Number)o).longValue());
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return new DeprecatedSubscriptionCleanerJobParameters(days, areaLayerIds);
    }
}

