/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.job.user;

import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import org.apache.commons.io.IOUtils;
import org.json.JSONObject;
import org.json.JSONWriter;

public class CloneLayerJobParameters {
    private static final String AREA_LAYER_ID_KEY = "areaLayerId";
    private static final String NEW_LAYER_NAME_KEY = "newLayerName";
    private static final String AREA_PARCEL_RELATIONS_KEY = "areaParcelRelations";
    private static final String AREAS_KEY = "areas";
    private static final String SUBSCRIPTIONS_KEY = "subscriptions";
    private static final String LETTERS_KEY = "letters";
    private static final String STOPS_KEY = "stops";
    private static final String DELIVERER_AREA_RELATIONS_KEY = "delivererAreaRelations";
    private static final String MODE_KEY = "mode";
    private boolean areaParcelRelations;
    private boolean areas;
    private boolean subscriptions;
    private boolean letters;
    private boolean stops;
    private boolean delivererAreaRelations;
    private Long areaLayerId;
    private String newLayerName;
    private Mode mode;

    public CloneLayerJobParameters(Long areaLayerId, String newLayerName, boolean areaParcelRelations, boolean areas, boolean subscriptions, boolean letters, boolean stops, boolean delivererAreaRelations, Mode mode) {
        this.areaLayerId = areaLayerId;
        this.newLayerName = newLayerName;
        this.areaParcelRelations = areaParcelRelations;
        this.areas = areas;
        this.subscriptions = subscriptions;
        this.letters = letters;
        this.stops = stops;
        this.delivererAreaRelations = delivererAreaRelations;
        this.mode = mode;
    }

    public boolean isAreaParcelRelations() {
        return this.areaParcelRelations;
    }

    public boolean isAreas() {
        return this.areas;
    }

    public boolean isSubscriptions() {
        return this.subscriptions;
    }

    public boolean isLetters() {
        return this.letters;
    }

    public boolean isStops() {
        return this.stops;
    }

    public boolean isDelivererAreaRelations() {
        return this.delivererAreaRelations;
    }

    public Long getAreaLayerId() {
        return this.areaLayerId;
    }

    public String getNewLayerName() {
        return this.newLayerName;
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    public static byte[] toJson(long areaLayerId, String newLayerName, boolean areaParcelRelations, boolean areas, boolean subscriptions, boolean letters, boolean stops, boolean delivererAreaRelations, Mode mode) {
        StringWriter sw = new StringWriter();
        JSONWriter jw = new JSONWriter(sw);
        jw.object();
        jw.key(AREA_LAYER_ID_KEY);
        jw.value(areaLayerId);
        jw.key(NEW_LAYER_NAME_KEY);
        jw.value(newLayerName);
        jw.key(AREA_PARCEL_RELATIONS_KEY);
        jw.value(areaParcelRelations);
        jw.key(AREAS_KEY);
        jw.value(areas);
        jw.key(SUBSCRIPTIONS_KEY);
        jw.value(subscriptions);
        jw.key(LETTERS_KEY);
        jw.value(letters);
        jw.key(STOPS_KEY);
        jw.value(stops);
        jw.key(DELIVERER_AREA_RELATIONS_KEY);
        jw.value(delivererAreaRelations);
        jw.key(MODE_KEY);
        jw.value(mode.name());
        jw.endObject();
        sw.flush();
        IOUtils.closeQuietly(sw);
        String s = sw.toString();
        try {
            return s.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static CloneLayerJobParameters fromJson(byte[] b) {
        String s;
        try {
            s = new String(b, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        JSONObject json = new JSONObject(s);
        boolean areaParcelRelations = true;
        boolean areas = true;
        boolean subscriptions = true;
        boolean letters = true;
        boolean stops = true;
        boolean delivererAreaRelations = true;
        Long areaLayerIdKey = null;
        String newAreaLayerName = null;
        Mode mode = Mode.OVERWRITE;
        if (json.has(AREA_LAYER_ID_KEY)) {
            areaLayerIdKey = json.getLong(AREA_LAYER_ID_KEY);
        }
        if (json.has(NEW_LAYER_NAME_KEY)) {
            newAreaLayerName = json.getString(NEW_LAYER_NAME_KEY);
        }
        if (json.has(AREA_PARCEL_RELATIONS_KEY)) {
            areaParcelRelations = json.getBoolean(AREA_PARCEL_RELATIONS_KEY);
        }
        if (json.has(AREAS_KEY)) {
            areas = json.getBoolean(AREAS_KEY);
        }
        if (json.has(SUBSCRIPTIONS_KEY)) {
            subscriptions = json.getBoolean(SUBSCRIPTIONS_KEY);
        }
        if (json.has(LETTERS_KEY)) {
            letters = json.getBoolean(LETTERS_KEY);
        }
        if (json.has(STOPS_KEY)) {
            stops = json.getBoolean(STOPS_KEY);
        }
        if (json.has(DELIVERER_AREA_RELATIONS_KEY)) {
            delivererAreaRelations = json.getBoolean(DELIVERER_AREA_RELATIONS_KEY);
        }
        if (json.has(MODE_KEY)) {
            mode = Mode.valueOf(json.getString(MODE_KEY));
        }
        return new CloneLayerJobParameters(areaLayerIdKey, newAreaLayerName, areaParcelRelations, areas, subscriptions, letters, stops, delivererAreaRelations, mode);
    }

    public static enum Mode {
        OVERWRITE,
        CREATE_NEW;

    }
}

