/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.importer.util;

import de.datomino.logistic.dto.LogisticQualifiedLocationDto;
import de.datomino.peppergis.dto.importer.GenericCsvDto;
import de.datomino.peppergis.dto.importer.ParcelImportDto;
import de.datomino.peppergis.type.ImportParcelStatus;
import de.datomino.peppergis.util.FormUtil;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.dto.ImmutablePointDto;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import org.ktde.math.projection.CoordinateFactory;

public class ImportUtil {
    private static final char DELIM = ',';
    private static final char TEXTQUOTE = '\"';
    private static final String ENCODING = "UTF-8";

    public static ParcelImportDto createParcelImportDto(Collection<LogisticQualifiedLocationDto> locations) throws UnsupportedEncodingException {
        ParcelImportDto parcelImportDto = new ParcelImportDto();
        parcelImportDto.setDelim(',');
        parcelImportDto.setTextQuote('\"');
        parcelImportDto.setEncoding(ENCODING);
        try {
            CoordinateFactory factory = ((ImmutablePoint)locations.iterator().next().getGeom().getGeoObject()).getCoordinateFactory();
            parcelImportDto.setCoordinateFactory(factory.getProjection());
        }
        catch (Exception e) {
            parcelImportDto.setCoordinateFactory(CoordinateFactory.Projections.Wgs84);
        }
        ImportUtil.addColumnMapping(parcelImportDto);
        String content = ImportUtil.createImportParcelHeader();
        for (LogisticQualifiedLocationDto location : locations) {
            content = content + System.getProperty("line.separator") + ImportUtil.createLine(location);
        }
        parcelImportDto.setContent(content.getBytes(ENCODING));
        return parcelImportDto;
    }

    public static void addColumnMapping(ParcelImportDto parcelImportDto) {
        parcelImportDto.setSingleColumnMapping((Serializable)((Object)ParcelImportDto.Columns.ID), ParcelImportDto.Columns.ID.name());
        parcelImportDto.setSingleColumnMapping((Serializable)((Object)GenericCsvDto.AddressColumns.COUNTRY), GenericCsvDto.AddressColumns.COUNTRY.name());
        parcelImportDto.setSingleColumnMapping((Serializable)((Object)GenericCsvDto.AddressColumns.POSTCODE), GenericCsvDto.AddressColumns.POSTCODE.name());
        parcelImportDto.setSingleColumnMapping((Serializable)((Object)GenericCsvDto.AddressColumns.CITY), GenericCsvDto.AddressColumns.CITY.name());
        parcelImportDto.setSingleColumnMapping((Serializable)((Object)GenericCsvDto.AddressColumns.DISTRICT), GenericCsvDto.AddressColumns.DISTRICT.name());
        parcelImportDto.setSingleColumnMapping((Serializable)((Object)GenericCsvDto.AddressColumns.STREET), GenericCsvDto.AddressColumns.STREET.name());
        parcelImportDto.setSingleColumnMapping((Serializable)((Object)GenericCsvDto.AddressColumns.HOUSENUMBER), GenericCsvDto.AddressColumns.HOUSENUMBER.name());
        parcelImportDto.setSingleColumnMapping((Serializable)((Object)GenericCsvDto.AddressColumns.HOUSENUMBER_EXTENSION), GenericCsvDto.AddressColumns.HOUSENUMBER_EXTENSION.name());
        parcelImportDto.setSingleColumnMapping((Serializable)((Object)GenericCsvDto.AddressColumns.X), GenericCsvDto.AddressColumns.X.name());
        parcelImportDto.setSingleColumnMapping((Serializable)((Object)GenericCsvDto.AddressColumns.Y), GenericCsvDto.AddressColumns.Y.name());
        parcelImportDto.setSingleColumnMapping((Serializable)((Object)ParcelImportDto.Columns.STATUS), ParcelImportDto.Columns.STATUS.name());
    }

    public static String createLine(LogisticQualifiedLocationDto location) {
        String line = ImportUtil.addField("", location.getInternalId());
        line = ImportUtil.addField(line, FormUtil.getStringDisplay(location.getCountry() == null ? "" : location.getCountry().getIso3166_2()));
        line = ImportUtil.addField(line, FormUtil.getStringDisplay(location.getPostcode()));
        line = ImportUtil.addField(line, FormUtil.getStringDisplay(location.getCity()));
        line = ImportUtil.addField(line, FormUtil.getStringDisplay(location.getDistrict()));
        line = ImportUtil.addField(line, FormUtil.getStringDisplay(location.getStreet()));
        line = ImportUtil.addField(line, FormUtil.getStringDisplay(String.valueOf(location.getHousenumber())));
        line = ImportUtil.addField(line, FormUtil.getStringDisplay(location.getExtension()));
        ImmutablePointDto point = location.getGeom();
        if (point != null && point.getGeoObject() != null) {
            line = ImportUtil.addField(line, String.valueOf(((ImmutablePoint)point.getGeoObject()).getX()));
            line = ImportUtil.addField(line, String.valueOf(((ImmutablePoint)point.getGeoObject()).getY()));
        } else {
            line = ImportUtil.addField(line, "0.0");
            line = ImportUtil.addField(line, "0.0");
        }
        line = location.getMatching() < 99.9 ? ImportUtil.addField(line, ImportParcelStatus.NOTCHANGED.name()) : ImportUtil.addField(line, ImportParcelStatus.NOTCHECKED.name());
        return line;
    }

    public static String createImportParcelHeader() {
        String header = ImportUtil.addField("", ParcelImportDto.Columns.ID.name());
        header = ImportUtil.addField(header, GenericCsvDto.AddressColumns.COUNTRY.name());
        header = ImportUtil.addField(header, GenericCsvDto.AddressColumns.POSTCODE.name());
        header = ImportUtil.addField(header, GenericCsvDto.AddressColumns.CITY.name());
        header = ImportUtil.addField(header, GenericCsvDto.AddressColumns.DISTRICT.name());
        header = ImportUtil.addField(header, GenericCsvDto.AddressColumns.STREET.name());
        header = ImportUtil.addField(header, GenericCsvDto.AddressColumns.HOUSENUMBER.name());
        header = ImportUtil.addField(header, GenericCsvDto.AddressColumns.HOUSENUMBER_EXTENSION.name());
        header = ImportUtil.addField(header, GenericCsvDto.AddressColumns.X.name());
        header = ImportUtil.addField(header, GenericCsvDto.AddressColumns.Y.name());
        header = ImportUtil.addField(header, ParcelImportDto.Columns.STATUS.name());
        return header;
    }

    private static String addField(String s, String field) {
        return s + ',' + '\"' + field + '\"';
    }
}

