/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.importer.subscription;

import de.datomino.peppergis.client.gui.asynchronous.AbstractAsynchronousDialog;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.importer.AbstractAddressCsvImporter;
import de.datomino.peppergis.client.message.EnumMessageResolverNameGenerator;
import de.datomino.peppergis.client.model.area.AreaLayerModel;
import de.datomino.peppergis.client.util.ClientSwingUtil;
import de.datomino.peppergis.dto.area.AreaLayerDto;
import de.datomino.peppergis.dto.asynchronous.AsynchronousDto;
import de.datomino.peppergis.dto.importer.GenericCsvDto;
import de.datomino.peppergis.dto.importer.SubscriptionImportDto;
import de.datomino.peppergis.dto.importer.SubscriptionImportReportDto;
import de.datomino.peppergis.exception.ClientImportException;
import de.datomino.peppergis.importer.subscription.SubscriptionImporterBreakTimePanel;
import de.datomino.peppergis.type.AreaObjectGenInfoDiscriminator;
import de.datomino.peppergis.type.SubscriptionDeliveryType;
import de.datomino.util.assistant.editor.Worker;
import de.datomino.util.assistant.model.BooleanField;
import de.datomino.util.assistant.model.ChoiceField;
import de.datomino.util.assistant.model.CsvColumnChoiceField;
import de.datomino.util.assistant.model.CsvContentGuesser;
import de.datomino.util.assistant.model.Fieldset;
import de.datomino.util.assistant.model.Page;
import de.datomino.util.callback.CallBack;
import de.datomino.util.common.PrimitiveUtil;
import de.datomino.util.message.MessageResolver;
import de.datomino.util.message.error.ErrorMessages;
import java.awt.Window;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JOptionPane;
import org.ktde.math.projection.CoordinateFactory;
import org.ktde.util.NameGenerator;
import org.ktde.util.datatypes.Tupel;
import org.ktde.util.io.CsvReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriptionImporter
extends AbstractAddressCsvImporter<SubscriptionImportDto> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SubscriptionImporter.class);
    private ChoiceField<AreaLayerModel> layerField;
    private ChoiceField<CoordinateFactory.Projections> coordinateFactoryField;
    private BooleanField emptyLayer;
    private CsvColumnChoiceField xField;
    private CsvColumnChoiceField yField;
    private CsvColumnChoiceField parcelIdField;
    private CsvColumnChoiceField lastNameField;
    private CsvColumnChoiceField firstNameField;
    private CsvColumnChoiceField companyNameField;
    private CsvColumnChoiceField customerNumberField;
    private CsvColumnChoiceField areaShortcutField;
    private CsvColumnChoiceField statusField;
    private CsvColumnChoiceField subscriptionNumberField;
    private CsvColumnChoiceField subscriptionDeliveryTypeField;
    private CsvColumnChoiceField startDateField;
    private CsvColumnChoiceField endDateField;
    private CsvColumnChoiceField mondayField;
    private CsvColumnChoiceField tuesdayField;
    private CsvColumnChoiceField wednesdayField;
    private CsvColumnChoiceField thursdayField;
    private CsvColumnChoiceField fridayField;
    private CsvColumnChoiceField saturdayField;
    private CsvColumnChoiceField sundayField;
    private SubscriptionImporterBreakTimePanel subscriptionImporterBreakTimePanel;
    private CsvColumnChoiceField deleteField;

    public SubscriptionImporter() {
        MessageResolver messageResolver = ModelEnviroment.getMessageResolver();
        Collection<AreaLayerModel> areaLayers = new ModelEnviroment(null).getAllCaller().getAreaCaller().getAreaLayersForType(AreaObjectGenInfoDiscriminator.values());
        this.layerField = new ChoiceField<1>(ModelEnviroment.getMessageResolver().resolveMessage("messages.import.area.layer", new Serializable[0]), (Collection<1>)areaLayers, new NameGenerator<AreaLayerModel>(){

            @Override
            public String getName(AreaLayerModel t) {
                return t == null ? ModelEnviroment.getMessageResolver().resolveMessage("messages.default.pleaseChoose", new Serializable[0]) : t.getDisplayname();
            }
        });
        Collection<CoordinateFactory.Projections> projections = CoordinateFactory.getListableProjections();
        CoordinateFactory.Projections[] values = new CoordinateFactory.Projections[projections.size()];
        values = projections.toArray(values);
        this.coordinateFactoryField = new ChoiceField<CoordinateFactory.Projections>(messageResolver.resolveMessage("messages.default.coordinateFactory", new Serializable[0]), values, new EnumMessageResolverNameGenerator(), CoordinateFactory.Projections.Wgs84);
        this.xField = new CsvColumnChoiceField(messageResolver.resolveMessageForEnum(GenericCsvDto.AddressColumns.X), (Serializable)((Object)GenericCsvDto.AddressColumns.X), this.createRegexForXCoordinate(), true);
        this.yField = new CsvColumnChoiceField(messageResolver.resolveMessageForEnum(GenericCsvDto.AddressColumns.Y), (Serializable)((Object)GenericCsvDto.AddressColumns.Y), this.createRegexForYCoordinate(), true);
        this.parcelIdField = new CsvColumnChoiceField(messageResolver.resolveMessageForEnum(SubscriptionImportDto.Columns.PARCEL_ID), (Serializable)((Object)SubscriptionImportDto.Columns.PARCEL_ID), this.createRegex("GCO ID", "Geb\u00e4ude-Nummer", "Geb\u00e4ude", "GBD-Nr."), false);
        this.lastNameField = new CsvColumnChoiceField(messageResolver.resolveMessageForEnum(SubscriptionImportDto.Columns.LAST_NAME), (Serializable)((Object)SubscriptionImportDto.Columns.LAST_NAME), this.createRegex("Nachname", "Familienname"), true);
        this.firstNameField = new CsvColumnChoiceField(messageResolver.resolveMessageForEnum(SubscriptionImportDto.Columns.FIRST_NAME), (Serializable)((Object)SubscriptionImportDto.Columns.FIRST_NAME), this.createRegex("Vorname"), true);
        this.companyNameField = new CsvColumnChoiceField(messageResolver.resolveMessageForEnum(SubscriptionImportDto.Columns.COMPANY_NAME), (Serializable)((Object)SubscriptionImportDto.Columns.COMPANY_NAME), this.createRegex("Firmenname", "Firma"), true);
        this.customerNumberField = new CsvColumnChoiceField(messageResolver.resolveMessageForEnum(SubscriptionImportDto.Columns.CUSTOMER_NUMBER), (Serializable)((Object)SubscriptionImportDto.Columns.CUSTOMER_NUMBER), this.createRegex("Kundennummer", "Kunden-Nr.", "Kd-Nr."), false);
        this.areaShortcutField = new CsvColumnChoiceField(messageResolver.resolveMessageForEnum(SubscriptionImportDto.Columns.AREA_SHORTCUT), (Serializable)((Object)SubscriptionImportDto.Columns.AREA_SHORTCUT), this.createRegex("Gebietsnummer", "Bezirk", "Bezirks-ID"), true);
        this.statusField = new CsvColumnChoiceField(messageResolver.resolveMessageForEnum(SubscriptionImportDto.Columns.STATUS), (Serializable)((Object)SubscriptionImportDto.Columns.STATUS), this.createRegex("status"), true);
        this.subscriptionNumberField = new CsvColumnChoiceField(messageResolver.resolveMessageForEnum(SubscriptionImportDto.Columns.SUBSCRIPTION_NUMBER), (Serializable)((Object)SubscriptionImportDto.Columns.SUBSCRIPTION_NUMBER), this.createRegex("Abonnenten-Nummer", "Abonummer", "Abo-Nr.", "Abonummer (eindeutig)", "Abo-Nr. (eindeutig)"), false);
        this.subscriptionDeliveryTypeField = new CsvColumnChoiceField(messageResolver.resolveMessage(SubscriptionDeliveryType.class.getName(), new Serializable[0]), (Serializable)((Object)SubscriptionImportDto.Columns.DELIVERY_TYPE), this.createRegex("abonnenten Zustelltyp", "Abo-Zustelltyp", "Zustelltyp"), true);
        this.startDateField = new CsvColumnChoiceField(messageResolver.resolveMessage("messages.subscription.validityStart", new Serializable[0]), (Serializable)((Object)SubscriptionImportDto.Columns.START_DATE), this.createRegex("Abo-Start", "Start", "G\u00fcltig von", "Von"), true);
        this.endDateField = new CsvColumnChoiceField(messageResolver.resolveMessage("messages.subscription.validityEnd", new Serializable[0]), (Serializable)((Object)SubscriptionImportDto.Columns.END_DATE), this.createRegex("Abo-Ende", "Ende", "G\u00fcltig bis", "Bis"), true);
        this.mondayField = new CsvColumnChoiceField(messageResolver.resolveMessage("gui.date.monday", new Serializable[0]), (Serializable)((Object)SubscriptionImportDto.Columns.MONDAY), this.createRegex("mo", "montag"), true);
        this.tuesdayField = new CsvColumnChoiceField(messageResolver.resolveMessage("gui.date.tuesday", new Serializable[0]), (Serializable)((Object)SubscriptionImportDto.Columns.TUESDAY), this.createRegex("di", "dienstag"), true);
        this.wednesdayField = new CsvColumnChoiceField(messageResolver.resolveMessage("gui.date.wednesday", new Serializable[0]), (Serializable)((Object)SubscriptionImportDto.Columns.WEDNESDAY), this.createRegex("mi", "mittwoch"), true);
        this.thursdayField = new CsvColumnChoiceField(messageResolver.resolveMessage("gui.date.thursday", new Serializable[0]), (Serializable)((Object)SubscriptionImportDto.Columns.THURSDAY), this.createRegex("do", "donnerstag"), true);
        this.fridayField = new CsvColumnChoiceField(messageResolver.resolveMessage("gui.date.friday", new Serializable[0]), (Serializable)((Object)SubscriptionImportDto.Columns.FRIDAY), this.createRegex("fr", "freitag"), true);
        this.saturdayField = new CsvColumnChoiceField(messageResolver.resolveMessage("gui.date.saturday", new Serializable[0]), (Serializable)((Object)SubscriptionImportDto.Columns.SATURDAY), this.createRegex("sa", "samstag"), true);
        this.sundayField = new CsvColumnChoiceField(messageResolver.resolveMessage("gui.date.sunday", new Serializable[0]), (Serializable)((Object)SubscriptionImportDto.Columns.SUNDAY), this.createRegex("so", "sonntag"), true);
        this.deleteField = new CsvColumnChoiceField(messageResolver.resolveMessageForEnum(SubscriptionImportDto.Columns.DELETE), (Serializable)((Object)SubscriptionImportDto.Columns.DELETE), this.createRegex("del", "delete", "L\u00f6schen", "zu l\u00f6schen", "entfernen"), true);
        this.subscriptionImporterBreakTimePanel = new SubscriptionImporterBreakTimePanel();
        this.emptyLayer = new BooleanField(messageResolver.resolveMessage("messages.import.subscription.layerClear", new Serializable[0]));
    }

    @Override
    protected void addCsvFields(List<CsvColumnChoiceField> choiceFields) {
        choiceFields.add(this.subscriptionNumberField);
        choiceFields.add(this.customerNumberField);
        choiceFields.add(this.firstNameField);
        choiceFields.add(this.lastNameField);
        choiceFields.add(this.companyNameField);
        choiceFields.add(this.statusField);
        choiceFields.add(this.parcelIdField);
        super.addCsvFields(choiceFields);
        choiceFields.add(this.xField);
        choiceFields.add(this.yField);
        choiceFields.add(this.areaShortcutField);
        choiceFields.add(this.subscriptionDeliveryTypeField);
        choiceFields.add(this.startDateField);
        choiceFields.add(this.endDateField);
        choiceFields.add(this.mondayField);
        choiceFields.add(this.tuesdayField);
        choiceFields.add(this.wednesdayField);
        choiceFields.add(this.thursdayField);
        choiceFields.add(this.fridayField);
        choiceFields.add(this.saturdayField);
        choiceFields.add(this.sundayField);
        choiceFields.add(this.deleteField);
    }

    @Override
    protected List<Page> getAdditionalPages() {
        List<Page> pages = super.getAdditionalPages();
        if (pages == null) {
            pages = new ArrayList<Page>(1);
        }
        Page page = new Page(ModelEnviroment.getMessageResolver().resolveMessage("messages.subscription.breakTime", new Serializable[0]));
        page.setAdditionalComponent(this.subscriptionImporterBreakTimePanel);
        pages.add(page);
        return pages;
    }

    @Override
    public String getTitle() {
        return ModelEnviroment.getMessageResolver().resolveMessage("importer.subscription.title", new Serializable[0]);
    }

    @Override
    protected List<Fieldset> getAdditionalFieldsets() {
        Fieldset geo = new Fieldset(ModelEnviroment.getMessageResolver().resolveMessage("messages.importer.subscription.geo", new Serializable[0]));
        geo.addField(this.layerField);
        geo.addField(this.emptyLayer);
        geo.addField(this.coordinateFactoryField);
        return Collections.singletonList(geo);
    }

    @Override
    protected void writeToDto(SubscriptionImportDto dto) {
        super.writeToDto(dto);
        dto.setAreaLayer((AreaLayerDto)((Object)((AreaLayerModel)this.layerField.getValue()).createDto()));
        dto.setCoordinateFactory((CoordinateFactory.Projections)((Object)this.coordinateFactoryField.getValue()));
        dto.setSource(((File)this.fileField.getValue()).getName());
        dto.setBreakTimes(this.subscriptionImporterBreakTimePanel.getBreakTimes());
        Boolean value = (Boolean)this.emptyLayer.getValue();
        dto.setEmptyLayer(PrimitiveUtil.nullToFalse(value));
    }

    @Override
    protected List<CallBack<Boolean, Window>> getAdditonalFileLeaveActions(final CsvContentGuesser contentGuesser) {
        List<CallBack<Boolean, Window>> actions2 = super.getAdditonalFileLeaveActions(contentGuesser);
        ArrayList<CallBack<Boolean, Window>> allActions = new ArrayList<CallBack<Boolean, Window>>(actions2.size() + 1);
        allActions.addAll(actions2);
        allActions.add(new CallBack<Boolean, Window>(){

            public Boolean execute(Window ... s) {
                File file = contentGuesser.getFile();
                if (file == null || !file.isFile()) {
                    throw new RuntimeException(new FileNotFoundException(file == null ? "" : file.getAbsolutePath()));
                }
                try {
                    CsvReader csvReader = new CsvReader(file, contentGuesser.getEncoding());
                    csvReader.setDelim(Character.valueOf(contentGuesser.getDelim()));
                    csvReader.setText(Character.valueOf(contentGuesser.getTextQuote()));
                    List<String> line = csvReader.readLine();
                    csvReader.close();
                    SubscriptionImporter.this.subscriptionImporterBreakTimePanel.setHeadLine(line);
                }
                catch (IOException e1) {
                    throw new RuntimeException(e1);
                }
                return true;
            }
        });
        return allActions;
    }

    protected SubscriptionImportDto getDto() {
        SubscriptionImportDto dto = new SubscriptionImportDto();
        this.writeToDto(dto);
        return dto;
    }

    @Override
    public Worker getWorker(final Window parent) {
        return new Worker(){
            private Worker.State state;
            private String resultString;

            @Override
            public void process() {
                ModelEnviroment modelEnviroment = new ModelEnviroment(null);
                StringBuilder builder = new StringBuilder();
                try {
                    Tupel result;
                    String message = ModelEnviroment.getMessageResolver().resolveMessage("messages.import.subscription.importing", new Serializable[0]);
                    AbstractAsynchronousDialog<SubscriptionImportReportDto> asynchronousDialog = new AbstractAsynchronousDialog<SubscriptionImportReportDto>(parent, message, message, 1, true, modelEnviroment){
                        private static final long serialVersionUID = -1127458576478099632L;

                        @Override
                        protected AsynchronousDto<SubscriptionImportReportDto> getAsynchronousDto(String token) {
                            return this.getModelEnviroment().getAllCaller().getAsynchronousCaller().getImportSubscriptionCsvResult(token);
                        }

                        @Override
                        protected String startAsynchronous() {
                            return this.getModelEnviroment().getAllCaller().getAsynchronousCaller().importSubscriptionCsv(SubscriptionImporter.this.getDto());
                        }
                    };
                    try {
                        result = asynchronousDialog.run();
                    }
                    catch (Exception e) {
                        if (e instanceof ClientImportException) {
                            throw (ClientImportException)e;
                        }
                        if (e instanceof RuntimeException) {
                            throw (RuntimeException)e;
                        }
                        throw new RuntimeException(e);
                    }
                    SubscriptionImportReportDto report = (SubscriptionImportReportDto)result.getElement1();
                    ClientSwingUtil.saveContentToFile(report.getContent(), parent);
                    String reportMessage = ModelEnviroment.getMessageResolver().resolveMessage("messages.importer.subscription.result", report.getNewCount(), report.getUpdatedCount(), report.getDeletedCount(), report.getUnchangedCount(), report.getRejectedCount(), report.getPostWorkCount());
                    builder.append(reportMessage).append("\n");
                    ErrorMessages errorMessages = report.getErrorMessages();
                    if (errorMessages.hasErrors()) {
                        builder.append(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.error", new Serializable[0])).append(":\n\n");
                        builder.append(ModelEnviroment.getMessageResolver().resolveMessages(errorMessages, "\n", 10));
                        this.state = Worker.State.ERROR;
                    } else {
                        this.state = Worker.State.OK;
                    }
                }
                catch (ClientImportException e) {
                    LOGGER.warn(e.getMessage(), e);
                    ErrorMessages errorMessages = e.getErrorMessages();
                    if (errorMessages != null && errorMessages.hasErrors()) {
                        builder.append(ModelEnviroment.getMessageResolver().resolveMessages(errorMessages, "\n", 10));
                    }
                    builder.append(e.getMessage());
                }
                this.resultString = builder.toString();
            }

            @Override
            public String getResultString() {
                return this.resultString;
            }

            @Override
            public Worker.State getResultState() {
                return this.state;
            }
        };
    }

    @Override
    protected List<CallBack<Boolean, Window>> getDataLeaveActions() {
        LinkedList<CallBack<Boolean, Window>> leaveActions = new LinkedList<CallBack<Boolean, Window>>(super.getDataLeaveActions());
        leaveActions.add(new CallBack<Boolean, Window>(){

            public Boolean execute(Window ... s) {
                Boolean value = (Boolean)SubscriptionImporter.this.emptyLayer.getValue();
                boolean r = true;
                if (value != null && value.booleanValue()) {
                    int d = JOptionPane.showConfirmDialog(s[0], ModelEnviroment.getMessageResolver().resolveMessage("messages.import.subscription.layerClear.question", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("messages.default.question", new Serializable[0]), 0);
                    r = d == 0;
                }
                return r;
            }
        });
        return leaveActions;
    }
}

