/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.importer.subscription;

import de.datomino.logistic.dto.LogisticQualifiedLocationDto;
import de.datomino.peppergis.client.model.base.ImportedLocationModel;
import de.datomino.peppergis.client.model.base.SubscriptionModel;
import de.datomino.peppergis.importer.subscription.ImportLocationTableCellRenderer;
import de.datomino.peppergis.type.SubscriptionImportStatus;
import java.awt.Color;
import java.awt.Component;
import java.util.Collection;
import java.util.LinkedHashMap;
import javax.swing.JTable;
import org.ktde.util.datatypes.Tupel;

public abstract class ImportSubscriptionTableCellRenderer
extends ImportLocationTableCellRenderer<SubscriptionModel> {
    public ImportSubscriptionTableCellRenderer(LinkedHashMap<LogisticQualifiedLocationDto, Tupel<Collection<SubscriptionModel>, Collection<ImportedLocationModel>>> modelMap) {
        super(modelMap);
    }

    @Override
    protected abstract boolean isSelected(int var1, int var2);

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Tupel tupel;
        SubscriptionModel first;
        Component component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        Tupel key = (Tupel)table.getValueAt(row, 0);
        if (this.modelMap != null && key != null && (first = (SubscriptionModel)((Collection)(tupel = (Tupel)this.modelMap.get(key.getElement2())).getElement1()).iterator().next()) != null) {
            SubscriptionImportStatus importStatus = first.getImportStatus();
            if (importStatus == null) {
                component.setForeground(Color.RED);
            } else {
                switch (importStatus) {
                    case CHANGED: 
                    case CHECKED: {
                        component.setForeground(Color.BLUE);
                        break;
                    }
                    case NOTCHECKED: {
                        component.setForeground(Color.GREEN.darker());
                        break;
                    }
                    default: {
                        component.setForeground(Color.RED);
                    }
                }
            }
        }
        return component;
    }
}

