/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.importer.subscription;

import de.datomino.logistic.dto.LogisticQualifiedLocationDto;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.gui.renderer.AbstractTableRenderer;
import de.datomino.peppergis.client.model.admin.UserModel;
import de.datomino.peppergis.client.model.base.ImportedLocationModel;
import de.datomino.peppergis.type.ImportedLocationStatus;
import de.datomino.peppergis.util.GeoUtil;
import de.datomino.util.geo.ImmutablePoint;
import java.awt.Color;
import java.awt.Component;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import javax.swing.BorderFactory;
import javax.swing.JTable;
import javax.swing.JTextField;
import org.ktde.util.StringUtil;
import org.ktde.util.datatypes.Tupel;

public abstract class ImportLocationTableCellRenderer<O>
extends AbstractTableRenderer {
    protected LinkedHashMap<LogisticQualifiedLocationDto, Tupel<Collection<O>, Collection<ImportedLocationModel>>> modelMap;

    public ImportLocationTableCellRenderer(LinkedHashMap<LogisticQualifiedLocationDto, Tupel<Collection<O>, Collection<ImportedLocationModel>>> stopMap) {
        this.modelMap = stopMap;
    }

    protected abstract boolean isSelected(int var1, int var2);

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component textField = this.getComponent(table, value);
        if (this.isSelected(row, column)) {
            textField.setBackground(Color.YELLOW);
        }
        if (column == 0 && textField instanceof JTextField) {
            JTextField t = (JTextField)textField;
            t.setHorizontalAlignment(0);
        }
        for (int i = 0; i < table.getColumnCount(); ++i) {
            if (!table.getColumnName(i).contains(ModelEnviroment.getMessageResolver().resolveMessage("address.matching", new Serializable[0]))) continue;
            try {
                double matching = Double.parseDouble(table.getValueAt(row, i).toString());
                if (matching != 100.0) break;
                textField.setForeground(Color.GREEN.darker());
                break;
            }
            catch (Exception matching) {
                // empty catch block
            }
        }
        Tupel key = (Tupel)table.getValueAt(row, 0);
        if (this.modelMap != null && key != null) {
            Tupel<Collection<O>, Collection<ImportedLocationModel>> tupel = this.modelMap.get(key.getElement2());
            Color color = Color.BLUE;
            block7: for (ImportedLocationModel importedLocation : tupel.getElement2()) {
                if (key.getElement2() == null || ((LogisticQualifiedLocationDto)key.getElement2()).getGeom() == null || GeoUtil.isNullPoint((ImmutablePoint)((LogisticQualifiedLocationDto)key.getElement2()).getGeom().getGeoObject())) {
                    textField.setForeground(Color.RED);
                    break;
                }
                ImportedLocationStatus importStatus = importedLocation.getStatus();
                if (importStatus == null) {
                    color = Color.BLUE;
                } else {
                    switch (importStatus) {
                        case CHANGED: 
                        case CHECKED: {
                            if (color == Color.GREEN.darker()) break;
                            color = Color.BLUE;
                            break;
                        }
                        case NOTCHECKED: {
                            color = Color.GREEN.darker();
                            break;
                        }
                        default: {
                            color = Color.RED;
                            break block7;
                        }
                    }
                }
                textField.setForeground(color);
            }
        }
        return textField;
    }

    protected Component getComponent(JTable table, Object value) {
        if (value == null) {
            value = "";
        }
        if (value instanceof Tupel) {
            value = ((Tupel)value).getElement1();
        } else if (value instanceof Collection) {
            Collection values = (Collection)value;
            ArrayList<String> strings = new ArrayList<String>(values.size());
            for (Object o : values) {
                String sValue = StringUtil.nullToEmpty(o);
                strings.add(sValue);
            }
            value = StringUtil.implode(strings, " && ");
        } else if (value instanceof UserModel) {
            value = ((UserModel)value).getName();
        }
        JTextField textField = new JTextField(value.toString());
        textField.setFont(table.getFont());
        textField.setBorder(BorderFactory.createEmptyBorder());
        return textField;
    }
}

