/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.importer.stop;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.base.ServiceModel;
import de.datomino.peppergis.client.model.base.ServiceValueDescriptorModel;
import de.datomino.util.swing.SpringUtilities;
import de.datomino.util.swing.SwingUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SpringLayout;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.ktde.util.datatypes.Tripel;
import org.ktde.util.datatypes.Tupel;

public class TourImporterServicePanel
extends JSplitPane {
    private static final long serialVersionUID = 492785664003702759L;
    private JList serviceList;
    private JTable serviceValueTable;
    private List<String> headLine;
    private ModelEnviroment modelEnviroment;
    private RemoveServiceAction removeServiceAction;
    private List<Map<String, String>> valueList = new LinkedList<Map<String, String>>();
    private Integer lastSelected;

    public TourImporterServicePanel(ModelEnviroment modelEnviroment) {
        super(1);
        this.modelEnviroment = modelEnviroment;
        this.buildLayout();
    }

    private void buildLayout() {
        JPanel listPanel = new JPanel(new BorderLayout());
        this.serviceList = new JList(new DefaultListModel());
        ListCellRenderer renderer = this.serviceList.getCellRenderer();
        this.serviceList.setCellRenderer(new ServiceRenderer(renderer));
        this.serviceList.addListSelectionListener(new ServiceSelectionListener());
        this.serviceList.setSelectionMode(0);
        listPanel.add((Component)new JScrollPane(this.serviceList), "Center");
        JPanel buttonPanel = new JPanel(new BorderLayout());
        this.removeServiceAction = new RemoveServiceAction();
        buttonPanel.add((Component)new JButton(this.removeServiceAction), "West");
        buttonPanel.add((Component)new JButton(new AddServiceAction()), "East");
        listPanel.add((Component)buttonPanel, "South");
        this.setLeftComponent(listPanel);
        this.serviceValueTable = new JTable(new ServiceValueTableModel());
        this.serviceValueTable.setSelectionMode(0);
        TableColumn column = this.serviceValueTable.getColumnModel().getColumn(1);
        final TableCellRenderer tableCellRenderer = this.serviceValueTable.getDefaultRenderer(String.class);
        column.setCellRenderer(new TableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Object nValue = value;
                if (value instanceof ValueTableEntry) {
                    ValueTableEntry valueTableEntry = (ValueTableEntry)value;
                    nValue = valueTableEntry.getOption();
                }
                return tableCellRenderer.getTableCellRendererComponent(table, nValue, isSelected, hasFocus, row, column);
            }
        });
        this.setRightComponent(this.serviceValueTable);
    }

    public void setHeadLine(List<String> headLine) {
        this.headLine = headLine;
        this.serviceValueTable.getColumnModel().getColumn(1).setCellEditor(new ValueCellEditor());
    }

    public List<Tripel<String, String, Map<String, String>>> getData() {
        if (this.lastSelected != null) {
            ServiceValueTableModel serviceValueTableModel = (ServiceValueTableModel)this.serviceValueTable.getModel();
            this.valueList.set(this.lastSelected, serviceValueTableModel.getValues());
        }
        DefaultListModel dlm = (DefaultListModel)this.serviceList.getModel();
        int size = dlm.getSize();
        ArrayList<Tripel<String, String, Map<String, String>>> list = new ArrayList<Tripel<String, String, Map<String, String>>>(size);
        Iterator<Map<String, String>> iter = this.valueList.iterator();
        for (int i = 0; i < size; ++i) {
            Tupel tupel = (Tupel)dlm.getElementAt(i);
            list.add(new Tripel(tupel.getElement1(), ((ServiceModel)tupel.getElement2()).getServiceNumber(), iter.next()));
        }
        return list;
    }

    private class ValueCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private static final long serialVersionUID = -604259925709240971L;
        private JComboBox comboBox;

        public ValueCellEditor() {
            Vector<String> vector = new Vector<String>(1 + TourImporterServicePanel.this.headLine.size());
            vector.add(" ");
            vector.addAll(TourImporterServicePanel.this.headLine);
            this.comboBox = new JComboBox(vector);
            this.comboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ValueCellEditor.this.stopCellEditing();
                }
            });
        }

        @Override
        public Object getCellEditorValue() {
            if (this.comboBox.getSelectedIndex() == 0) {
                return null;
            }
            return new ValueTableEntry((String)this.comboBox.getSelectedItem());
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            ValueTableEntry valueTableEntry = (ValueTableEntry)value;
            if (valueTableEntry == null) {
                this.comboBox.setSelectedIndex(0);
            } else {
                this.comboBox.setSelectedItem(valueTableEntry.getOption());
            }
            return this.comboBox;
        }
    }

    private class ServiceRenderer
    implements ListCellRenderer {
        private ListCellRenderer renderer;

        public ServiceRenderer(ListCellRenderer renderer) {
            this.renderer = renderer;
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Object nValue = value;
            if (value instanceof ServiceModel) {
                ServiceModel serviceModel = (ServiceModel)value;
                nValue = serviceModel.getName();
            } else if (value instanceof Tupel) {
                Tupel tupel = (Tupel)value;
                nValue = (String)tupel.getElement1() + " - " + ((ServiceModel)tupel.getElement2()).getName();
            }
            return this.renderer.getListCellRendererComponent(list, nValue, index, isSelected, cellHasFocus);
        }
    }

    private class ServiceValueTableModel
    implements TableModel {
        private ServiceModel service;
        private Map<ServiceValueDescriptorModel, ValueTableEntry> values;
        private List<TableModelListener> tableModelListeners = new LinkedList<TableModelListener>();

        private ServiceValueTableModel() {
        }

        @Override
        public int getRowCount() {
            if (this.service == null) {
                return 0;
            }
            return this.service.countServiceValueDescriptors();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return "Attribut";
                }
                case 1: {
                    return "Wert";
                }
            }
            return null;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return String.class;
                }
                case 1: {
                    return ValueTableEntry.class;
                }
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 1;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            ServiceValueDescriptorModel serviceValueDescriptor = this.getServiceValueDescriptorByRowIndex(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return serviceValueDescriptor.getName();
                }
                case 1: {
                    ValueTableEntry valueTableEntry = this.values.get(serviceValueDescriptor);
                    return valueTableEntry;
                }
            }
            return null;
        }

        private ServiceValueDescriptorModel getServiceValueDescriptorByRowIndex(int rowIndex) {
            ServiceValueDescriptorModel serviceValueDescriptor = null;
            int count = 0;
            for (ServiceValueDescriptorModel serviceValueDescriptorModel : this.service.iterableServiceValueDescriptors()) {
                if (count == rowIndex) {
                    serviceValueDescriptor = serviceValueDescriptorModel;
                    break;
                }
                ++count;
            }
            return serviceValueDescriptor;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (columnIndex == 1) {
                ServiceValueDescriptorModel serviceValueDescriptor = this.getServiceValueDescriptorByRowIndex(rowIndex);
                this.values.put(serviceValueDescriptor, (ValueTableEntry)aValue);
                TableModelEvent e = new TableModelEvent(this, rowIndex);
                this.fireTableModelChanged(e);
            }
        }

        @Override
        public void addTableModelListener(TableModelListener l) {
            this.tableModelListeners.add(l);
        }

        @Override
        public void removeTableModelListener(TableModelListener l) {
            this.tableModelListeners.remove(l);
        }

        public void clear() {
            this.values = null;
            this.service = null;
            TableModelEvent e = new TableModelEvent(this);
            this.fireTableModelChanged(e);
        }

        public void loadValues(ServiceModel service, Map<String, String> map) {
            this.clear();
            this.service = service;
            this.values = new LinkedHashMap<ServiceValueDescriptorModel, ValueTableEntry>();
            for (ServiceValueDescriptorModel serviceValueDescriptorModel : service.iterableServiceValueDescriptors()) {
                String value = map.get(serviceValueDescriptorModel.getKey());
                ValueTableEntry valueTableEntry = new ValueTableEntry(value);
                this.values.put(serviceValueDescriptorModel, valueTableEntry);
            }
            this.fireTableModelChanged(new TableModelEvent(this));
        }

        private void fireTableModelChanged(TableModelEvent e) {
            for (TableModelListener tableModelListener : this.tableModelListeners) {
                tableModelListener.tableChanged(e);
            }
        }

        public Map<String, String> getValues() {
            HashMap<String, String> map = new HashMap<String, String>();
            for (Map.Entry<ServiceValueDescriptorModel, ValueTableEntry> entry : this.values.entrySet()) {
                ValueTableEntry value = entry.getValue();
                if (value == null) continue;
                map.put(entry.getKey().getKey(), value.getOption());
            }
            return map;
        }
    }

    private class ValueTableEntry {
        private String option;

        public ValueTableEntry(String option) {
            this.option = option;
        }

        public String getOption() {
            return this.option;
        }
    }

    private class ServiceSelectionListener
    implements ListSelectionListener {
        private ServiceSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            ServiceValueTableModel serviceValueTableModel = (ServiceValueTableModel)TourImporterServicePanel.this.serviceValueTable.getModel();
            List valueList = TourImporterServicePanel.this.valueList;
            Integer lastSelected = TourImporterServicePanel.this.lastSelected;
            if (lastSelected != null) {
                valueList.set(lastSelected, serviceValueTableModel.getValues());
            }
            Tupel tupel = (Tupel)TourImporterServicePanel.this.serviceList.getSelectedValue();
            serviceValueTableModel = new ServiceValueTableModel();
            TourImporterServicePanel.this.serviceValueTable.setModel(serviceValueTableModel);
            TourImporterServicePanel.this.serviceValueTable.getColumnModel().getColumn(1).setCellEditor(new ValueCellEditor());
            TableColumn column = TourImporterServicePanel.this.serviceValueTable.getColumnModel().getColumn(1);
            final TableCellRenderer tableCellRenderer = TourImporterServicePanel.this.serviceValueTable.getDefaultRenderer(String.class);
            column.setCellRenderer(new TableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    Object nValue = value;
                    if (value instanceof ValueTableEntry) {
                        ValueTableEntry valueTableEntry = (ValueTableEntry)value;
                        nValue = valueTableEntry.getOption();
                    }
                    return tableCellRenderer.getTableCellRendererComponent(table, nValue, isSelected, hasFocus, row, column);
                }
            });
            if (tupel != null) {
                ServiceModel service = (ServiceModel)tupel.getElement2();
                Map map = (Map)valueList.get(TourImporterServicePanel.this.serviceList.getSelectedIndex());
                serviceValueTableModel.loadValues(service, map);
                TourImporterServicePanel.this.lastSelected = TourImporterServicePanel.this.serviceList.getSelectedIndex();
                TourImporterServicePanel.this.removeServiceAction.setEnabled(true);
            } else {
                TourImporterServicePanel.this.lastSelected = null;
                TourImporterServicePanel.this.removeServiceAction.setEnabled(false);
            }
        }
    }

    private class RemoveServiceAction
    extends AbstractAction {
        private static final long serialVersionUID = 9150628631714529526L;

        public RemoveServiceAction() {
            super(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.remove", new Serializable[0]));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultListModel dlm = (DefaultListModel)TourImporterServicePanel.this.serviceList.getModel();
            int[] selectedIndices = TourImporterServicePanel.this.serviceList.getSelectedIndices();
            for (int i = selectedIndices.length - 1; i >= 0; --i) {
                int index = selectedIndices[i];
                dlm.removeElementAt(index);
                TourImporterServicePanel.this.valueList.remove(index);
            }
        }
    }

    private class AddServiceAction
    extends AbstractAction {
        private static final long serialVersionUID = 5333424768562050519L;

        public AddServiceAction() {
            super(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.add", new Serializable[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            List<ServiceModel> services = TourImporterServicePanel.this.modelEnviroment.getAllCaller().getTourCaller().fetchAllServices();
            JComboBox<ServiceModel> box = new JComboBox<ServiceModel>(new Vector<ServiceModel>(services));
            box.setRenderer(new ServiceRenderer(box.getRenderer()));
            JTextField name = new JTextField();
            JPanel panel = new JPanel(new SpringLayout());
            panel.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.name", new Serializable[0])));
            panel.add(name);
            panel.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.service", new Serializable[0])));
            panel.add(box);
            SpringUtilities.makeCompactGrid(panel, 2, 2, 5, 5, 2, 2);
            int d = JOptionPane.showConfirmDialog(SwingUtils.findWindowParent(TourImporterServicePanel.this), panel, ModelEnviroment.getMessageResolver().resolveMessage("messages.default.question", new Serializable[0]), 0, 3);
            if (d == 0) {
                DefaultListModel dlm = (DefaultListModel)TourImporterServicePanel.this.serviceList.getModel();
                ServiceModel service = (ServiceModel)box.getSelectedItem();
                dlm.addElement(new Tupel<String, ServiceModel>(name.getText(), service));
                TourImporterServicePanel.this.valueList.add(this.createPreselection(service));
            }
        }

        private Map<String, String> createPreselection(ServiceModel service) {
            HashMap<String, String> map = new HashMap<String, String>();
            if (TourImporterServicePanel.this.headLine != null) {
                block0: for (ServiceValueDescriptorModel desc : service.iterableServiceValueDescriptors()) {
                    String name = desc.getName();
                    for (String head : TourImporterServicePanel.this.headLine) {
                        if (!head.trim().equalsIgnoreCase(name.trim())) continue;
                        map.put(desc.getKey(), head);
                        continue block0;
                    }
                }
            }
            return map;
        }
    }
}

