/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.importer.stop;

import de.datomino.peppergis.client.gui.asynchronous.AbstractAsynchronousDialog;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.importer.AbstractAddressCsvImporter;
import de.datomino.peppergis.client.message.EnumMessageResolverNameGenerator;
import de.datomino.peppergis.client.util.ClientSwingUtil;
import de.datomino.peppergis.dto.asynchronous.AsynchronousDto;
import de.datomino.peppergis.dto.importer.GenericCsvDto;
import de.datomino.peppergis.dto.importer.TourCsvImportDto;
import de.datomino.peppergis.dto.importer.TourImportReportDto;
import de.datomino.peppergis.importer.stop.ServiceValueFiller;
import de.datomino.peppergis.importer.stop.TourImporterServicePanel;
import de.datomino.util.assistant.editor.Worker;
import de.datomino.util.assistant.model.ChoiceField;
import de.datomino.util.assistant.model.CsvColumnChoiceField;
import de.datomino.util.assistant.model.CsvContentGuesser;
import de.datomino.util.assistant.model.Fieldset;
import de.datomino.util.assistant.model.Page;
import de.datomino.util.callback.CallBack;
import de.datomino.util.swing.SpringUtilities;
import java.awt.Window;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import org.ktde.math.projection.CoordinateFactory;
import org.ktde.util.datatypes.Quad;
import org.ktde.util.datatypes.Tripel;
import org.ktde.util.datatypes.Tupel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TourImporter
extends AbstractAddressCsvImporter<TourCsvImportDto> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TourImporter.class);
    private ModelEnviroment modelEnviroment;
    private ChoiceField<CoordinateFactory.Projections> coordinateFactoryField;
    private TourImporterServicePanel tourImporterServicePanel;
    private JCheckBox createDeliverer;
    private Window parent;

    public TourImporter(Window parent) {
        super(false, 20);
        this.parent = parent;
        this.modelEnviroment = new ModelEnviroment(parent);
        this.tourImporterServicePanel = new TourImporterServicePanel(this.modelEnviroment);
        Collection<CoordinateFactory.Projections> projections = CoordinateFactory.getListableProjections();
        CoordinateFactory.Projections[] values = new CoordinateFactory.Projections[projections.size()];
        values = projections.toArray(values);
        this.coordinateFactoryField = new ChoiceField<CoordinateFactory.Projections>(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.coordinateFactory", new Serializable[0]), values, new EnumMessageResolverNameGenerator(""), CoordinateFactory.Projections.Wgs84);
    }

    @Override
    public Worker getWorker(final Window parent) {
        return new Worker(){
            private Worker.State state;
            private TourImportReportDto tourImportResultDto;

            @Override
            public void process() {
                Tupel resultDto;
                final TourCsvImportDto tourCsvImportDto = new TourCsvImportDto();
                TourImporter.this.writeToDto(tourCsvImportDto);
                if (TourImporter.this.createDeliverer.isSelected()) {
                    tourCsvImportDto.setCreateDeliverer(true);
                }
                AbstractAsynchronousDialog<TourImportReportDto> asyncDialog = new AbstractAsynchronousDialog<TourImportReportDto>(TourImporter.this.parent, ModelEnviroment.getMessageResolver().resolveMessage("messages.import.tour.importing", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("messages.import.tour.importing", new Serializable[0]), 1, TourImporter.this.modelEnviroment){
                    private static final long serialVersionUID = -1393361866358292364L;

                    @Override
                    protected String startAsynchronous() {
                        return this.getModelEnviroment().getAllCaller().getAsynchronousCaller().importTourCsv(tourCsvImportDto);
                    }

                    @Override
                    protected AsynchronousDto<TourImportReportDto> getAsynchronousDto(String token) {
                        return this.getModelEnviroment().getAllCaller().getAsynchronousCaller().getimportTourCsvResult(token);
                    }
                };
                try {
                    resultDto = asyncDialog.run();
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage(), e);
                    throw new RuntimeException(e);
                }
                this.tourImportResultDto = (TourImportReportDto)resultDto.getElement1();
                this.state = this.tourImportResultDto.isError() ? Worker.State.ERROR : Worker.State.OK;
                ClientSwingUtil.saveContentToFile(this.tourImportResultDto.getContent(), parent);
            }

            @Override
            public String getResultString() {
                if (this.tourImportResultDto.isError()) {
                    StringBuilder sb = new StringBuilder(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.error", new Serializable[0])).append(":\n\n");
                    sb.append(ModelEnviroment.getMessageResolver().resolveMessages(this.tourImportResultDto.getErrorMessages(), "\n", 10));
                    return sb.toString();
                }
                Map<String, Quad<Integer, Integer, Integer, Integer>> stopCountMap = this.tourImportResultDto.getStopCountMap();
                int newCount = 0;
                int changedCount = 0;
                int rejectedCount = 0;
                int postWorkCount = 0;
                for (Quad<Integer, Integer, Integer, Integer> quad : stopCountMap.values()) {
                    newCount += quad.getElement1().intValue();
                    changedCount += quad.getElement2().intValue();
                    rejectedCount += quad.getElement3().intValue();
                    postWorkCount += quad.getElement4().intValue();
                }
                Quad<Integer, Integer, Integer, Integer> quad = this.tourImportResultDto.getSingleStopCountQuad();
                int stopCount = (newCount += quad.getElement1().intValue()) + (changedCount += quad.getElement2().intValue()) + (rejectedCount += quad.getElement3().intValue());
                int tourCount = stopCountMap.keySet().size();
                int nullGeomCount = this.tourImportResultDto.getNullGeomCount();
                return ModelEnviroment.getMessageResolver().resolveMessage("messages.importer.tour.result", Integer.valueOf(tourCount), Integer.valueOf(stopCount), Integer.valueOf(newCount), Integer.valueOf(changedCount), Integer.valueOf(rejectedCount), Integer.valueOf(nullGeomCount), Integer.valueOf(postWorkCount += quad.getElement4().intValue()));
            }

            @Override
            public Worker.State getResultState() {
                return this.state;
            }
        };
    }

    @Override
    protected void addCsvFields(List<CsvColumnChoiceField> choiceFields) {
        choiceFields.add(new CsvColumnChoiceField(this.getMessageForEnum(TourCsvImportDto.Columns.TOUR_NUMBER), (Serializable)((Object)TourCsvImportDto.Columns.TOUR_NUMBER), this.createRegex("tournummer", "tour", "tour-nr."), true));
        choiceFields.add(new CsvColumnChoiceField(this.getMessageForEnum(TourCsvImportDto.Columns.DELIVERER_NUMBER), (Serializable)((Object)TourCsvImportDto.Columns.DELIVERER_NUMBER), this.createRegex("Fahrernummer", "Fahrer", "Fahrer-Nr."), true));
        choiceFields.add(new CsvColumnChoiceField(this.getMessageForEnum(TourCsvImportDto.Columns.STOP_NAME), (Serializable)((Object)TourCsvImportDto.Columns.STOP_NAME), this.createRegex("name", "Ablagestellenname", "Abladestellenname", "Tourname"), false));
        choiceFields.add(new CsvColumnChoiceField(this.getMessageForEnum(TourCsvImportDto.Columns.CUSTOMER_NUMBER), (Serializable)((Object)TourCsvImportDto.Columns.CUSTOMER_NUMBER), this.createRegex("Kundennummer", "Kunden-Nr.", "Kd-Nr."), false));
        choiceFields.add(new CsvColumnChoiceField(this.getMessageForEnum(TourCsvImportDto.Columns.CUSTOMER_COMPANY_NAME), (Serializable)((Object)TourCsvImportDto.Columns.CUSTOMER_COMPANY_NAME), this.createRegex("Kundenfirmenname", "firmenname"), true));
        choiceFields.add(new CsvColumnChoiceField(this.getMessageForEnum(TourCsvImportDto.Columns.CUSTOMER_FIRST_NAME), (Serializable)((Object)TourCsvImportDto.Columns.CUSTOMER_FIRST_NAME), this.createRegex("Kundenvorname", "vorname"), true));
        choiceFields.add(new CsvColumnChoiceField(this.getMessageForEnum(TourCsvImportDto.Columns.CUSTOMER_LAST_NAME), (Serializable)((Object)TourCsvImportDto.Columns.CUSTOMER_LAST_NAME), this.createRegex("Kundennachname", "nachname", "familienname"), true));
        super.addCsvFields(choiceFields);
        choiceFields.add(new CsvColumnChoiceField(this.getMessageForEnum(TourCsvImportDto.Columns.MOBILE), (Serializable)((Object)TourCsvImportDto.Columns.MOBILE), this.createRegex("Mobil"), true));
        choiceFields.add(new CsvColumnChoiceField(this.getMessageForEnum(TourCsvImportDto.Columns.TOUR_DATE), (Serializable)((Object)TourCsvImportDto.Columns.TOUR_DATE), this.createRegex("Tour Datum", "Tourdatum"), true));
        choiceFields.add(new CsvColumnChoiceField(this.getMessageForEnum(TourCsvImportDto.Columns.START_WEIGHT), (Serializable)((Object)TourCsvImportDto.Columns.START_WEIGHT), this.createRegex("Startgewicht"), true));
        choiceFields.add(new CsvColumnChoiceField(this.getMessageForEnum(TourCsvImportDto.Columns.STOP_DURATION), (Serializable)((Object)TourCsvImportDto.Columns.STOP_DURATION), this.createRegex("Stopdauer", "Verweildauer"), true));
        choiceFields.add(new CsvColumnChoiceField(this.getMessageForEnum(GenericCsvDto.AddressColumns.X), (Serializable)((Object)GenericCsvDto.AddressColumns.X), this.createRegexForXCoordinate(), true));
        choiceFields.add(new CsvColumnChoiceField(this.getMessageForEnum(GenericCsvDto.AddressColumns.Y), (Serializable)((Object)GenericCsvDto.AddressColumns.Y), this.createRegexForYCoordinate(), true));
        choiceFields.add(new CsvColumnChoiceField(this.getMessageForEnum(TourCsvImportDto.Columns.TIME_WINDOW_START), (Serializable)((Object)TourCsvImportDto.Columns.TIME_WINDOW_START), this.createRegex("Zeitfenster Start", "Zeitfenster von"), true));
        choiceFields.add(new CsvColumnChoiceField(this.getMessageForEnum(TourCsvImportDto.Columns.TIME_WINDOW_END), (Serializable)((Object)TourCsvImportDto.Columns.TIME_WINDOW_END), this.createRegex("Zeitfenster Ende", "Zeitfenster bis"), true));
        choiceFields.add(new CsvColumnChoiceField(this.getMessageForEnum(TourCsvImportDto.Columns.IMPORT_ORDER), (Serializable)((Object)TourCsvImportDto.Columns.IMPORT_ORDER), this.createRegex("Import Reihenfolge", "Reihenfolge"), true));
        choiceFields.add(new CsvColumnChoiceField(this.getMessageForEnum(TourCsvImportDto.Columns.PP_NR), (Serializable)((Object)TourCsvImportDto.Columns.PP_NR), this.createRegex("Pickpoint-Nummer", "Pickpoint-Nr."), true));
        choiceFields.add(new CsvColumnChoiceField(this.getMessageForEnum(TourCsvImportDto.Columns.INFORMATION), (Serializable)((Object)TourCsvImportDto.Columns.INFORMATION), this.createRegex("Information", "Info"), true));
        choiceFields.add(new CsvColumnChoiceField(this.getMessageForEnum(TourCsvImportDto.Columns.PARKING_INFORMATION), (Serializable)((Object)TourCsvImportDto.Columns.PARKING_INFORMATION), this.createRegex("Parken Information", "Information Park", "Info Park"), true));
        choiceFields.add(new CsvColumnChoiceField(this.getMessageForEnum(TourCsvImportDto.Columns.DELIVERER_INFORMATION), (Serializable)((Object)TourCsvImportDto.Columns.DELIVERER_INFORMATION), this.createRegex("Fahrer Information", "Fahrer Info"), true));
        choiceFields.add(new CsvColumnChoiceField(this.getMessageForEnum(TourCsvImportDto.Columns.PHONE_NUMBER_1), (Serializable)((Object)TourCsvImportDto.Columns.PHONE_NUMBER_1), this.createRegex("ASP Tel 1"), true));
        choiceFields.add(new CsvColumnChoiceField(this.getMessageForEnum(TourCsvImportDto.Columns.FIRST_NAME_PHONE_NUMBER_1), (Serializable)((Object)TourCsvImportDto.Columns.FIRST_NAME_PHONE_NUMBER_1), this.createRegex("ASP Vorname Tel 1"), true));
        choiceFields.add(new CsvColumnChoiceField(this.getMessageForEnum(TourCsvImportDto.Columns.LAST_NAME_PHONE_NUMBER_1), (Serializable)((Object)TourCsvImportDto.Columns.LAST_NAME_PHONE_NUMBER_1), this.createRegex("ASP Nachname Tel 1"), true));
        choiceFields.add(new CsvColumnChoiceField(this.getMessageForEnum(TourCsvImportDto.Columns.PHONE_NUMBER_2), (Serializable)((Object)TourCsvImportDto.Columns.PHONE_NUMBER_2), this.createRegex("ASP Tel 2"), true));
        choiceFields.add(new CsvColumnChoiceField(this.getMessageForEnum(TourCsvImportDto.Columns.FIRST_NAME_PHONE_NUMBER_2), (Serializable)((Object)TourCsvImportDto.Columns.FIRST_NAME_PHONE_NUMBER_2), this.createRegex("ASP Vorname Tel 2"), true));
        choiceFields.add(new CsvColumnChoiceField(this.getMessageForEnum(TourCsvImportDto.Columns.LAST_NAME_PHONE_NUMBER_2), (Serializable)((Object)TourCsvImportDto.Columns.LAST_NAME_PHONE_NUMBER_2), this.createRegex("ASP Nachname Tel 2"), true));
    }

    protected String getMessageForEnum(Enum<?> value) {
        return ModelEnviroment.getMessageResolver().resolveMessage(value.getClass().getName().replace('$', '.') + "." + value.name(), new Serializable[0]);
    }

    @Override
    public String getTitle() {
        return ModelEnviroment.getMessageResolver().resolveMessage("messages.import.tourImport", new Serializable[0]);
    }

    @Override
    protected List<Fieldset> getAdditionalFieldsets() {
        Fieldset geo = new Fieldset(ModelEnviroment.getMessageResolver().resolveMessage("messages.importer.parcel.geo", new Serializable[0]));
        geo.addField(this.coordinateFactoryField);
        return Collections.singletonList(geo);
    }

    @Override
    public void writeToDto(TourCsvImportDto dto) {
        super.writeToDto(dto);
        dto.setCoordinateFactory((CoordinateFactory.Projections)((Object)this.coordinateFactoryField.getValue()));
        List<Tripel<String, String, Map<String, String>>> data = this.tourImporterServicePanel.getData();
        dto.setServiceMap(data);
    }

    @Override
    protected List<Page> getAdditionalPages() {
        List<Page> pages = super.getAdditionalPages();
        if (pages == null) {
            pages = new ArrayList<Page>(2);
        }
        Page page = new Page(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.services", new Serializable[0]));
        page.setAdditionalComponent(this.tourImporterServicePanel);
        pages.add(page);
        Page optionPage = new Page(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.other", new Serializable[0]));
        JPanel optionPane = new JPanel(new SpringLayout());
        int count = 0;
        this.createDeliverer = new JCheckBox(ModelEnviroment.getMessageResolver().resolveMessage("gui.deliverer.create", new Serializable[0]));
        optionPane.add(this.createDeliverer);
        SpringUtilities.makeCompactGrid(optionPane, ++count, 1, 5, 5, 5, 5);
        optionPage.setAdditionalComponent(optionPane);
        pages.add(optionPage);
        return pages;
    }

    @Override
    protected List<CallBack<Boolean, Window>> getAdditonalFileLeaveActions(CsvContentGuesser contentGuesser) {
        List<CallBack<Boolean, Window>> actions2 = super.getAdditonalFileLeaveActions(contentGuesser);
        ArrayList<CallBack<Boolean, Window>> allActions = new ArrayList<CallBack<Boolean, Window>>(actions2.size() + 1);
        allActions.addAll(actions2);
        allActions.add(new ServiceValueFiller(contentGuesser, this.tourImporterServicePanel));
        return allActions;
    }
}

