/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.importer.poi;

import de.datomino.logistic.dto.LogisticLocationDto;
import de.datomino.logistic.dto.LogisticQualifiedLocationDto;
import de.datomino.peppergis.client.communication.UserCaller;
import de.datomino.peppergis.client.gui.ErrorMessagesDialog;
import de.datomino.peppergis.client.gui.login.UserComboxCellEditor;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.gui.renderer.MultiLineHeaderRenderer;
import de.datomino.peppergis.client.model.UndoManager;
import de.datomino.peppergis.client.model.admin.UserModel;
import de.datomino.peppergis.client.model.base.ImportedLocationModel;
import de.datomino.peppergis.client.model.base.PoiModel;
import de.datomino.peppergis.client.util.ClientFormUtil;
import de.datomino.peppergis.client.util.LocationModelUtil;
import de.datomino.peppergis.client.util.PoiModelUtil;
import de.datomino.peppergis.exception.ValidateException;
import de.datomino.peppergis.importer.AbstractImportEditorPane;
import de.datomino.peppergis.importer.subscription.ImportLocationTableCellRenderer;
import de.datomino.peppergis.type.ImportedLocationProcess;
import de.datomino.peppergis.type.ImportedLocationStatus;
import de.datomino.peppergis.util.FormUtil;
import de.datomino.peppergis.util.GeoUtil;
import de.datomino.util.collection.CollectionUtil;
import de.datomino.util.geo.ImmutableGeoObjectFactory;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.dto.ImmutablePointDto;
import de.datomino.util.international.country.CountryUtil;
import de.datomino.util.message.MessageResolver;
import de.datomino.util.swing.ExceptionMessageDialog;
import de.datomino.util.swing.SwingUtils;
import de.datomino.util.swing.TableHeaderWithComponentLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.RowSorter;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import javax.swing.table.TableStringConverter;
import org.ktde.math.projection.Coordinate;
import org.ktde.util.StringUtil;
import org.ktde.util.datatypes.Tupel;

public class ImportPoiEditorGui
extends AbstractImportEditorPane {
    private static final long serialVersionUID = -4902573735741910897L;
    private static final int COLOFMATCHING = 9;
    private static final int COLOFEDITOR = 10;
    private static final int COLOFINFO = 11;
    private static final int COLOFPROCESS = 12;
    private static final int COLOFDELETE = 13;
    private static final int COLOFSTATUS = 14;
    private static final int SIZEOFPOICOLS = 15;
    private DefaultTableModel poiTableModel;
    private JTable poiTable;
    private LogisticQualifiedLocationDto selectedLocation;
    private LinkedHashMap<LogisticQualifiedLocationDto, Tupel<Collection<PoiModel>, Collection<ImportedLocationModel>>> poiMap;

    public ImportPoiEditorGui(ModelEnviroment modelEnviroment, Properties properties, Collection<PoiModel> pois) {
        super(modelEnviroment, properties, "importpoi.editor.address.modifiable");
        this.sizeOfFilters = 11;
        this.filters = new JComboBox[this.sizeOfFilters];
        this.matching = new JTextField();
        this.poiMap = new LinkedHashMap();
        long id = 0L;
        for (PoiModel poi : pois) {
            Tupel<Collection<PoiModel>, Collection<ImportedLocationModel>> tupel;
            if (poi == null || poi.getLocation() == null || poi.getLocation().getImportedLocation() == null) continue;
            ImportedLocationModel importedLocation = poi.getLocation().getImportedLocation();
            String countryString = importedLocation.getCountry() == null ? null : importedLocation.getCountry().getVehicleSign();
            String housenumberString = importedLocation.getHousenumber() == null ? null : String.valueOf(importedLocation.getHousenumber());
            ImmutablePointDto geom = ImmutablePointDto.create(importedLocation.getGeoLocation());
            LogisticQualifiedLocationDto qualifiedLocationDto = new LogisticQualifiedLocationDto(id++, geom, geom, CountryUtil.searchCountryFuzzy(countryString), importedLocation.getPostcode(), importedLocation.getCity(), importedLocation.getDistrict(), importedLocation.getStreet(), housenumberString, importedLocation.getHousenumberExtension(), null);
            for (LogisticQualifiedLocationDto key : this.poiMap.keySet()) {
                if (!qualifiedLocationDto.isSameAddress(key)) continue;
                qualifiedLocationDto = key;
                break;
            }
            if ((tupel = this.poiMap.get(qualifiedLocationDto)) == null) {
                tupel = new Tupel(new HashSet(), new HashSet());
                this.poiMap.put(qualifiedLocationDto, tupel);
            }
            tupel.getElement1().add(poi);
            tupel.getElement2().add(importedLocation);
        }
        this.fillPoiTable(true);
    }

    @Override
    protected JComponent createTopPanel(JPanel undoManagerPane) {
        UndoManager undoManager = this.getModelEnviroment().getUndoManager();
        undoManager.joinTransaction();
        undoManager.startTransaction();
        JButton poiSaveButton = new JButton(new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.save", new Serializable[0])){
            private static final long serialVersionUID = 7997838507322056329L;

            @Override
            public void actionPerformed(ActionEvent arg0) {
                String error = ImportPoiEditorGui.this.storePois();
                if (error != null) {
                    ErrorMessagesDialog.creatAndShow(error, ImportPoiEditorGui.this.poiTable);
                    return;
                }
            }
        });
        JButton poiSaveCloseButton = new JButton(new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessages(CollectionUtil.buildArrayList("messages.default.save", "messages.default.and", "messages.default.close"), new String[0])){
            private static final long serialVersionUID = 7997838507322056329L;

            @Override
            public void actionPerformed(ActionEvent arg0) {
                String error = ImportPoiEditorGui.this.storePois();
                if (error != null) {
                    ErrorMessagesDialog.creatAndShow(error, ImportPoiEditorGui.this.poiTable);
                    return;
                }
                ImportPoiEditorGui.this.doClosing();
            }
        });
        this.poiTableModel = new AbstractImportEditorPane.EditableCellTableModel((Object[][])null, (Object[])this.createPoiColumnHeader()){
            private static final long serialVersionUID = -7303399097622832244L;

            @Override
            protected int[] getEditableColumns() {
                return new int[]{1, 10, 11, 12, 14, 15, 16, 17, 18, 19, 20};
            }
        };
        this.poiTable = new JTable(this.poiTableModel){
            private static final long serialVersionUID = -2499573455000248830L;

            @Override
            public Class<?> getColumnClass(int column) {
                switch (column) {
                    case 0: {
                        return Integer.class;
                    }
                    case 12: 
                    case 13: 
                    case 14: {
                        return Boolean.class;
                    }
                }
                return super.getColumnClass(column);
            }
        };
        this.poiTable.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                int firstRow = e.getFirstRow();
                if (e.getType() == 0 && firstRow == e.getLastRow()) {
                    int row = firstRow;
                    int col = e.getColumn();
                    Boolean value = null;
                    int oCol1 = -1;
                    int oCol2 = -1;
                    switch (col) {
                        case 12: {
                            oCol1 = 13;
                            oCol2 = 14;
                            break;
                        }
                        case 13: {
                            oCol1 = 12;
                            oCol2 = 14;
                            break;
                        }
                        case 14: {
                            oCol1 = 12;
                            oCol2 = 13;
                        }
                    }
                    if (oCol1 >= 0 && oCol2 >= 0) {
                        value = (Boolean)ImportPoiEditorGui.this.poiTable.getValueAt(row, col);
                        if (value == null) {
                            value = false;
                        }
                        if (value != null && value.booleanValue()) {
                            ImportPoiEditorGui.this.poiTable.setValueAt(false, row, oCol1);
                            ImportPoiEditorGui.this.poiTable.setValueAt(false, row, oCol2);
                        }
                    }
                }
            }
        });
        this.poiTable.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.poiTable.getSelectionModel().setSelectionMode(0);
        this.poiTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int selectedRow = ImportPoiEditorGui.this.poiTable.getSelectedRow();
                if (selectedRow > -1) {
                    Tupel selected = (Tupel)ImportPoiEditorGui.this.poiTable.getValueAt(selectedRow, 0);
                    ImportPoiEditorGui.this.selectedLocation = (LogisticQualifiedLocationDto)selected.getElement2();
                    ImportPoiEditorGui.this.fillAddress();
                    int selectedCol = ImportPoiEditorGui.this.poiTable.getSelectedColumn();
                    if (selectedCol == 14) {
                        ImportPoiEditorGui.this.updateImportLocationStatus(selectedRow, (LogisticQualifiedLocationDto)selected.getElement2());
                    } else if (selectedCol == 12) {
                        ImportPoiEditorGui.this.updateImportLocationlProcess(selectedRow, (LogisticQualifiedLocationDto)selected.getElement2());
                    } else if (selectedCol == 13) {
                        ImportPoiEditorGui.this.updateLocationDelete(selectedRow);
                    }
                }
                ImportPoiEditorGui.this.poiTable.clearSelection();
            }
        });
        JPanel poiPanel = new JPanel(new BorderLayout());
        poiPanel.add((Component)new JScrollPane(this.poiTable), "Center");
        JPanel poiButtonPanel = new JPanel(new BorderLayout());
        JPanel poiButtonPaneLeft = new JPanel(new FlowLayout());
        poiButtonPaneLeft.add(this.createPasteCoordinateButton());
        poiButtonPanel.add((Component)poiButtonPaneLeft, "West");
        JPanel poiButtonPaneRight = new JPanel(new FlowLayout());
        poiButtonPaneRight.add(poiSaveButton);
        poiButtonPaneRight.add(poiSaveCloseButton);
        poiButtonPaneRight.add(new JButton(new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("buttons.cancel", new Serializable[0])){
            private static final long serialVersionUID = 4879922383719130422L;

            @Override
            public void actionPerformed(ActionEvent arg0) {
                UndoManager undoManager = ImportPoiEditorGui.this.getModelEnviroment().getUndoManager();
                undoManager.rollbackTransaction();
                ImportPoiEditorGui.this.doClosing();
            }
        }));
        poiButtonPanel.add((Component)poiButtonPaneRight, "East");
        poiPanel.add((Component)poiButtonPanel, "South");
        return poiPanel;
    }

    private void updateLocationDelete(int row) {
        Object o = this.poiTable.getValueAt(row, 13);
        if (!((Boolean)o).booleanValue()) {
            this.poiTable.setValueAt(Boolean.TRUE, row, 13);
        } else {
            this.poiTable.setValueAt(Boolean.FALSE, row, 13);
        }
        this.poiTable.repaint(10L);
    }

    private void updateImportLocationlProcess(int row, LogisticQualifiedLocationDto locationDto) {
        Tupel<Collection<PoiModel>, Collection<ImportedLocationModel>> tupel = this.poiMap.get(locationDto);
        ImportedLocationProcess process = null;
        ImportedLocationStatus status = null;
        Object o = this.poiTable.getValueAt(row, 12);
        if (!((Boolean)o).booleanValue()) {
            process = ImportedLocationProcess.INPROGRESS;
            this.poiTable.setValueAt(Boolean.TRUE, row, 12);
            status = ImportedLocationStatus.NOTCHECKED;
        } else {
            process = ImportedLocationProcess.OPEN;
            this.poiTable.setValueAt(Boolean.FALSE, row, 12);
        }
        for (ImportedLocationModel il : tupel.getElement2()) {
            if (process != null) {
                il.setProcess(process);
            }
            if (status == null) continue;
            il.setStatus(status);
        }
        this.poiTable.repaint(10L);
    }

    private void updateImportLocationStatus(int row, LogisticQualifiedLocationDto locationDto) {
        Tupel<Collection<PoiModel>, Collection<ImportedLocationModel>> tupel = this.poiMap.get(locationDto);
        ImportedLocationProcess process = null;
        ImportedLocationStatus status = null;
        Object o = this.poiTable.getValueAt(row, 14);
        if (!GeoUtil.isNullPoint((ImmutablePoint)locationDto.getGeom().getGeoObject())) {
            if (((Boolean)o).booleanValue()) {
                status = ImportedLocationStatus.NOTCHECKED;
                this.poiTable.setValueAt(Boolean.FALSE, row, 14);
            } else {
                status = ImportedLocationStatus.CHECKED;
                this.poiTable.setValueAt(Boolean.TRUE, row, 14);
                process = ImportedLocationProcess.OPEN;
            }
        } else {
            status = ImportedLocationStatus.NOTCHANGED;
            this.poiTable.setValueAt(Boolean.FALSE, row, 14);
            JOptionPane.showMessageDialog(this, "Der Fixpunkt hat noch keine Koordinate.", "", 2);
        }
        for (ImportedLocationModel il : tupel.getElement2()) {
            if (process != null) {
                il.setProcess(process);
            }
            if (status == null) continue;
            il.setStatus(status);
        }
        this.poiTable.repaint(10L);
    }

    private void doClosing() {
        UndoManager undoManager = this.getModelEnviroment().getUndoManager();
        undoManager.rollbackTransaction();
        Window window = SwingUtils.findWindowParent(this);
        if (window != null) {
            window.dispose();
        } else {
            this.setVisible(false);
        }
        this.getModelEnviroment().close();
    }

    private boolean hasPendingChanges() {
        for (LogisticQualifiedLocationDto qualifiedLocation : this.poiMap.keySet()) {
            if (qualifiedLocation.getMatching() == null || !qualifiedLocation.getMatching().equals(100.0)) continue;
            ImportedLocationModel importedLocation = this.poiMap.get(qualifiedLocation).getElement2().iterator().next();
            if (this.addressModifiable && LocationModelUtil.changedAddress(importedLocation, (LogisticLocationDto<Long>)qualifiedLocation)) {
                return true;
            }
            ImmutablePointDto geom = qualifiedLocation.getGeom();
            if (geom == null || GeoUtil.isNullPoint((ImmutablePoint)geom.getGeoObject()) || GeoUtil.areSamedPoints((ImmutablePoint)geom.getGeoObject(), importedLocation.getGeoLocation(), (Double)1.0)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String storePois() {
        if (!this.deletePois()) {
            return "Die ausgew\u00e4hlten Fixpunkte k\u00f6nnen nicht gel\u00f6scht werden";
        }
        for (LogisticQualifiedLocationDto qualifiedLocation : this.poiMap.keySet()) {
            Object valueInfo = null;
            for (int row = 0; row < this.poiTable.getRowCount(); ++row) {
                LogisticQualifiedLocationDto dto = (LogisticQualifiedLocationDto)((Tupel)this.poiTable.getValueAt(row, 0)).getElement2();
                if (!dto.equals(qualifiedLocation)) continue;
                valueInfo = this.poiTable.getValueAt(row, 11);
            }
            for (ImportedLocationModel importedLocation : this.poiMap.get(qualifiedLocation).getElement2()) {
                String newInfo;
                String oldInfo;
                if (qualifiedLocation.getMatching() != null && qualifiedLocation.getMatching().equals(100.0)) {
                    ImmutablePointDto geom;
                    if (this.addressModifiable && LocationModelUtil.changedAddress(importedLocation, (LogisticLocationDto<Long>)qualifiedLocation)) {
                        importedLocation.setCountry(qualifiedLocation.getCountry());
                        importedLocation.setCity(qualifiedLocation.getCity());
                        importedLocation.setPostcode(qualifiedLocation.getPostcode());
                        importedLocation.setStreet(qualifiedLocation.getStreet());
                        importedLocation.setHousenumber(Integer.valueOf(qualifiedLocation.getHousenumber()));
                        importedLocation.setHousenumberExtension(qualifiedLocation.getExtension());
                    }
                    if ((geom = qualifiedLocation.getGeom()) != null && !GeoUtil.isNullPoint((ImmutablePoint)geom.getGeoObject()) && !GeoUtil.areSamedPoints((ImmutablePoint)geom.getGeoObject(), importedLocation.getGeoLocation(), (Double)0.0)) {
                        importedLocation.setGeoLocation((ImmutablePoint)geom.getGeoObject());
                        if (importedLocation.getStatus() == null || importedLocation.getStatus() == ImportedLocationStatus.NOTCHANGED) {
                            importedLocation.setStatus(ImportedLocationStatus.NOTCHECKED);
                        }
                    }
                }
                if ((oldInfo = importedLocation.getInformation() == null ? "" : importedLocation.getInformation().trim()).equals(newInfo = valueInfo == null ? "" : valueInfo.toString().trim())) continue;
                importedLocation.setInformation(newInfo);
            }
        }
        UndoManager undoManager = this.getModelEnviroment().getUndoManager();
        UserModel loginUser = ModelEnviroment.getUserInformation().getUserModel();
        Collection<ImportedLocationModel> changedImportedLocations = undoManager.getChangedObjects(ImportedLocationModel.class);
        for (ImportedLocationModel il : changedImportedLocations) {
            il.setLoginUser(loginUser);
        }
        undoManager.finishTransaction("check pois");
        String error = null;
        try {
            undoManager.storeTransactions();
        }
        catch (ValidateException e) {
            undoManager.rollbackTransaction();
            error = e.getMessage();
        }
        finally {
            undoManager.joinTransaction();
            undoManager.startTransaction();
        }
        return error;
    }

    private boolean deletePois() {
        LinkedList forDelete = new LinkedList();
        for (int row = 0; row < this.poiTableModel.getRowCount(); ++row) {
            Boolean delete = (Boolean)this.poiTableModel.getValueAt(row, 13);
            if (delete == null || !delete.booleanValue()) continue;
            Tupel tupel = (Tupel)this.poiTable.getValueAt(row, 0);
            forDelete.add(new Tupel(row, tupel.getElement2()));
        }
        if (forDelete.size() == 0) {
            return true;
        }
        Collections.reverse(forDelete);
        int d = JOptionPane.showConfirmDialog(this, "Alle markierten Fixpunkte werden gel\u00f6scht. Wollen Sie es fortsetzen?", ModelEnviroment.getMessageResolver().resolveMessage("messages.default.confirm", new Serializable[0]), 0);
        switch (d) {
            case 0: {
                UndoManager undoManager = this.getModelEnviroment().getUndoManager();
                undoManager.joinTransaction();
                undoManager.startTransaction();
                for (Tupel tupel : forDelete) {
                    Tupel<Collection<PoiModel>, Collection<ImportedLocationModel>> tupel2 = this.poiMap.get(tupel.getElement2());
                    try {
                        for (PoiModel poi : tupel2.getElement1()) {
                            PoiModelUtil.deletePoi(poi, this.getModelEnviroment(), true);
                        }
                        this.poiTableModel.removeRow((Integer)tupel.getElement1());
                        this.poiMap.remove(tupel);
                    }
                    catch (Exception e) {
                        BufferedImage image;
                        try {
                            image = ImageIO.read(ImportPoiEditorGui.class.getResourceAsStream("/images/pepper.png"));
                        }
                        catch (IOException ioEx) {
                            throw new RuntimeException(ioEx);
                        }
                        ExceptionMessageDialog exceptionMessageDialog = new ExceptionMessageDialog(SwingUtils.findWindowParent(this), e, image);
                        exceptionMessageDialog.setVisible(true);
                        return false;
                    }
                }
                return true;
            }
        }
        return false;
    }

    @Override
    protected void store() {
        UndoManager undoManager = this.getModelEnviroment().getUndoManager();
        undoManager.startTransaction();
        if (this.selectedLocation != null && this.coordinate != null) {
            LogisticQualifiedLocationDto location = this.selectedLocation;
            if (this.addressModifiable) {
                location.setCountry(this.country.getText());
                location.setCity(this.city.getText());
                location.setPostcode(this.postcode.getText());
                location.setStreet(this.street.getText());
                location.setHousenumber(this.housenumber.getText());
                location.setExtension(this.housenumberExtension.getText());
            }
            Double matchingValue = null;
            try {
                matchingValue = Double.parseDouble(this.matching.getText());
            }
            catch (Exception exception) {
                // empty catch block
            }
            ImmutablePoint point = ImmutableGeoObjectFactory.createImmutablePoint(this.coordinate);
            if (!GeoUtil.isNullPoint(point)) {
                Double currentX = (Double)this.coordinateX.getValue();
                Double currentY = (Double)this.coordinateY.getValue();
                if (currentX == null || !currentX.equals(this.coordinate.getX()) || currentY == null || !currentY.equals(this.coordinate.getY())) {
                    JOptionPane.showMessageDialog(this.getParent(), "Bitte die richtige Koordinate \u00fcbernehmen");
                } else {
                    location.setGeom(ImmutablePointDto.create(point));
                    location.setMatching(matchingValue);
                }
            }
        }
        this.fillPoiTable(false);
        this.poiTable.repaint(10L);
    }

    protected void fillAddress() {
        this.clearAddress();
        try {
            LogisticQualifiedLocationDto location = this.selectedLocation;
            String countryString = location.getCountry() == null ? "" : location.getCountry().getIso3166_2();
            this.country.setText(FormUtil.getStringDisplay(countryString));
            this.city.setText(FormUtil.getStringDisplay(location.getCity()));
            this.postcode.setText(FormUtil.getStringDisplay(location.getPostcode()));
            this.street.setText(FormUtil.getStringDisplay(location.getStreet()));
            this.district.setText(FormUtil.getStringDisplay(location.getDistrict()));
            this.housenumber.setText(FormUtil.getStringDisplay(location.getHousenumber()));
            this.housenumberExtension.setText(FormUtil.getStringDisplay(location.getExtension()));
            this.matching1.setText(ClientFormUtil.getNumberString(location.getMatching()));
            this.coordinateEditorMapPane.setCoordinate(((ImmutablePoint)location.getGeom().getGeoObject()).getCoordinate(), true);
            this.coordinateEditorMapPane.gotoCoordinate();
            Coordinate c = this.coordinateEditorMapPane.getCoordinateOnMap();
            this.coordinateX.setValue(c.getX());
            this.coordinateY.setValue(c.getY());
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.coordinateEditorMapPane.getNavigatorPanel().repaint(10L);
    }

    private void fillPoiTable(boolean initFilters) {
        Object[][] dataVector = this.createPoiDataVector();
        this.filters[9] = this.createFilterComoBox(dataVector, 9);
        this.fillFilters(dataVector, initFilters);
        this.poiTableModel.setDataVector(dataVector, this.createPoiColumnHeader());
        this.poiTableModel.fireTableDataChanged();
        this.poiTable.setRowSorter((RowSorter<? extends TableModel>)new TableRowSorter<TableModel>((TableModel)this.poiTableModel){

            @Override
            public Comparator<?> getComparator(int column) {
                if (column == 0) {
                    return new Comparator<String>(){

                        @Override
                        public int compare(String o1, String o2) {
                            return Integer.parseInt(o1) - Integer.parseInt(o2);
                        }
                    };
                }
                return super.getComparator(column);
            }
        });
        ((TableRowSorter)this.poiTable.getRowSorter()).setStringConverter(new TableStringConverter(){

            @Override
            public String toString(TableModel model, int row, int column) {
                String string;
                Object value = model.getValueAt(row, column);
                String string2 = string = value == null ? "" : value.toString();
                if (column == 0) {
                    Tupel tupel = (Tupel)value;
                    string = String.valueOf(tupel.getElement1());
                }
                return string;
            }
        });
        this.setPoiTableStyle(this.poiTable);
        this.addTabelCellComponents();
    }

    private void addTabelCellComponents() {
        UserCaller userCaller = this.getModelEnviroment().getAllCaller().getUserCaller();
        List<UserModel> allUsers = userCaller.getAllUsers();
        UserComboxCellEditor userEditor = new UserComboxCellEditor(this.poiTable){

            @Override
            protected void afterChange(int row, UserModel user) {
                Tupel tupel = (Tupel)ImportPoiEditorGui.this.poiTable.getValueAt(row, 0);
                Collection ils = (Collection)((Tupel)ImportPoiEditorGui.this.poiMap.get(tupel.getElement2())).getElement2();
                for (ImportedLocationModel ip : ils) {
                    UserModel editorUser;
                    UserModel userModel = editorUser = ip == null ? null : ip.getEditorUser();
                    if (ip == null || editorUser != null && editorUser.equals(user)) continue;
                    ip.setEditorUser(user);
                }
                String newItem = user.getName();
                boolean found = false;
                int index = 0;
                ComboBoxModel comboBoxModel = ImportPoiEditorGui.this.filters[10].getModel();
                for (int i = 0; i < comboBoxModel.getSize(); ++i) {
                    Object item = comboBoxModel.getElementAt(i);
                    int compare = FILTER_COMPARATOR.compare(item, newItem);
                    if (compare < 0) {
                        ++index;
                    }
                    if (item == null || !item.equals(newItem)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    ImportPoiEditorGui.this.filters[10].insertItemAt(newItem, index);
                }
                ImportPoiEditorGui.this.poiTable.setValueAt(newItem, row, 10);
                ImportPoiEditorGui.this.poiTable.repaint(10L);
            }
        };
        for (int row = 0; row < this.poiTable.getRowCount(); ++row) {
            userEditor.setEditorAt(row, allUsers);
        }
        this.poiTable.getColumnModel().getColumn(10).setCellEditor(userEditor);
    }

    private Object[][] createPoiDataVector() {
        LinkedList<LogisticQualifiedLocationDto> filted = new LinkedList<LogisticQualifiedLocationDto>();
        for (LogisticQualifiedLocationDto l : this.poiMap.keySet()) {
            if (!this.inFilters(l)) continue;
            filted.add(l);
        }
        Object[][] dataVector = new Object[filted.size()][15];
        int row = 0;
        for (LogisticQualifiedLocationDto l : filted) {
            dataVector[row] = this.createPoiRowData(l, row);
            ++row;
        }
        return dataVector;
    }

    private Object[] createPoiRowData(LogisticQualifiedLocationDto locationDto, int row) {
        Object[] rowData = new Object[15];
        try {
            Tupel<Collection<PoiModel>, Collection<ImportedLocationModel>> tupel = this.poiMap.get(locationDto);
            rowData[0] = new Tupel<String, LogisticQualifiedLocationDto>(String.valueOf(row + 1), locationDto);
            Collection<PoiModel> pois = tupel.getElement1();
            ArrayList<String> poiNumbers = new ArrayList<String>(pois.size());
            for (PoiModel poi : pois) {
                poiNumbers.add(poi.getPoiNumber());
            }
            rowData[1] = StringUtil.implode(poiNumbers, ", ");
            rowData[2] = locationDto.getCountry() == null ? "" : locationDto.getCountry().getIso3166_2();
            rowData[3] = locationDto.getPostcode();
            rowData[4] = locationDto.getCity();
            rowData[5] = locationDto.getDistrict();
            rowData[6] = locationDto.getStreet();
            rowData[7] = locationDto.getHousenumber();
            rowData[8] = locationDto.getExtension();
            rowData[9] = locationDto.getMatching();
            UserModel editorUser = null;
            String info = null;
            for (ImportedLocationModel il : tupel.getElement2()) {
                if (il.getEditorUser() != null) {
                    editorUser = il.getEditorUser();
                }
                if (il.getInformation() == null) continue;
                info = il.getInformation();
            }
            rowData[10] = editorUser == null ? "" : editorUser.getName();
            rowData[11] = info;
            ImportedLocationProcess process = ImportedLocationProcess.OPEN;
            ImportedLocationStatus status = ImportedLocationStatus.NOTCHANGED;
            for (ImportedLocationModel il : tupel.getElement2()) {
                if (il.getProcess() != null) {
                    process = il.getProcess();
                }
                if (il.getStatus() == null) continue;
                status = il.getStatus();
            }
            rowData[12] = process == ImportedLocationProcess.INPROGRESS;
            rowData[13] = false;
            rowData[14] = status == ImportedLocationStatus.CHECKED || status == ImportedLocationStatus.CHANGED;
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return rowData;
    }

    private void setPoiTableStyle(JTable poiTable) {
        poiTable.setCellSelectionEnabled(false);
        poiTable.setRowHeight(40);
        poiTable.setRowMargin(5);
        poiTable.getColumnModel().getColumn(0).setPreferredWidth(20);
        poiTable.getColumnModel().getColumn(1).setPreferredWidth(50);
        poiTable.getColumnModel().getColumn(2).setPreferredWidth(15);
        poiTable.getColumnModel().getColumn(3).setPreferredWidth(50);
        poiTable.getColumnModel().getColumn(4).setPreferredWidth(100);
        poiTable.getColumnModel().getColumn(5).setPreferredWidth(100);
        poiTable.getColumnModel().getColumn(6).setPreferredWidth(200);
        poiTable.getColumnModel().getColumn(7).setPreferredWidth(50);
        poiTable.getColumnModel().getColumn(8).setPreferredWidth(50);
        poiTable.getColumnModel().getColumn(9).setPreferredWidth(70);
        poiTable.getColumnModel().getColumn(10).setPreferredWidth(50);
        poiTable.getColumnModel().getColumn(11).setPreferredWidth(100);
        poiTable.getColumnModel().getColumn(12).setPreferredWidth(30);
        poiTable.getColumnModel().getColumn(13).setPreferredWidth(30);
        poiTable.getColumnModel().getColumn(14).setPreferredWidth(30);
        MultiLineHeaderRenderer headerHenderer = new MultiLineHeaderRenderer();
        Enumeration<TableColumn> enumeration = poiTable.getColumnModel().getColumns();
        int columnIndex = 0;
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            tableColumn.setHeaderRenderer(headerHenderer);
            if (columnIndex < 12) {
                tableColumn.setCellRenderer(new ImportLocationTableCellRenderer<PoiModel>(this.poiMap){

                    @Override
                    protected boolean isSelected(int row, int column) {
                        Tupel valueAt;
                        return row > -1 && (valueAt = (Tupel)ImportPoiEditorGui.this.poiTable.getValueAt(row, 0)) != null && ((LogisticQualifiedLocationDto)valueAt.getElement2()).equals(ImportPoiEditorGui.this.selectedLocation);
                    }
                });
            }
            ++columnIndex;
        }
        JTableHeader th = this.poiTable.getTableHeader();
        th.setLayout(new TableHeaderWithComponentLayout());
        th.add((Component)new JButton(new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("buttons.clear", new Serializable[0])){
            private static final long serialVersionUID = -6258824252005279477L;

            @Override
            public void actionPerformed(ActionEvent arg0) {
                for (int i = 0; i < ImportPoiEditorGui.this.filters.length; ++i) {
                    JComboBox comboBox = ImportPoiEditorGui.this.filters[i];
                    if (comboBox == null) continue;
                    comboBox.setSelectedIndex(0);
                }
                ImportPoiEditorGui.this.sortAndFilter();
            }
        }), (Object)0);
        for (int i = 1; i < this.sizeOfFilters; ++i) {
            th.add((Component)this.filters[i], (Object)i);
        }
        th.add((Component)new JLabel(""), (Object)11);
        th.add((Component)new JLabel(""), (Object)12);
        JCheckBox deleteAll = new JCheckBox(new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.all", new Serializable[0])){
            private static final long serialVersionUID = -342150695528817526L;

            @Override
            public void actionPerformed(ActionEvent e) {
                JCheckBox source = (JCheckBox)e.getSource();
                for (int row = 0; row < ImportPoiEditorGui.this.poiTableModel.getRowCount(); ++row) {
                    ImportPoiEditorGui.this.poiTableModel.setValueAt(source.isSelected(), row, 13);
                }
                ImportPoiEditorGui.this.poiTable.repaint(10L);
            }
        });
        deleteAll.setFont(UIManager.getDefaults().getFont("TextField.font"));
        th.add((Component)deleteAll, (Object)13);
    }

    private String[] createPoiColumnHeader() {
        String[] columnHeader = new String[15];
        columnHeader[0] = " \n#\n \n \n";
        MessageResolver messageResolver = ModelEnviroment.getMessageResolver();
        columnHeader[1] = this.getFormatedString(messageResolver.resolveMessage("messages.poi", new Serializable[0]));
        columnHeader[2] = this.getFormatedString(messageResolver.resolveMessage("address.country", new Serializable[0]));
        columnHeader[3] = this.getFormatedString(messageResolver.resolveMessage("address.postcode", new Serializable[0]));
        columnHeader[4] = this.getFormatedString(messageResolver.resolveMessage("address.city", new Serializable[0]));
        columnHeader[5] = this.getFormatedString(messageResolver.resolveMessage("address.district", new Serializable[0]));
        columnHeader[6] = this.getFormatedString(messageResolver.resolveMessage("address.street", new Serializable[0]));
        columnHeader[7] = this.getFormatedString(messageResolver.resolveMessage("address.housenumber", new Serializable[0]));
        columnHeader[8] = this.getFormatedString(messageResolver.resolveMessage("address.housenumberExt", new Serializable[0]));
        columnHeader[9] = this.getFormatedString(messageResolver.resolveMessage("address.matching", new Serializable[0]));
        columnHeader[10] = " \n" + messageResolver.resolveMessage("messages.default.editor", new Serializable[0]);
        columnHeader[11] = " \n" + messageResolver.resolveMessage("messages.default.information", new Serializable[0]);
        columnHeader[12] = " \n" + messageResolver.resolveMessage("messages.default.inprogress", new Serializable[0]);
        columnHeader[13] = " \n" + messageResolver.resolveMessage("messages.default.delete", new Serializable[0]);
        columnHeader[14] = " \n" + messageResolver.resolveMessage("messages.default.take", new Serializable[0]);
        return columnHeader;
    }

    @Override
    protected void sortAndFilter() {
        this.poiTable.removeAll();
        this.fillPoiTable(false);
        this.poiTable.repaint(10L);
    }

    private boolean inFilters(LogisticQualifiedLocationDto importedLocation) {
        for (int column = 1; column < this.sizeOfFilters; ++column) {
            String o;
            JComboBox jComboBox = this.filters[column];
            if (jComboBox == null || jComboBox.getSelectedItem() == null) continue;
            Object s = jComboBox.getSelectedItem();
            Object[] os = this.createPoiRowData(importedLocation, 0);
            String string = o = os[column] == null ? "" : os[column];
            if (!(o instanceof Collection ? !((Collection)((Object)o)).contains(s) : !o.equals(s))) continue;
            return false;
        }
        return true;
    }

    public void showDialog(String titel, final Component parent) {
        JDialog dialog = new JDialog(SwingUtils.findWindowParent(parent));
        try {
            dialog.setIconImage(ImageIO.read(ImportPoiEditorGui.class.getResourceAsStream("/images/pepper.png")));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        dialog.setPreferredSize(new Dimension(1860, 850));
        dialog.setDefaultCloseOperation(0);
        dialog.setTitle(titel);
        dialog.getContentPane().add(this);
        dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                UndoManager undoManager = ImportPoiEditorGui.this.getModelEnviroment().getUndoManager();
                if (ImportPoiEditorGui.this.hasPendingChanges()) {
                    int d = JOptionPane.showConfirmDialog(parent, ModelEnviroment.getMessageResolver().resolveMessage("gui.poi.saveBeforeClose", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("messages.default.question", new Serializable[0]), 1, 3);
                    switch (d) {
                        case 0: {
                            String error = ImportPoiEditorGui.this.storePois();
                            if (error != null) {
                                ErrorMessagesDialog.creatAndShow(error, ImportPoiEditorGui.this.poiTable);
                                return;
                            }
                            ImportPoiEditorGui.this.doClosing();
                            break;
                        }
                        case 1: {
                            undoManager.rollbackTransaction();
                            ImportPoiEditorGui.this.doClosing();
                            break;
                        }
                        case 2: {
                            return;
                        }
                    }
                } else {
                    undoManager.rollbackTransaction();
                    ImportPoiEditorGui.this.doClosing();
                }
            }
        });
        dialog.pack();
        SwingUtils.centerDialog(dialog, parent);
        dialog.setVisible(true);
    }

    @Override
    protected void doAfterFindingCoordinate(ImmutablePoint point) {
    }
}

