/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.importer.parcel.multiple;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.map.CityModel;
import de.datomino.peppergis.client.model.map.DistrictModel;
import de.datomino.peppergis.client.model.map.ParcelModel;
import de.datomino.peppergis.client.model.map.PostcodeDistrictRelationModel;
import de.datomino.peppergis.client.model.map.PostcodeModel;
import de.datomino.peppergis.client.model.map.StreetModel;
import de.datomino.util.common.PrimitiveUtil;
import de.datomino.util.geo.ImmutableGeoObjectFactory;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.message.MessageResolver;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.ktde.math.projection.Wgs84Factory;
import org.ktde.util.datatypes.Tupel;

public class MultipleParcelTableModel
implements TableModel {
    private List<Tupel<ParcelModel, ParcelModel>> multiples;
    private List<Tupel<Boolean, Boolean>> bools;
    private List<TableModelListener> listeners = new LinkedList<TableModelListener>();

    public MultipleParcelTableModel(List<Tupel<ParcelModel, ParcelModel>> multiples) {
        this.multiples = multiples;
        this.bools = new ArrayList<Tupel<Boolean, Boolean>>(this.multiples.size());
        for (int i = 0; i < this.multiples.size(); ++i) {
            this.bools.add(new Tupel<Boolean, Boolean>(true, true));
        }
    }

    @Override
    public int getRowCount() {
        return this.multiples.size();
    }

    @Override
    public int getColumnCount() {
        return 15;
    }

    @Override
    public String getColumnName(int columnIndex) {
        MessageResolver messageResolver = ModelEnviroment.getMessageResolver();
        switch (columnIndex) {
            case 0: {
                return messageResolver.resolveMessage("messages.parcel.key", new Serializable[0]) + " 1";
            }
            case 1: {
                return messageResolver.resolveMessage("messages.parcel.key", new Serializable[0]) + " 2";
            }
            case 2: {
                return messageResolver.resolveMessage("address.country", new Serializable[0]);
            }
            case 3: {
                return messageResolver.resolveMessage("address.postcode", new Serializable[0]);
            }
            case 4: {
                return messageResolver.resolveMessage("address.city", new Serializable[0]);
            }
            case 5: {
                return messageResolver.resolveMessage("address.district", new Serializable[0]);
            }
            case 6: {
                return messageResolver.resolveMessage("address.street", new Serializable[0]);
            }
            case 7: {
                return messageResolver.resolveMessage("address.housenumber", new Serializable[0]);
            }
            case 8: {
                return messageResolver.resolveMessage("address.housenumberExt", new Serializable[0]);
            }
            case 9: {
                return messageResolver.resolveMessage("gis.coordinate.longitude", new Serializable[0]);
            }
            case 10: {
                return messageResolver.resolveMessage("gis.coordinate.latitude", new Serializable[0]);
            }
            case 11: {
                return messageResolver.resolveMessage("gis.coordinate.longitude", new Serializable[0]);
            }
            case 12: {
                return messageResolver.resolveMessage("gis.coordinate.latitude", new Serializable[0]);
            }
            case 13: {
                return messageResolver.resolveMessage("messages.default.take", new Serializable[0]) + " 1";
            }
            case 14: {
                return messageResolver.resolveMessage("messages.default.take", new Serializable[0]) + " 2";
            }
        }
        return "?";
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex >= 0 && columnIndex < 13) {
            return String.class;
        }
        if (columnIndex >= 13 && columnIndex < 15) {
            return Boolean.class;
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex >= 13 && columnIndex < 15;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex >= 0 && columnIndex < 13) {
            Tupel<ParcelModel, ParcelModel> quad = this.multiples.get(rowIndex);
            ParcelModel parcel = quad.getElement1();
            StreetModel street = parcel.getStreet();
            PostcodeDistrictRelationModel pdr = street.getPostcodeDistrictRelation();
            PostcodeModel postcode = pdr.getPostcode();
            DistrictModel district = pdr.getDistrict();
            CityModel city = district.getCity();
            ImmutablePoint geom1 = parcel.getGeom();
            geom1 = geom1 == null ? ImmutableGeoObjectFactory.createImmutablePoint(Wgs84Factory.INSTANCE.createCoordinate(0.0, 0.0)) : (ImmutablePoint)geom1.getTransformed(Wgs84Factory.INSTANCE);
            ParcelModel parcel2 = quad.getElement2();
            ImmutablePoint geom2 = parcel2.getGeom();
            geom2 = geom2 == null ? ImmutableGeoObjectFactory.createImmutablePoint(Wgs84Factory.INSTANCE.createCoordinate(0.0, 0.0)) : (ImmutablePoint)geom2.getTransformed(Wgs84Factory.INSTANCE);
            switch (columnIndex) {
                case 0: {
                    return quad.getElement1().getImportKey();
                }
                case 1: {
                    return quad.getElement2().getImportKey();
                }
                case 2: {
                    return postcode.getCountry().toString();
                }
                case 3: {
                    return postcode.getName();
                }
                case 4: {
                    return city.getName();
                }
                case 5: {
                    return district.getName();
                }
                case 6: {
                    return street.getName();
                }
                case 7: {
                    return parcel.getHouseNumber();
                }
                case 8: {
                    return parcel.getHouseNumberExtension();
                }
                case 9: {
                    return PrimitiveUtil.formatDouble(geom1.getX(), 6, false);
                }
                case 10: {
                    return PrimitiveUtil.formatDouble(geom1.getY(), 6, false);
                }
                case 11: {
                    return PrimitiveUtil.formatDouble(geom2.getX(), 6, false);
                }
                case 12: {
                    return PrimitiveUtil.formatDouble(geom2.getY(), 6, false);
                }
            }
        } else if (columnIndex >= 13 && columnIndex < 15) {
            Tupel<Boolean, Boolean> tupel = this.bools.get(rowIndex);
            switch (columnIndex) {
                case 13: {
                    return tupel.getElement1();
                }
                case 14: {
                    return tupel.getElement2();
                }
            }
            return Boolean.class;
        }
        return null;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (columnIndex >= 13 && columnIndex < 15) {
            Tupel<Boolean, Boolean> tupel = this.bools.get(rowIndex);
            Boolean bValue = (Boolean)aValue;
            switch (columnIndex) {
                case 13: {
                    tupel.setElement1(bValue);
                    if (bValue.booleanValue() || tupel.getElement2().booleanValue()) break;
                    tupel.setElement2(true);
                    this.fireChanged(new TableModelEvent(this, rowIndex, rowIndex, 14, 0));
                    break;
                }
                case 14: {
                    tupel.setElement2(bValue);
                    if (bValue.booleanValue() || tupel.getElement1().booleanValue()) break;
                    tupel.setElement1(true);
                    this.fireChanged(new TableModelEvent(this, rowIndex, rowIndex, 13, 0));
                }
            }
        }
    }

    protected void fireChanged(TableModelEvent event) {
        for (TableModelListener tableModelListener : this.listeners) {
            tableModelListener.tableChanged(event);
        }
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.listeners.remove(l);
    }

    public List<Tupel<Boolean, Boolean>> getBools() {
        return this.bools;
    }

    public List<Tupel<ParcelModel, ParcelModel>> getMultiples() {
        return this.multiples;
    }
}

