/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.importer.parcel.multiple;

import de.datomino.peppergis.client.gui.asynchronous.AbstractAsynchronousDialog;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.gui.osm.ThreadingOsmNavigatorRenderer;
import de.datomino.peppergis.client.gui.renderer.MapScaleRenderer;
import de.datomino.peppergis.client.gui.renderer.ZoomingRenderer;
import de.datomino.peppergis.client.gui.renderer.common.MultiColoredPointRenderer;
import de.datomino.peppergis.client.model.Model;
import de.datomino.peppergis.client.model.area.AreaLayerModel;
import de.datomino.peppergis.client.model.area.AreaObjectParcelRelModel;
import de.datomino.peppergis.client.model.base.LocationModel;
import de.datomino.peppergis.client.model.map.CityAliasModel;
import de.datomino.peppergis.client.model.map.CityAliasModelImpl;
import de.datomino.peppergis.client.model.map.CityModel;
import de.datomino.peppergis.client.model.map.DistrictAliasModel;
import de.datomino.peppergis.client.model.map.DistrictAliasModelImpl;
import de.datomino.peppergis.client.model.map.DistrictModel;
import de.datomino.peppergis.client.model.map.ParcelAttributeValueDescriptorModel;
import de.datomino.peppergis.client.model.map.ParcelAttributeValueModel;
import de.datomino.peppergis.client.model.map.ParcelModel;
import de.datomino.peppergis.client.model.map.PostcodeDistrictRelationModel;
import de.datomino.peppergis.client.model.map.PostcodeModel;
import de.datomino.peppergis.client.model.map.StreetAliasModel;
import de.datomino.peppergis.client.model.map.StreetAliasModelImpl;
import de.datomino.peppergis.client.model.map.StreetModel;
import de.datomino.peppergis.client.model.tour.AreaStopModel;
import de.datomino.peppergis.client.model.tour.AreaTourModel;
import de.datomino.peppergis.client.model.tour.AreaTourPartModel;
import de.datomino.peppergis.dto.asynchronous.AsynchronousDto;
import de.datomino.peppergis.dto.common.CollectionDto;
import de.datomino.peppergis.dto.map.ParcelDto;
import de.datomino.peppergis.importer.parcel.multiple.CanceledException;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.international.country.Country;
import de.datomino.util.swing.SwingUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.ktde.math.projection.Coordinate;
import org.ktde.math.projection.CoordinateFactory;
import org.ktde.math.projection.MercatorFactory;
import org.ktde.math.projection.OpenStreetmapViewFactory;
import org.ktde.math.projection.Wgs84Factory;
import org.ktde.swing.navigator.DefaultMouseManipulator;
import org.ktde.swing.navigator.NavigatorPanel;
import org.ktde.swing.navigator.NavigatorPanningAction;
import org.ktde.util.StringUtil;
import org.ktde.util.datatypes.Tupel;
import org.ktde.util.io.CsvWriter;

public class MultipleParcelEditorPane2
extends JPanel {
    private static final long serialVersionUID = -4860218191637223940L;
    private JTree tree;
    private NavigatorPanel navigatorPanel;
    private ModelEnviroment modelEnviroment;
    private MultiColoredPointRenderer multiColoredPointRenderer;
    private static final Color[] COLORS = new Color[]{Color.BLACK, Color.BLUE, Color.CYAN, Color.GREEN, Color.MAGENTA, Color.ORANGE, Color.PINK, Color.RED, Color.YELLOW};
    private Window parent;
    private HeadNode lastSelectedHeadNode;

    public MultipleParcelEditorPane2(Window parent, ModelEnviroment modelEnviroment) throws CanceledException {
        super(new BorderLayout());
        this.parent = parent;
        this.modelEnviroment = modelEnviroment;
        this.buildLayout();
        this.fillValues();
    }

    private void fillValues() throws CanceledException {
        Collection<Collection<ParcelModel>> multiples = this.getData(this.modelEnviroment);
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.tree.getModel().getRoot();
        int count = 1;
        for (Collection<ParcelModel> col : multiples) {
            ParcelModel headParcel = null;
            if (!col.isEmpty()) {
                headParcel = col.iterator().next();
            }
            HeadNode setNode = new HeadNode(count, headParcel);
            root.add(setNode);
            int index = 0;
            for (ParcelModel tupel : col) {
                if (index >= COLORS.length) {
                    index = 0;
                }
                Color color = COLORS[index];
                ColoredTreeNode node = new ColoredTreeNode(tupel, color);
                setNode.add(node);
                this.buildParcelNode(tupel, color, node);
                ++index;
            }
            ++count;
        }
        this.tree.expandPath(new TreePath(root));
        this.tree.repaint(10L);
    }

    private void writeCsv(Collection<Collection<ParcelModel>> multiples) {
        int max = 0;
        for (Collection<ParcelModel> col : multiples) {
            max = Math.max(max, col.size());
        }
        try {
            CsvWriter csvWriter = new CsvWriter("/tmp/multi.csv");
            for (Collection<ParcelModel> col : multiples) {
                ArrayList<String> line = new ArrayList<String>(col.size());
                TreeSet<String> keys = new TreeSet<String>();
                for (ParcelModel tupel : col) {
                    keys.add(tupel.getImportKey());
                }
                if (keys.size() != 2) continue;
                Iterator iter = keys.iterator();
                String key1 = (String)iter.next();
                String key2 = (String)iter.next();
                if (!key1.toUpperCase().startsWith("DE") || !key2.toUpperCase().startsWith("M")) continue;
                line.addAll(keys);
                csvWriter.writeLine(line);
            }
            csvWriter.flush();
            csvWriter.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private Collection<Collection<ParcelModel>> getData(ModelEnviroment modelEnviroment) throws CanceledException {
        AbstractAsynchronousDialog<CollectionDto<CollectionDto<ParcelDto>>> asynchronousDialog = new AbstractAsynchronousDialog<CollectionDto<CollectionDto<ParcelDto>>>(this.parent, ModelEnviroment.getMessageResolver().resolveMessage("messages.parcel.multiple.calculation", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("messages.parcel.multiple.calculation", new Serializable[0]), 1, true, this.modelEnviroment){
            private static final long serialVersionUID = 2551158849321459421L;

            @Override
            protected String startAsynchronous() {
                return this.modelEnviroment.getAllCaller().getAsynchronousCaller().fetchMultipleAdressParcels();
            }

            @Override
            protected AsynchronousDto<CollectionDto<CollectionDto<ParcelDto>>> getAsynchronousDto(String token) {
                return this.modelEnviroment.getAllCaller().getAsynchronousCaller().getFetchMultipleAdressParcelsResult(token);
            }
        };
        try {
            Tupel result = asynchronousDialog.run();
            if (result.getElement2().booleanValue()) {
                throw new CanceledException();
            }
            Collection collection = ((CollectionDto)result.getElement1()).getCollection();
            ArrayList<Collection<ParcelModel>> tResult = new ArrayList<Collection<ParcelModel>>(collection.size());
            for (CollectionDto collectionDto : collection) {
                ArrayList<ParcelModel> list = new ArrayList<ParcelModel>(collectionDto.getCollection().size());
                for (ParcelDto tupel : collectionDto.getCollection()) {
                    ParcelModel parcelModel = (ParcelModel)modelEnviroment.getModelCache().getModel(tupel);
                    list.add(parcelModel);
                }
                tResult.add(list);
            }
            return tResult;
        }
        catch (CanceledException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private void buildParcelNode(ParcelModel parcel, Color color, ColoredTreeNode node) {
        StreetModel street = parcel.getStreet();
        PostcodeDistrictRelationModel pdr = street.getPostcodeDistrictRelation();
        PostcodeModel postcode = pdr.getPostcode();
        ColoredTreeNode postcodeNode = new ColoredTreeNode(postcode, color);
        node.add(postcodeNode);
        DistrictModel district = pdr.getDistrict();
        CityModel city = district.getCity();
        ColoredTreeNode cityNode = new ColoredTreeNode(city, color);
        node.add(cityNode);
        for (CityAliasModel cityAliasModel : city.iterableAlias()) {
            cityNode.add(new ColoredTreeNode(cityAliasModel, color));
        }
        ColoredTreeNode districtNode = new ColoredTreeNode(district, color);
        node.add(districtNode);
        for (DistrictAliasModel districtAliasModel : district.iterableAlias()) {
            districtNode.add(new ColoredTreeNode(districtAliasModel, color));
        }
        ColoredTreeNode coloredTreeNode = new ColoredTreeNode(street, color);
        node.add(coloredTreeNode);
        for (StreetAliasModel alias : street.iterableAlias()) {
            coloredTreeNode.add(new ColoredTreeNode(alias, color));
        }
        node.add(new ColoredTreeNode(parcel.getHouseNumber() + parcel.getHouseNumberExtension(), color));
        ImmutablePoint immutablePoint = (ImmutablePoint)parcel.getGeom().getTransformed(Wgs84Factory.INSTANCE);
        node.add(new ColoredTreeNode(immutablePoint, color));
    }

    private void buildLayout() {
        final JSplitPane split = new JSplitPane(1);
        DefaultTreeModel dtm = new DefaultTreeModel(new DefaultMutableTreeNode());
        this.tree = new JTree(dtm);
        this.tree.setRootVisible(true);
        this.tree.setCellRenderer(new MultiParcelTreeRenderer(this.tree.getCellRenderer()));
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.getSelectionModel().addTreeSelectionListener(new MultiParcelSelectionListener());
        this.tree.addMouseListener(new TreeMouseListener());
        split.setLeftComponent(new JScrollPane(this.tree));
        ThreadingOsmNavigatorRenderer osmNavigatorRenderer = new ThreadingOsmNavigatorRenderer(ModelEnviroment.getProperties());
        this.navigatorPanel = new NavigatorPanel(this.getStartCoordinate(), OpenStreetmapViewFactory.INSTANCE, ModelEnviroment.getMessageResolver().resolveMessage("messages.default.panning", new Serializable[0]), (Container)this);
        this.navigatorPanel.addRenderer(osmNavigatorRenderer);
        MapScaleRenderer renderer = new MapScaleRenderer(ModelEnviroment.getMessageResolver().resolveMessage("messages.common.mapScale", new Serializable[0]));
        renderer.setNavigatorPanel(this.navigatorPanel);
        this.navigatorPanel.addRenderer(renderer);
        ZoomingRenderer zoomingRenderer = new ZoomingRenderer(this.navigatorPanel);
        zoomingRenderer.setNavigatorPanel(this.navigatorPanel);
        this.navigatorPanel.addRenderer(zoomingRenderer);
        this.navigatorPanel.addPreferredMouseManipulatorForClick(zoomingRenderer);
        DefaultMouseManipulator mouseManipulator = new DefaultMouseManipulator(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                if (NavigatorPanningAction.performWheelZoom(e, MultipleParcelEditorPane2.this.navigatorPanel)) {
                    super.mouseWheelMoved(e);
                    MultipleParcelEditorPane2.this.navigatorPanel.forceCalcTransform();
                }
            }
        };
        this.navigatorPanel.setMouseManipulator(mouseManipulator);
        this.multiColoredPointRenderer = new MultiColoredPointRenderer();
        this.navigatorPanel.addRenderer(this.multiColoredPointRenderer);
        split.setRightComponent(this.navigatorPanel);
        this.add((Component)split, "Center");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                split.setDividerLocation(200);
            }
        });
    }

    protected Coordinate getStartCoordinate() {
        String startString = ModelEnviroment.getProperties().getProperty("navigator.startCoordinate");
        Coordinate startCoordinate = null;
        if (startString != null) {
            try {
                Tupel<String, String[]> tupel = StringUtil.parseTokens(startString);
                CoordinateFactory factory = CoordinateFactory.getInstance(tupel.getElement1());
                startCoordinate = factory.createCoordinate(Double.valueOf(tupel.getElement2()[0]), Double.valueOf(tupel.getElement2()[1]));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (startCoordinate == null) {
            startCoordinate = MercatorFactory.INSTANCE.createCoordinate(1293576.0, 6116444.0);
        }
        return startCoordinate;
    }

    private String emptyToHyphen(String s) {
        return StringUtil.isEmpty(s) ? "-" : s;
    }

    private void markHeadNode(HeadNode headNode, ParcelModel parcelTupel) {
        int childCount = headNode.getChildCount();
        ArrayList<Tupel<ImmutablePoint, Color>> list = new ArrayList<Tupel<ImmutablePoint, Color>>(childCount);
        ArrayList<Coordinate> pointList = new ArrayList<Coordinate>(childCount);
        Tupel<ImmutablePoint, Color> lastTupel = null;
        for (int i = 0; i < childCount; ++i) {
            ColoredTreeNode node = (ColoredTreeNode)headNode.getChildAt(i);
            Color color = node.color;
            ParcelModel parcel = (ParcelModel)node.getUserObject();
            ImmutablePoint geom = parcel.getGeom();
            Tupel<ImmutablePoint, Color> rTupel = new Tupel<ImmutablePoint, Color>(geom, color);
            if (parcelTupel != null && parcel.equals(parcelTupel)) {
                lastTupel = rTupel;
            } else {
                list.add(rTupel);
            }
            pointList.add(geom.getCoordinate());
        }
        if (lastTupel != null) {
            list.add(lastTupel);
        }
        if (headNode != this.lastSelectedHeadNode) {
            this.navigatorPanel.center(pointList, 5);
            double upp = this.navigatorPanel.getUpp();
            upp = Math.max(upp, 1.0);
            this.navigatorPanel.setUpp(upp);
        }
        this.multiColoredPointRenderer.setPoints(list);
        this.lastSelectedHeadNode = headNode;
        this.navigatorPanel.repaint(10L);
    }

    private void createPopMenu(final ParcelModel sourceTupel, final ParcelModel targetTupel, final DefaultMutableTreeNode sourceDtm, DefaultMutableTreeNode targetDtm, Point point) {
        JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.setLocation(point);
        popupMenu.add(new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.delete", new Serializable[0])){
            private static final long serialVersionUID = -1852003254583688118L;

            @Override
            public void actionPerformed(ActionEvent e) {
                int d = JOptionPane.showConfirmDialog(SwingUtils.findWindowParent(MultipleParcelEditorPane2.this), ModelEnviroment.getMessageResolver().resolveMessage("messages.parcel.delete.question", new Serializable[]{sourceTupel.getImportKey()}), ModelEnviroment.getMessageResolver().resolveMessage("messages.default.question", new Serializable[0]), 0, 3);
                if (d == 0) {
                    MultipleParcelEditorPane2.this.mergeParcel(sourceTupel, targetTupel);
                    List treePaths = MultipleParcelEditorPane2.this.getExpandedTreePath();
                    DefaultMutableTreeNode parent2 = (DefaultMutableTreeNode)sourceDtm.getParent();
                    DefaultTreeModel model = (DefaultTreeModel)MultipleParcelEditorPane2.this.tree.getModel();
                    parent2.remove(sourceDtm);
                    model.reload(sourceDtm);
                    if (parent2.getChildCount() == 1) {
                        DefaultMutableTreeNode parent3 = (DefaultMutableTreeNode)parent2.getParent();
                        parent3.remove(parent2);
                        model.reload(parent3);
                    }
                    for (TreePath treePath : treePaths) {
                        MultipleParcelEditorPane2.this.tree.expandPath(treePath);
                    }
                }
            }
        });
        popupMenu.show(this, (int)(point.getX() + this.tree.getLocation().getX()), (int)(point.getY() + this.tree.getLocation().getY()));
    }

    private List<TreePath> getExpandedTreePath() {
        DefaultMutableTreeNode dtm = (DefaultMutableTreeNode)this.tree.getModel().getRoot();
        LinkedList<TreePath> treePaths = new LinkedList<TreePath>();
        Stack<DefaultMutableTreeNode> stack = new Stack<DefaultMutableTreeNode>();
        stack.push(dtm);
        this.getExpandedTreePath(dtm, stack, treePaths);
        return treePaths;
    }

    private void getExpandedTreePath(DefaultMutableTreeNode dtm, Stack<DefaultMutableTreeNode> stack, List<TreePath> treePaths) {
        for (int i = 0; i < dtm.getChildCount(); ++i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)dtm.getChildAt(i);
            stack.push(child);
            Object[] object = new Object[stack.size()];
            int count = 0;
            for (DefaultMutableTreeNode sdtm : stack) {
                object[count] = sdtm;
                ++count;
            }
            TreePath treePath = new TreePath(object);
            if (this.tree.isExpanded(treePath)) {
                treePaths.add(treePath);
                this.getExpandedTreePath(child, stack, treePaths);
            }
            stack.pop();
        }
    }

    private void mergeParcel(ParcelModel sourceParcel, ParcelModel targetParcel) {
        StreetModel streetModel;
        this.modelEnviroment.getUndoManager().startTransaction();
        Collection<LocationModel> locations = this.modelEnviroment.getAllCaller().getBaseCaller().getLocationsForParcel(sourceParcel);
        for (LocationModel locationModel : locations) {
            locationModel.setParcel(targetParcel);
        }
        HashSet<AreaLayerModel> layers = new HashSet<AreaLayerModel>();
        for (AreaObjectParcelRelModel rel : targetParcel.iterableAreaObjectParcelRel()) {
            layers.add(rel.getAreaObject().getAreaLayer());
        }
        LinkedList<Model> linkedList = new LinkedList<Model>();
        LinkedList<AreaObjectParcelRelModel> toSetTargetRels = new LinkedList<AreaObjectParcelRelModel>();
        for (AreaObjectParcelRelModel rel : sourceParcel.iterableAreaObjectParcelRel()) {
            AreaLayerModel areaLayer = rel.getAreaObject().getAreaLayer();
            if (layers.contains(areaLayer)) {
                linkedList.add(rel);
                continue;
            }
            toSetTargetRels.add(rel);
        }
        for (AreaObjectParcelRelModel rel : toSetTargetRels) {
            rel.setParcel(targetParcel);
        }
        Collection<AreaStopModel> stops = this.modelEnviroment.getAllCaller().getTourCaller().fetchAreaStop(sourceParcel, null, null, null);
        HashSet<AreaTourModel> tours = new HashSet<AreaTourModel>();
        for (AreaStopModel areaStopModel : stops) {
            tours.add(areaStopModel.getAreaTourPart().getAreaTour());
        }
        for (AreaTourModel areaTourModel : tours) {
            for (AreaTourPartModel areaTourPartModel : areaTourModel.iterableAreaTourParts()) {
                for (AreaStopModel stop : areaTourPartModel.iterableAreaStops()) {
                    linkedList.add(stop);
                }
                linkedList.add(areaTourPartModel);
            }
            linkedList.add(areaTourModel);
        }
        HashSet<ParcelAttributeValueDescriptorModel> descriptors = new HashSet<ParcelAttributeValueDescriptorModel>();
        for (ParcelAttributeValueModel parcelAttributeValueModel : targetParcel.iterableParcelAttributeValues()) {
            descriptors.add(parcelAttributeValueModel.getParcelAttributeValueDescriptor());
        }
        LinkedList<ParcelAttributeValueModel> linkedList2 = new LinkedList<ParcelAttributeValueModel>();
        for (ParcelAttributeValueModel parcelAttributeValueModel : sourceParcel.iterableParcelAttributeValues()) {
            if (descriptors.contains(parcelAttributeValueModel.getParcelAttributeValueDescriptor())) {
                linkedList.add(parcelAttributeValueModel);
                continue;
            }
            linkedList2.add(parcelAttributeValueModel);
        }
        for (ParcelAttributeValueModel parcelAttributeValueModel : linkedList2) {
            parcelAttributeValueModel.setParcel(targetParcel);
        }
        for (Model model : linkedList) {
            model.delete();
        }
        StreetModel streetModel2 = sourceParcel.getStreet();
        if (streetModel2 != (streetModel = targetParcel.getStreet())) {
            this.mergeStreetAlias(streetModel2, streetModel);
            PostcodeDistrictRelationModel sourcePostcodeDistrictRelation = streetModel2.getPostcodeDistrictRelation();
            PostcodeDistrictRelationModel targetPostcodeDistrictRelation = streetModel.getPostcodeDistrictRelation();
            DistrictModel sourceDistrict = sourcePostcodeDistrictRelation.getDistrict();
            DistrictModel targetDistrict = targetPostcodeDistrictRelation.getDistrict();
            if (sourceDistrict != targetDistrict) {
                this.mergeDistrictAlias(sourceDistrict, targetDistrict);
                CityModel sourceCity = sourceDistrict.getCity();
                CityModel targetCity = targetDistrict.getCity();
                if (sourceCity != targetCity) {
                    this.mergeCityAlias(sourceCity, targetCity);
                }
            }
        }
        sourceParcel.delete();
        this.modelEnviroment.getUndoManager().finishTransaction("");
    }

    private void mergeCityAlias(CityModel sourceCity, CityModel targetCity) {
        HashSet<String> setAlias = new HashSet<String>();
        for (CityAliasModel alias : targetCity.iterableAlias()) {
            setAlias.add(alias.getName());
        }
        ArrayList<CityAliasModel> copy = new ArrayList<CityAliasModel>(sourceCity.countAlias());
        for (CityAliasModel alias : sourceCity.iterableAlias()) {
            copy.add(alias);
        }
        for (CityAliasModel alias : copy) {
            if (setAlias.contains(alias.getName())) continue;
            CityAliasModelImpl cityAlias = new CityAliasModelImpl();
            cityAlias.setCity(targetCity);
            cityAlias.setName(alias.getName());
            cityAlias.setSearch(alias.getSearch());
        }
    }

    private void mergeDistrictAlias(DistrictModel sourceDistrict, DistrictModel targetDistrict) {
        HashSet<String> setAlias = new HashSet<String>();
        for (DistrictAliasModel alias : targetDistrict.iterableAlias()) {
            setAlias.add(alias.getName());
        }
        ArrayList<DistrictAliasModel> copy = new ArrayList<DistrictAliasModel>(sourceDistrict.countAlias());
        for (DistrictAliasModel alias : sourceDistrict.iterableAlias()) {
            copy.add(alias);
        }
        for (DistrictAliasModel alias : copy) {
            if (setAlias.contains(alias.getName())) continue;
            DistrictAliasModelImpl districtAlias = new DistrictAliasModelImpl();
            districtAlias.setDistrict(targetDistrict);
            districtAlias.setName(alias.getName());
            districtAlias.setSearch(alias.getSearch());
        }
    }

    private void mergeStreetAlias(StreetModel sourceStreet, StreetModel targetStreet) {
        HashSet<String> setAlias = new HashSet<String>();
        for (StreetAliasModel alias : targetStreet.iterableAlias()) {
            setAlias.add(alias.getName());
        }
        ArrayList<StreetAliasModel> copy = new ArrayList<StreetAliasModel>(sourceStreet.countAlias());
        for (StreetAliasModel alias : sourceStreet.iterableAlias()) {
            copy.add(alias);
        }
        for (StreetAliasModel alias : copy) {
            if (setAlias.contains(alias.getName())) continue;
            StreetAliasModelImpl streetAlias = new StreetAliasModelImpl();
            streetAlias.setStreet(targetStreet);
            streetAlias.setName(alias.getName());
            streetAlias.setSearch(alias.getSearch());
        }
    }

    private class TreeMouseListener
    extends MouseAdapter {
        private TreeMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            super.mouseClicked(e);
            if (e.getButton() == 3) {
                for (TreePath treePath = MultipleParcelEditorPane2.this.tree.getSelectionPath(); treePath != null; treePath = treePath.getParentPath()) {
                    DefaultMutableTreeNode dmt = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                    Object object = dmt.getUserObject();
                    if (!(object instanceof ParcelModel)) continue;
                    ParcelModel sourceTupel = (ParcelModel)object;
                    DefaultMutableTreeNode first = dmt.getPreviousSibling();
                    if (first != null) {
                        DefaultMutableTreeNode first2 = first;
                        for (first = first.getPreviousSibling(); first != null; first = first.getPreviousSibling()) {
                            first2 = first;
                        }
                        first = first2;
                    }
                    if (first == null) {
                        first = dmt.getNextSibling();
                    }
                    ParcelModel targetTupel = (ParcelModel)first.getUserObject();
                    MultipleParcelEditorPane2.this.createPopMenu(sourceTupel, targetTupel, dmt, first, e.getPoint());
                }
            }
        }
    }

    private class ColoredTreeNode
    extends DefaultMutableTreeNode {
        private static final long serialVersionUID = -535354205665117930L;
        private Color color;

        public ColoredTreeNode(Object object, Color color) {
            super(object);
            this.color = color;
        }
    }

    private class HeadNode
    extends DefaultMutableTreeNode {
        private static final long serialVersionUID = 6029017591473012279L;
        private ParcelModel headParcel;

        public HeadNode(Integer count, ParcelModel headParcel) {
            super(count);
            this.headParcel = headParcel;
        }

        public ParcelModel getHeadParcel() {
            return this.headParcel;
        }
    }

    private class MultiParcelSelectionListener
    implements TreeSelectionListener {
        private MultiParcelSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            ParcelModel tupel = null;
            for (TreePath path = e.getPath(); path != null; path = path.getParentPath()) {
                Object col;
                Object object = path.getLastPathComponent();
                if (object instanceof ColoredTreeNode && (col = ((ColoredTreeNode)object).getUserObject()) instanceof Tupel) {
                    tupel = (ParcelModel)col;
                }
                if (!(object instanceof HeadNode)) continue;
                HeadNode headNode = (HeadNode)object;
                MultipleParcelEditorPane2.this.markHeadNode(headNode, tupel);
                break;
            }
        }
    }

    private class MultiParcelTreeRenderer
    implements TreeCellRenderer {
        private TreeCellRenderer treeCellRenderer;

        public MultiParcelTreeRenderer(TreeCellRenderer dtcr) {
            this.treeCellRenderer = dtcr;
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (value instanceof HeadNode) {
                HeadNode headNode = (HeadNode)value;
                ParcelModel parcelModel = headNode.getHeadParcel();
                if (parcelModel != null) {
                    StringBuilder sb = new StringBuilder().append(headNode.getUserObject()).append(": ").append(this.getParcelStringRepresantation(parcelModel, true));
                    return this.treeCellRenderer.getTreeCellRendererComponent(tree, sb.toString(), selected, expanded, leaf, row, hasFocus);
                }
            } else if (value instanceof DefaultMutableTreeNode) {
                Model alias;
                DefaultMutableTreeNode dmtn = (DefaultMutableTreeNode)value;
                Object uValue = dmtn.getUserObject();
                Component component = null;
                if (uValue instanceof ParcelModel) {
                    String importKey = ((ParcelModel)uValue).getImportKey();
                    component = this.treeCellRenderer.getTreeCellRendererComponent(tree, MultipleParcelEditorPane2.this.emptyToHyphen(importKey), selected, expanded, leaf, row, hasFocus);
                } else if (uValue instanceof PostcodeModel) {
                    PostcodeModel postcode = (PostcodeModel)uValue;
                    component = this.treeCellRenderer.getTreeCellRendererComponent(tree, MultipleParcelEditorPane2.this.emptyToHyphen((postcode.getCountry() + " " + postcode.getName()).trim()), selected, expanded, leaf, row, hasFocus);
                } else if (uValue instanceof CityModel) {
                    CityModel city = (CityModel)uValue;
                    component = this.treeCellRenderer.getTreeCellRendererComponent(tree, MultipleParcelEditorPane2.this.emptyToHyphen(city.getName()), selected, expanded, leaf, row, hasFocus);
                } else if (uValue instanceof CityAliasModel) {
                    alias = (CityAliasModel)uValue;
                    component = this.treeCellRenderer.getTreeCellRendererComponent(tree, MultipleParcelEditorPane2.this.emptyToHyphen(alias.getName()), selected, expanded, leaf, row, hasFocus);
                } else if (uValue instanceof DistrictModel) {
                    DistrictModel district = (DistrictModel)uValue;
                    component = this.treeCellRenderer.getTreeCellRendererComponent(tree, MultipleParcelEditorPane2.this.emptyToHyphen(district.getName()), selected, expanded, leaf, row, hasFocus);
                } else if (uValue instanceof DistrictAliasModel) {
                    alias = (DistrictAliasModel)uValue;
                    component = this.treeCellRenderer.getTreeCellRendererComponent(tree, MultipleParcelEditorPane2.this.emptyToHyphen(alias.getName()), selected, expanded, leaf, row, hasFocus);
                } else if (uValue instanceof StreetModel) {
                    StreetModel street = (StreetModel)uValue;
                    component = this.treeCellRenderer.getTreeCellRendererComponent(tree, MultipleParcelEditorPane2.this.emptyToHyphen(street.getName()), selected, expanded, leaf, row, hasFocus);
                } else if (uValue instanceof StreetAliasModel) {
                    alias = (StreetAliasModel)uValue;
                    component = this.treeCellRenderer.getTreeCellRendererComponent(tree, MultipleParcelEditorPane2.this.emptyToHyphen(alias.getName()), selected, expanded, leaf, row, hasFocus);
                } else if (uValue instanceof ImmutablePoint) {
                    ImmutablePoint point = (ImmutablePoint)uValue;
                    String pointString = "Lon: " + point.getX() + ", Lat: " + point.getY();
                    component = this.treeCellRenderer.getTreeCellRendererComponent(tree, MultipleParcelEditorPane2.this.emptyToHyphen(pointString), selected, expanded, leaf, row, hasFocus);
                }
                if (component != null) {
                    if (value instanceof ColoredTreeNode) {
                        ColoredTreeNode coloredTreeNode = (ColoredTreeNode)value;
                        component.setForeground(coloredTreeNode.color);
                    }
                    return component;
                }
            }
            return this.treeCellRenderer.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        }

        private String getParcelStringRepresantation(ParcelModel parcelModel, boolean normalizeHousenumber) {
            StringBuilder sb = new StringBuilder();
            StreetModel street = parcelModel.getStreet();
            PostcodeDistrictRelationModel pdr = street.getPostcodeDistrictRelation();
            PostcodeModel postcode = pdr.getPostcode();
            DistrictModel district = pdr.getDistrict();
            CityModel city = district.getCity();
            Country country = postcode.getCountry();
            String housenumber = parcelModel.getHouseNumber();
            String housenumberExt = parcelModel.getHouseNumberExtension();
            if (normalizeHousenumber) {
                housenumber = StringUtil.normalize(StringUtil.nullToEmpty(housenumber));
                housenumberExt = StringUtil.normalize(StringUtil.nullToEmpty(housenumberExt));
            }
            sb.append(country == null ? "?" : country.getVehicleSign()).append(" ").append(postcode.getName()).append(" ").append(city.getName()).append(" - ").append(district.getName()).append(", ").append(street.getName()).append(" ").append(housenumber).append(housenumberExt);
            return sb.toString();
        }
    }
}

