/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.importer.parcel.multiple;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.gui.osm.ThreadingOsmNavigatorRenderer;
import de.datomino.peppergis.client.gui.renderer.MapScaleRenderer;
import de.datomino.peppergis.client.gui.renderer.ZoomingRenderer;
import de.datomino.peppergis.client.gui.renderer.common.DefaultSimplePointRenderer;
import de.datomino.peppergis.client.model.Model;
import de.datomino.peppergis.client.model.area.AreaLayerModel;
import de.datomino.peppergis.client.model.area.AreaObjectParcelRelModel;
import de.datomino.peppergis.client.model.base.LocationModel;
import de.datomino.peppergis.client.model.map.ParcelAttributeValueDescriptorModel;
import de.datomino.peppergis.client.model.map.ParcelAttributeValueModel;
import de.datomino.peppergis.client.model.map.ParcelModel;
import de.datomino.peppergis.client.model.tour.AreaStopModel;
import de.datomino.peppergis.client.model.tour.AreaTourModel;
import de.datomino.peppergis.client.model.tour.AreaTourPartModel;
import de.datomino.peppergis.importer.parcel.multiple.MultipleParcelTableModel;
import de.datomino.util.geo.ImmutablePoint;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.MouseWheelEvent;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumnModel;
import org.ktde.math.projection.Coordinate;
import org.ktde.math.projection.CoordinateFactory;
import org.ktde.math.projection.MercatorFactory;
import org.ktde.math.projection.OpenStreetmapViewFactory;
import org.ktde.swing.navigator.DefaultMouseManipulator;
import org.ktde.swing.navigator.NavigatorPanel;
import org.ktde.swing.navigator.NavigatorPanningAction;
import org.ktde.util.StringUtil;
import org.ktde.util.datatypes.Tupel;

public class MultipleParcelEditorPane
extends JPanel {
    private static final long serialVersionUID = 3616543929600382365L;
    private JTable multipleTable;
    private ModelEnviroment modelEnviroment;
    private NavigatorPanel navigatorPanel;
    private DefaultSimplePointRenderer simplePointRenderer1;
    private DefaultSimplePointRenderer simplePointRenderer2;

    public MultipleParcelEditorPane(ModelEnviroment modelEnviroment) {
        super(new BorderLayout());
        this.modelEnviroment = modelEnviroment;
        List<Tupel<ParcelModel, ParcelModel>> multiples = this.modelEnviroment.getAllCaller().getStreetNetCaller().fetchDoubleAddressParcels();
        this.buildLayout(multiples);
    }

    private void buildLayout(List<Tupel<ParcelModel, ParcelModel>> multiples) {
        final JSplitPane split = new JSplitPane(1);
        this.multipleTable = new JTable(new MultipleParcelTableModel(multiples));
        this.multipleTable.getSelectionModel().addListSelectionListener(new TableSelectionListener());
        this.multipleTable.getTableHeader().setReorderingAllowed(false);
        TableColumnModel columnModel = this.multipleTable.getColumnModel();
        columnModel.getColumn(0).setPreferredWidth(150);
        columnModel.getColumn(1).setPreferredWidth(150);
        columnModel.getColumn(2).setPreferredWidth(40);
        columnModel.getColumn(3).setPreferredWidth(100);
        columnModel.getColumn(4).setPreferredWidth(200);
        columnModel.getColumn(5).setPreferredWidth(200);
        columnModel.getColumn(6).setPreferredWidth(200);
        columnModel.getColumn(7).setPreferredWidth(20);
        columnModel.getColumn(8).setPreferredWidth(20);
        columnModel.getColumn(9).setPreferredWidth(150);
        columnModel.getColumn(10).setPreferredWidth(150);
        columnModel.getColumn(11).setPreferredWidth(150);
        columnModel.getColumn(12).setPreferredWidth(150);
        columnModel.getColumn(13).setPreferredWidth(80);
        columnModel.getColumn(14).setPreferredWidth(80);
        this.setPreferredSize(new Dimension(1200, 800));
        split.setLeftComponent(new JScrollPane(this.multipleTable));
        ThreadingOsmNavigatorRenderer osmNavigatorRenderer = new ThreadingOsmNavigatorRenderer(ModelEnviroment.getProperties());
        this.navigatorPanel = new NavigatorPanel(this.getStartCoordinate(), OpenStreetmapViewFactory.INSTANCE, ModelEnviroment.getMessageResolver().resolveMessage("messages.default.panning", new Serializable[0]), (Container)this);
        this.navigatorPanel.addRenderer(osmNavigatorRenderer);
        MapScaleRenderer renderer = new MapScaleRenderer(ModelEnviroment.getMessageResolver().resolveMessage("messages.common.mapScale", new Serializable[0]));
        renderer.setNavigatorPanel(this.navigatorPanel);
        this.navigatorPanel.addRenderer(renderer);
        ZoomingRenderer zoomingRenderer = new ZoomingRenderer(this.navigatorPanel);
        zoomingRenderer.setNavigatorPanel(this.navigatorPanel);
        this.navigatorPanel.addRenderer(zoomingRenderer);
        this.navigatorPanel.addPreferredMouseManipulatorForClick(zoomingRenderer);
        DefaultMouseManipulator mouseManipulator = new DefaultMouseManipulator(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                if (NavigatorPanningAction.performWheelZoom(e, MultipleParcelEditorPane.this.navigatorPanel)) {
                    super.mouseWheelMoved(e);
                    MultipleParcelEditorPane.this.navigatorPanel.forceCalcTransform();
                }
            }
        };
        this.navigatorPanel.setMouseManipulator(mouseManipulator);
        this.simplePointRenderer1 = new DefaultSimplePointRenderer(Color.GREEN);
        this.navigatorPanel.addRenderer(this.simplePointRenderer1);
        this.simplePointRenderer2 = new DefaultSimplePointRenderer(Color.RED);
        this.navigatorPanel.addRenderer(this.simplePointRenderer2);
        split.setRightComponent(this.navigatorPanel);
        this.add((Component)split, "Center");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                split.setDividerLocation(0.7);
            }
        });
    }

    protected Coordinate getStartCoordinate() {
        String startString = ModelEnviroment.getProperties().getProperty("navigator.startCoordinate");
        Coordinate startCoordinate = null;
        if (startString != null) {
            try {
                Tupel<String, String[]> tupel = StringUtil.parseTokens(startString);
                CoordinateFactory factory = CoordinateFactory.getInstance(tupel.getElement1());
                startCoordinate = factory.createCoordinate(Double.valueOf(tupel.getElement2()[0]), Double.valueOf(tupel.getElement2()[1]));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (startCoordinate == null) {
            startCoordinate = MercatorFactory.INSTANCE.createCoordinate(1293576.0, 6116444.0);
        }
        return startCoordinate;
    }

    public void processChanges() {
        MultipleParcelTableModel model = (MultipleParcelTableModel)this.multipleTable.getModel();
        List<Tupel<Boolean, Boolean>> bools = model.getBools();
        List<Tupel<ParcelModel, ParcelModel>> multiples = model.getMultiples();
        Iterator<Tupel<ParcelModel, ParcelModel>> mIter = multiples.iterator();
        Iterator<Tupel<Boolean, Boolean>> bIter = bools.iterator();
        while (mIter.hasNext()) {
            Tupel<ParcelModel, ParcelModel> m = mIter.next();
            Tupel<Boolean, Boolean> b = bIter.next();
            if (b.getElement1().booleanValue() && !b.getElement2().booleanValue()) {
                this.mergeParcel(m.getElement2(), m.getElement1());
                continue;
            }
            if (!b.getElement2().booleanValue() || b.getElement1().booleanValue()) continue;
            this.mergeParcel(m.getElement1(), m.getElement2());
        }
    }

    private void mergeParcel(ParcelModel sourceParcel, ParcelModel targetParcel) {
        Collection<LocationModel> locations = this.modelEnviroment.getAllCaller().getBaseCaller().getLocationsForParcel(sourceParcel);
        for (LocationModel locationModel : locations) {
            locationModel.setParcel(targetParcel);
        }
        HashSet<AreaLayerModel> layers = new HashSet<AreaLayerModel>();
        for (AreaObjectParcelRelModel rel : targetParcel.iterableAreaObjectParcelRel()) {
            layers.add(rel.getAreaObject().getAreaLayer());
        }
        LinkedList<Model> linkedList = new LinkedList<Model>();
        LinkedList<AreaObjectParcelRelModel> toSetTargetRels = new LinkedList<AreaObjectParcelRelModel>();
        for (AreaObjectParcelRelModel rel : sourceParcel.iterableAreaObjectParcelRel()) {
            AreaLayerModel areaLayer = rel.getAreaObject().getAreaLayer();
            if (layers.contains(areaLayer)) {
                linkedList.add(rel);
                continue;
            }
            toSetTargetRels.add(rel);
        }
        for (AreaObjectParcelRelModel rel : toSetTargetRels) {
            rel.setParcel(targetParcel);
        }
        Collection<AreaStopModel> stops = this.modelEnviroment.getAllCaller().getTourCaller().fetchAreaStop(sourceParcel, null, null, null);
        HashSet<AreaTourModel> tours = new HashSet<AreaTourModel>();
        for (AreaStopModel areaStopModel : stops) {
            tours.add(areaStopModel.getAreaTourPart().getAreaTour());
        }
        for (AreaTourModel areaTourModel : tours) {
            for (AreaTourPartModel areaTourPartModel : areaTourModel.iterableAreaTourParts()) {
                for (AreaStopModel stop : areaTourPartModel.iterableAreaStops()) {
                    linkedList.add(stop);
                }
                linkedList.add(areaTourPartModel);
            }
            linkedList.add(areaTourModel);
        }
        HashSet<ParcelAttributeValueDescriptorModel> descriptors = new HashSet<ParcelAttributeValueDescriptorModel>();
        for (ParcelAttributeValueModel attr : targetParcel.iterableParcelAttributeValues()) {
            descriptors.add(attr.getParcelAttributeValueDescriptor());
        }
        LinkedList<ParcelAttributeValueModel> linkedList2 = new LinkedList<ParcelAttributeValueModel>();
        for (ParcelAttributeValueModel parcelAttributeValueModel : sourceParcel.iterableParcelAttributeValues()) {
            if (descriptors.contains(parcelAttributeValueModel.getParcelAttributeValueDescriptor())) {
                linkedList.add(parcelAttributeValueModel);
                continue;
            }
            linkedList2.add(parcelAttributeValueModel);
        }
        for (ParcelAttributeValueModel parcelAttributeValueModel : linkedList2) {
            parcelAttributeValueModel.setParcel(targetParcel);
        }
        for (Model model : linkedList) {
            model.delete();
        }
        sourceParcel.delete();
    }

    private class TableSelectionListener
    implements ListSelectionListener {
        private TableSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            int row = MultipleParcelEditorPane.this.multipleTable.getSelectedRow();
            if (row >= 0) {
                MultipleParcelTableModel model = (MultipleParcelTableModel)MultipleParcelEditorPane.this.multipleTable.getModel();
                Tupel<ParcelModel, ParcelModel> quad = model.getMultiples().get(row);
                ParcelModel parcel1 = quad.getElement1();
                ImmutablePoint geom1 = parcel1.getGeom();
                MultipleParcelEditorPane.this.simplePointRenderer1.setPoint(geom1);
                ParcelModel parcel2 = quad.getElement2();
                ImmutablePoint geom2 = parcel2.getGeom();
                MultipleParcelEditorPane.this.simplePointRenderer2.setPoint(geom2);
                MultipleParcelEditorPane.this.navigatorPanel.center(Arrays.asList(geom1.getCoordinate(), geom2.getCoordinate()), 5);
                double upp = MultipleParcelEditorPane.this.navigatorPanel.getUpp();
                if (upp < 1.0) {
                    MultipleParcelEditorPane.this.navigatorPanel.setUpp(1.0);
                }
                MultipleParcelEditorPane.this.navigatorPanel.repaint(10L);
            } else {
                MultipleParcelEditorPane.this.simplePointRenderer1.setPoint(null);
                MultipleParcelEditorPane.this.simplePointRenderer2.setPoint(null);
                MultipleParcelEditorPane.this.navigatorPanel.repaint(10L);
            }
        }
    }
}

