/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.importer.parcel.editor;

import de.datomino.peppergis.client.communication.StreetNetCaller;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.area.AreaLayerModel;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.client.model.area.AreaObjectParcelRelModel;
import de.datomino.peppergis.client.model.area.AreaObjectParcelRelModelImpl;
import de.datomino.peppergis.client.model.base.LocationModel;
import de.datomino.peppergis.client.model.map.CityAliasModel;
import de.datomino.peppergis.client.model.map.CityAliasModelImpl;
import de.datomino.peppergis.client.model.map.CityModel;
import de.datomino.peppergis.client.model.map.DistrictAliasModel;
import de.datomino.peppergis.client.model.map.DistrictAliasModelImpl;
import de.datomino.peppergis.client.model.map.DistrictModel;
import de.datomino.peppergis.client.model.map.ParcelAttributeValueDescriptorModel;
import de.datomino.peppergis.client.model.map.ParcelAttributeValueModel;
import de.datomino.peppergis.client.model.map.ParcelModel;
import de.datomino.peppergis.client.model.map.PostcodeDistrictRelationModel;
import de.datomino.peppergis.client.model.map.StreetAliasModel;
import de.datomino.peppergis.client.model.map.StreetAliasModelImpl;
import de.datomino.peppergis.client.model.map.StreetModel;
import de.datomino.peppergis.client.model.tour.AreaStopModel;
import de.datomino.peppergis.client.model.tour.AreaTourModel;
import de.datomino.peppergis.client.model.tour.AreaTourPartModel;
import de.datomino.peppergis.client.util.attribute.AttributeHelper;
import de.datomino.peppergis.client.util.wrapper.parcel.attribute.ParcelAttributeValueModelAttributeWrapper;
import de.datomino.peppergis.importer.parcel.editor.ParcelMover;
import java.awt.GridLayout;
import java.awt.Window;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.ktde.util.StringUtil;
import org.ktde.util.datatypes.Tripel;

public class ParcelMoverImpl
implements ParcelMover {
    private ModelEnviroment modelEnviroment;
    private Window parent;

    public ParcelMoverImpl(Window parent, ModelEnviroment modelEnviroment) {
        this.modelEnviroment = modelEnviroment;
        this.parent = parent;
    }

    @Override
    public boolean moveParcel(ParcelModel from, ParcelModel to, boolean createStreetAlias, boolean createDistrictAlias, boolean createCityAlias) {
        StreetNetCaller streetNetCaller = this.modelEnviroment.getAllCaller().getStreetNetCaller();
        Map<AreaLayerModel, AreaObjectModel> relMap = null;
        Set<ParcelAttributeValueModel> attributeSet = null;
        do {
            if ((relMap = this.getAreaObjectParcelRel(from, to)) == null) continue;
            attributeSet = this.getAttributes(from, to);
        } while (attributeSet == null && relMap != null);
        if (relMap != null && attributeSet != null) {
            this.moveAreaObjectParcelRel(from, to, relMap);
            this.moveAttributes(from, to, attributeSet);
            this.moveParcelLocations(from, to);
            this.moveAreaStops(from);
            this.createAlias(from, to, createStreetAlias, createDistrictAlias, createCityAlias);
            this.deleteParcel(from);
            return true;
        }
        return false;
    }

    private void deleteParcel(ParcelModel from) {
        from.delete();
    }

    private void moveAttributes(ParcelModel from, ParcelModel to, Set<ParcelAttributeValueModel> attributeSet) {
        HashSet<ParcelAttributeValueModel> toDeletes = new HashSet<ParcelAttributeValueModel>();
        for (ParcelAttributeValueModel parcelAttributeValueModel : from.iterableParcelAttributeValues()) {
            if (attributeSet.contains(parcelAttributeValueModel)) {
                parcelAttributeValueModel.setParcel(to);
                continue;
            }
            toDeletes.add(parcelAttributeValueModel);
        }
        for (ParcelAttributeValueModel parcelAttributeValueModel : to.iterableParcelAttributeValues()) {
            if (attributeSet.contains(parcelAttributeValueModel)) continue;
            toDeletes.add(parcelAttributeValueModel);
        }
        for (ParcelAttributeValueModel parcelAttributeValueModel : toDeletes) {
            parcelAttributeValueModel.setParcel(null);
            parcelAttributeValueModel.delete();
        }
    }

    private void moveAreaObjectParcelRel(ParcelModel from, ParcelModel to, Map<AreaLayerModel, AreaObjectModel> relMap) {
        for (AreaObjectParcelRelModel areaObjectParcelRelModel : from.iterableAreaObjectParcelRel()) {
            areaObjectParcelRelModel.setAreaObject(null);
            areaObjectParcelRelModel.setParcel(null);
            areaObjectParcelRelModel.delete();
        }
        HashSet<AreaLayerModel> todos = new HashSet<AreaLayerModel>(relMap.keySet());
        HashSet<AreaObjectParcelRelModel> toDeletes = new HashSet<AreaObjectParcelRelModel>();
        for (AreaObjectParcelRelModel areaObjectParcelRelModel : to.iterableAreaObjectParcelRel()) {
            AreaObjectModel areaObject = areaObjectParcelRelModel.getAreaObject();
            AreaLayerModel areaLayerModel = areaObject.getAreaLayer();
            if (todos.contains(areaLayerModel)) {
                AreaObjectModel newAreaObject = relMap.get(areaLayerModel);
                if (!areaObject.equals(newAreaObject)) {
                    areaObjectParcelRelModel.setAreaObject(newAreaObject);
                }
                todos.remove(areaLayerModel);
                continue;
            }
            toDeletes.add(areaObjectParcelRelModel);
        }
        for (AreaObjectParcelRelModel areaObjectParcelRelModel : toDeletes) {
            areaObjectParcelRelModel.setAreaObject(null);
            areaObjectParcelRelModel.setParcel(null);
            areaObjectParcelRelModel.delete();
        }
        for (AreaLayerModel layer : todos) {
            AreaObjectModel newAreaObject = relMap.get(layer);
            AreaObjectParcelRelModelImpl areaObjectParcelRelModel = new AreaObjectParcelRelModelImpl();
            areaObjectParcelRelModel.setAreaObject(newAreaObject);
            areaObjectParcelRelModel.setParcel(to);
        }
    }

    private void moveAreaStops(ParcelModel delete) {
        Collection<AreaStopModel> areaStops = this.modelEnviroment.getAllCaller().getTourCaller().fetchAreaStop(delete, null, null, null);
        for (AreaStopModel areaStop : areaStops) {
            AreaTourPartModel areaTourPart = areaStop.getAreaTourPart();
            if (areaTourPart != null && areaTourPart.countAreaStops() == 1) {
                AreaTourModel areaTour = areaTourPart.getAreaTour();
                if (areaTour != null && areaTour.countAreaTourParts() == 1) {
                    areaTour.delete();
                }
                areaTourPart.setAreaTour(null);
                areaTourPart.delete();
            }
            areaStop.setAreaTourPart(null);
            areaStop.delete();
        }
    }

    private Set<ParcelAttributeValueModel> getAttributes(ParcelModel from, ParcelModel to) {
        JRadioButton toButton;
        String name;
        ParcelAttributeValueDescriptorModel descriptor;
        TreeSet<ParcelAttributeValueDescriptorModel> descriptors = new TreeSet<ParcelAttributeValueDescriptorModel>(new Comparator<ParcelAttributeValueDescriptorModel>(){

            @Override
            public int compare(ParcelAttributeValueDescriptorModel o1, ParcelAttributeValueDescriptorModel o2) {
                int d = o1.getKey().compareTo(o2.getKey());
                if (d == 0) {
                    return o1.getId().compareTo(o2.getId());
                }
                return d;
            }
        });
        HashMap<ParcelAttributeValueDescriptorModel, ParcelAttributeValueModel> toMap = new HashMap<ParcelAttributeValueDescriptorModel, ParcelAttributeValueModel>();
        HashMap<ParcelAttributeValueDescriptorModel, ParcelAttributeValueModel> fromMap = new HashMap<ParcelAttributeValueDescriptorModel, ParcelAttributeValueModel>();
        for (ParcelAttributeValueModel parcelAttributeValueModel : to.iterableParcelAttributeValues()) {
            descriptor = parcelAttributeValueModel.getParcelAttributeValueDescriptor();
            descriptors.add(descriptor);
            toMap.put(descriptor, parcelAttributeValueModel);
        }
        for (ParcelAttributeValueModel parcelAttributeValueModel : from.iterableParcelAttributeValues()) {
            descriptor = parcelAttributeValueModel.getParcelAttributeValueDescriptor();
            descriptors.add(descriptor);
            fromMap.put(descriptor, parcelAttributeValueModel);
        }
        if (descriptors.isEmpty()) {
            return Collections.emptySet();
        }
        JPanel panel = new JPanel(new GridLayout(1 + descriptors.size(), 4));
        panel.add(new JLabel());
        String string = name = from == null ? "?" : from.getImportKey();
        if (StringUtil.isBlank(name)) {
            name = "?";
        }
        panel.add(new JLabel(name));
        String string2 = name = to == null ? "?" : to.getImportKey();
        if (StringUtil.isBlank(name)) {
            name = "?";
        }
        panel.add(new JLabel(name));
        panel.add(new JLabel());
        HashMap<ParcelAttributeValueDescriptorModel, Tripel<JRadioButton, JRadioButton, JRadioButton>> buttonMap = new HashMap<ParcelAttributeValueDescriptorModel, Tripel<JRadioButton, JRadioButton, JRadioButton>>();
        for (ParcelAttributeValueDescriptorModel descriptor2 : descriptors) {
            panel.add(new JLabel(descriptor2.getName() + "(" + descriptor2.getKey() + ")"));
            ButtonGroup buttonGroup = new ButtonGroup();
            ParcelAttributeValueModel fromParcelAttributeValueModel = (ParcelAttributeValueModel)fromMap.get(descriptor2);
            JRadioButton fromButton = null;
            if (fromParcelAttributeValueModel == null) {
                panel.add(new JLabel());
            } else {
                fromButton = new JRadioButton(AttributeHelper.getTextRepresentationValue(new ParcelAttributeValueModelAttributeWrapper(fromParcelAttributeValueModel)), true);
                buttonGroup.add(fromButton);
                panel.add(fromButton);
            }
            ParcelAttributeValueModel toParcelAttributeValueModel = (ParcelAttributeValueModel)toMap.get(descriptor2);
            toButton = null;
            if (toParcelAttributeValueModel == null) {
                panel.add(new JLabel());
            } else {
                toButton = new JRadioButton(AttributeHelper.getTextRepresentationValue(new ParcelAttributeValueModelAttributeWrapper(toParcelAttributeValueModel)), fromButton == null);
                buttonGroup.add(toButton);
                panel.add(toButton);
            }
            JRadioButton noButton = new JRadioButton("", false);
            buttonGroup.add(noButton);
            panel.add(noButton);
            buttonMap.put(descriptor2, new Tripel<JRadioButton, JRadioButton, JRadioButton>(fromButton, toButton, noButton));
        }
        int d = JOptionPane.showOptionDialog(this.parent, panel, ModelEnviroment.getMessageResolver().resolveMessage("messages.default.question", new Serializable[0]), -1, 3, null, new Object[]{ModelEnviroment.getMessageResolver().resolveMessage("messages.default.back", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("messages.default.forward", new Serializable[0])}, null);
        switch (d) {
            case 0: {
                return null;
            }
            case 1: {
                HashSet<ParcelAttributeValueModel> result = new HashSet<ParcelAttributeValueModel>();
                for (ParcelAttributeValueDescriptorModel descriptor3 : descriptors) {
                    Tripel tripel = (Tripel)buttonMap.get(descriptor3);
                    JRadioButton fromButton = (JRadioButton)tripel.getElement1();
                    if (fromButton != null && fromButton.isSelected()) {
                        ParcelAttributeValueModel parcelAttributeValueModel = (ParcelAttributeValueModel)fromMap.get(descriptor3);
                        result.add(parcelAttributeValueModel);
                        continue;
                    }
                    toButton = (JRadioButton)tripel.getElement2();
                    if (toButton == null || !toButton.isSelected()) continue;
                    ParcelAttributeValueModel parcelAttributeValueModel = (ParcelAttributeValueModel)toMap.get(descriptor3);
                    result.add(parcelAttributeValueModel);
                }
                return result;
            }
        }
        return null;
    }

    private void createAlias(ParcelModel from, ParcelModel to, boolean createStreetAlias, boolean createDistrictAlias, boolean createCityAlias) {
        if (createStreetAlias || createDistrictAlias || createCityAlias) {
            CityModel toCity;
            DistrictModel toDistrict;
            PostcodeDistrictRelationModel postcodeDistrictRelationModel;
            StreetModel toStreet;
            String fromStreetName = null;
            String fromDistrictName = null;
            String fromCityName = null;
            StreetModel fromStreet = from.getStreet();
            if (fromStreet != null) {
                DistrictModel fromDistrict;
                fromStreetName = fromStreet.getName();
                PostcodeDistrictRelationModel postcodeDistrictRelation = fromStreet.getPostcodeDistrictRelation();
                if (postcodeDistrictRelation != null && (fromDistrict = postcodeDistrictRelation.getDistrict()) != null) {
                    fromDistrictName = fromDistrict.getName();
                    CityModel fromCity = fromDistrict.getCity();
                    if (fromCity != null) {
                        fromCityName = fromCity.getName();
                    }
                }
            }
            if (createStreetAlias && !StringUtil.isBlank(fromStreetName) && (toStreet = to.getStreet()) != null) {
                boolean found = false;
                for (StreetAliasModel streetAlias : toStreet.iterableAlias()) {
                    if (!streetAlias.getName().equalsIgnoreCase(fromStreetName)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    StreetAliasModelImpl streetAlias = new StreetAliasModelImpl();
                    streetAlias.setStreet(toStreet);
                    streetAlias.setName(fromStreetName);
                    streetAlias.setSearch(StringUtil.normalize(fromStreetName));
                }
            }
            if (createDistrictAlias && !StringUtil.isBlank(fromDistrictName) && (toStreet = to.getStreet()) != null && (postcodeDistrictRelationModel = toStreet.getPostcodeDistrictRelation()) != null && (toDistrict = postcodeDistrictRelationModel.getDistrict()) != null) {
                boolean found = false;
                for (DistrictAliasModel districtAliasModel : toDistrict.iterableAlias()) {
                    if (!districtAliasModel.getName().equalsIgnoreCase(fromDistrictName)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    DistrictAliasModelImpl districtAlias = new DistrictAliasModelImpl();
                    districtAlias.setDistrict(toDistrict);
                    districtAlias.setName(fromDistrictName);
                    districtAlias.setSearch(StringUtil.normalize(fromDistrictName));
                }
            }
            if (createCityAlias && !StringUtil.isBlank(fromCityName) && (toStreet = to.getStreet()) != null && (postcodeDistrictRelationModel = toStreet.getPostcodeDistrictRelation()) != null && (toDistrict = postcodeDistrictRelationModel.getDistrict()) != null && (toCity = toDistrict.getCity()) != null) {
                boolean found = false;
                for (CityAliasModel cityAlias : toCity.iterableAlias()) {
                    if (!cityAlias.getName().equalsIgnoreCase(fromCityName)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    CityAliasModelImpl cityAliasModelImpl = new CityAliasModelImpl();
                    cityAliasModelImpl.setCity(toCity);
                    cityAliasModelImpl.setName(fromCityName);
                    cityAliasModelImpl.setSearch(StringUtil.normalize(fromCityName));
                }
            }
        }
    }

    private void moveParcelLocations(ParcelModel from, ParcelModel to) {
        Collection<LocationModel> locations = this.modelEnviroment.getAllCaller().getBaseCaller().getLocationsForParcel(from);
        for (LocationModel location : locations) {
            location.setParcel(to);
        }
    }

    private Map<AreaLayerModel, AreaObjectModel> getAreaObjectParcelRel(ParcelModel from, ParcelModel to) {
        JRadioButton toButton;
        String name;
        AreaLayerModel layer;
        TreeSet<AreaLayerModel> layers = new TreeSet<AreaLayerModel>(new Comparator<AreaLayerModel>(){

            @Override
            public int compare(AreaLayerModel o1, AreaLayerModel o2) {
                int d = o1.getDisplayname().compareTo(o2.getDisplayname());
                if (d == 0) {
                    return o1.getId().compareTo(o2.getId());
                }
                return d;
            }
        });
        HashMap<AreaLayerModel, AreaObjectParcelRelModel> toMap = new HashMap<AreaLayerModel, AreaObjectParcelRelModel>();
        HashMap<AreaLayerModel, AreaObjectParcelRelModel> fromMap = new HashMap<AreaLayerModel, AreaObjectParcelRelModel>();
        for (AreaObjectParcelRelModel areaObjectParcelRelModel : to.iterableAreaObjectParcelRel()) {
            layer = areaObjectParcelRelModel.getAreaObject().getAreaLayer();
            layers.add(layer);
            toMap.put(layer, areaObjectParcelRelModel);
        }
        for (AreaObjectParcelRelModel areaObjectParcelRelModel : from.iterableAreaObjectParcelRel()) {
            layer = areaObjectParcelRelModel.getAreaObject().getAreaLayer();
            layers.add(layer);
            fromMap.put(layer, areaObjectParcelRelModel);
        }
        if (layers.isEmpty()) {
            return Collections.emptyMap();
        }
        JPanel panel = new JPanel(new GridLayout(1 + layers.size(), 4));
        panel.add(new JLabel());
        String string = name = from == null ? "?" : from.getImportKey();
        if (StringUtil.isBlank(name)) {
            name = "?";
        }
        panel.add(new JLabel(name));
        String string2 = name = to == null ? "?" : to.getImportKey();
        if (StringUtil.isBlank(name)) {
            name = "?";
        }
        panel.add(new JLabel(name));
        panel.add(new JLabel());
        HashMap<AreaLayerModel, Tripel<JRadioButton, JRadioButton, JRadioButton>> buttonMap = new HashMap<AreaLayerModel, Tripel<JRadioButton, JRadioButton, JRadioButton>>();
        for (AreaLayerModel layer2 : layers) {
            panel.add(new JLabel(layer2.getDisplayname()));
            ButtonGroup buttonGroup = new ButtonGroup();
            AreaObjectParcelRelModel fromAreaObjectParcelRelModel = (AreaObjectParcelRelModel)fromMap.get(layer2);
            JRadioButton fromButton = null;
            if (fromAreaObjectParcelRelModel == null) {
                panel.add(new JLabel());
            } else {
                fromButton = new JRadioButton(fromAreaObjectParcelRelModel.getAreaObject().getShortcut(), true);
                buttonGroup.add(fromButton);
                panel.add(fromButton);
            }
            AreaObjectParcelRelModel toAreaObjectParcelRelModel = (AreaObjectParcelRelModel)toMap.get(layer2);
            toButton = null;
            if (toAreaObjectParcelRelModel == null) {
                panel.add(new JLabel());
            } else {
                toButton = new JRadioButton(toAreaObjectParcelRelModel.getAreaObject().getShortcut(), fromButton == null);
                buttonGroup.add(toButton);
                panel.add(toButton);
            }
            JRadioButton noButton = new JRadioButton("", false);
            buttonGroup.add(noButton);
            panel.add(noButton);
            buttonMap.put(layer2, new Tripel<JRadioButton, JRadioButton, JRadioButton>(fromButton, toButton, noButton));
        }
        int d = JOptionPane.showOptionDialog(this.parent, panel, ModelEnviroment.getMessageResolver().resolveMessage("messages.default.question", new Serializable[0]), -1, 3, null, new Object[]{ModelEnviroment.getMessageResolver().resolveMessage("messages.default.back", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("messages.default.forward", new Serializable[0])}, null);
        switch (d) {
            case 0: {
                return null;
            }
            case 1: {
                HashMap<AreaLayerModel, AreaObjectModel> result = new HashMap<AreaLayerModel, AreaObjectModel>();
                for (AreaLayerModel layer3 : layers) {
                    Tripel tripel = (Tripel)buttonMap.get(layer3);
                    JRadioButton fromButton = (JRadioButton)tripel.getElement1();
                    if (fromButton != null && fromButton.isSelected()) {
                        AreaObjectParcelRelModel areaObjectParcelRelModel = (AreaObjectParcelRelModel)fromMap.get(layer3);
                        result.put(layer3, areaObjectParcelRelModel.getAreaObject());
                        continue;
                    }
                    toButton = (JRadioButton)tripel.getElement2();
                    if (toButton == null || !toButton.isSelected()) continue;
                    AreaObjectParcelRelModel areaObjectParcelRelModel = (AreaObjectParcelRelModel)toMap.get(layer3);
                    result.put(layer3, areaObjectParcelRelModel.getAreaObject());
                }
                return result;
            }
        }
        return null;
    }
}

