/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.importer.parcel.editor;

import de.datomino.peppergis.client.gui.renderer.AbstractTableRenderer;
import de.datomino.peppergis.client.model.admin.UserModel;
import de.datomino.peppergis.client.model.map.ParcelModel;
import de.datomino.peppergis.type.ImportParcelStatus;
import de.datomino.peppergis.util.GeoUtil;
import java.awt.Color;
import java.awt.Component;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JTable;
import javax.swing.JTextField;

public abstract class ImportParcelModelTableCellRenderer
extends AbstractTableRenderer {
    private Map<ParcelModel, Integer> importMap;

    public ImportParcelModelTableCellRenderer(Map<ParcelModel, Integer> importMap) {
        this.importMap = importMap;
    }

    protected abstract boolean isSelected(int var1, int var2);

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        ParcelModel parcel;
        if (value == null) {
            value = "";
        }
        if (value instanceof ParcelModel) {
            Integer tupel = this.importMap.get(value);
            value = tupel == null ? "" : tupel;
        } else if (value instanceof UserModel) {
            value = ((UserModel)value).getName();
        }
        JTextField textField = new JTextField(value.toString());
        textField.setFont(table.getFont());
        textField.setBorder(BorderFactory.createEmptyBorder());
        if (this.isSelected(row, column)) {
            textField.setBackground(Color.YELLOW);
        }
        if (column == 0) {
            textField.setHorizontalAlignment(0);
        }
        if (GeoUtil.isNullPoint((parcel = (ParcelModel)table.getValueAt(row, 0)).getGeom())) {
            textField.setForeground(Color.RED);
        } else if (this.importMap.get(parcel) == null) {
            textField.setForeground(Color.GREEN.darker());
        } else {
            Color color;
            ImportParcelStatus importStatus = parcel.getImportStatus();
            if (importStatus == null) {
                color = Color.BLUE;
            } else {
                switch (importStatus) {
                    case CHANGED: 
                    case CHECKED: {
                        color = Color.BLUE;
                        break;
                    }
                    case NOTCHECKED: {
                        color = Color.GREEN.darker();
                        break;
                    }
                    default: {
                        color = Color.RED;
                    }
                }
            }
            textField.setForeground(color);
        }
        return textField;
    }
}

