/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.importer.parcel;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.map.ParcelModel;
import de.datomino.peppergis.client.model.map.ParcelModelImpl;
import de.datomino.peppergis.client.util.ParcelModelUtil;
import de.datomino.peppergis.importer.parcel.AddParcelPane;
import de.datomino.util.swing.SwingUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.Serializable;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import org.ktde.util.StringUtil;

public abstract class AbstractAddParcelAction
extends AbstractAction {
    private static final long serialVersionUID = -5807939822081022361L;
    private ModelEnviroment modelEnviroment;
    private Component parent;
    private AddParcelPane addParcelPane;

    public AbstractAddParcelAction(ModelEnviroment modelEnviroment, Component parent) {
        super(ModelEnviroment.getMessageResolver().resolveMessage("gui.parcel.add", new Serializable[0]));
        this.modelEnviroment = modelEnviroment;
        this.parent = parent;
    }

    protected abstract boolean update(ParcelModel var1);

    @Override
    public void actionPerformed(ActionEvent e) {
        final JDialog dialog = new JDialog(null, "", Dialog.ModalityType.APPLICATION_MODAL);
        try {
            dialog.setIconImage(ImageIO.read(AbstractAddParcelAction.class.getResourceAsStream("/images/pepper.png")));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        JPanel panel = new JPanel(new BorderLayout());
        this.modelEnviroment.getUndoManager().finishTransaction("");
        this.modelEnviroment.getUndoManager().startTransaction();
        this.addParcelPane = new AddParcelPane(this.modelEnviroment);
        panel.add((Component)this.addParcelPane, "Center");
        JPanel buttonPanel = new JPanel(new FlowLayout());
        buttonPanel.add(new JButton(new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.cancel", new Serializable[0])){
            private static final long serialVersionUID = 709827446597346756L;

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractAddParcelAction.this.rollback();
                dialog.dispose();
            }
        }));
        buttonPanel.add(new JButton(new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("gui.parcel.addAndContinue", new Serializable[0])){
            private static final long serialVersionUID = 3963482407922456906L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AbstractAddParcelAction.this.addParcel()) {
                    AbstractAddParcelAction.this.addParcelPane.setParcel(new ParcelModelImpl());
                }
            }
        }));
        buttonPanel.add(new JButton(new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("gui.parcel.add", new Serializable[0])){
            private static final long serialVersionUID = 709827446597346756L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AbstractAddParcelAction.this.addParcel()) {
                    dialog.dispose();
                }
            }
        }));
        buttonPanel.setBorder(new TitledBorder(""));
        panel.add((Component)buttonPanel, "South");
        dialog.getContentPane().add(panel);
        dialog.pack();
        SwingUtils.centerDialog(dialog, this.parent);
        dialog.setVisible(true);
    }

    private boolean addParcel() {
        boolean result = false;
        try {
            this.addParcelPane.adaptValuesToModel(true);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.addParcelPane, ModelEnviroment.getMessageResolver().resolveMessage("errors.import.coordsNotValid", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("messages.default.error", new Serializable[0]), 0);
            return false;
        }
        ParcelModel parcel = this.addParcelPane.getParcel();
        if (parcel.getStreet() == null || StringUtil.isBlank(parcel.getStreet().getName()) || StringUtil.isBlank(parcel.getHouseNumber())) {
            JOptionPane.showMessageDialog(this.addParcelPane, "Die Adresse ist nicht vollst\u00e4ndig.", "", 2);
        } else if (!this.hasAddress(parcel)) {
            boolean b = this.update(parcel);
            if (b) {
                this.modelEnviroment.getUndoManager().finishTransaction("Neues Geb\u00e4ude - " + ParcelModelUtil.getDisplayString(parcel));
                this.modelEnviroment.getUndoManager().startTransaction();
            }
            result = b;
        } else {
            JOptionPane.showMessageDialog(this.addParcelPane, "Die Adresse ist vorhanden.", "", 2);
        }
        return result;
    }

    private void rollback() {
        this.modelEnviroment.getUndoManager().rollbackTransaction();
        this.modelEnviroment.getUndoManager().startTransaction();
    }

    private boolean hasAddress(ParcelModel parcel) {
        return this.addParcelPane.hasAddress(parcel);
    }
}

