/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.importer.letter;

import de.datomino.peppergis.client.gui.asynchronous.AbstractAsynchronousDialog;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.importer.AbstractAddressCsvImporter;
import de.datomino.peppergis.client.message.EnumMessageResolverNameGenerator;
import de.datomino.peppergis.client.model.area.AreaLayerModel;
import de.datomino.peppergis.client.util.ClientSwingUtil;
import de.datomino.peppergis.dto.area.AreaLayerDto;
import de.datomino.peppergis.dto.asynchronous.AsynchronousDto;
import de.datomino.peppergis.dto.importer.GenericCsvDto;
import de.datomino.peppergis.dto.importer.LetterImportDto;
import de.datomino.peppergis.dto.importer.LetterImportReportDto;
import de.datomino.peppergis.exception.ClientImportException;
import de.datomino.peppergis.type.AreaObjectGenInfoDiscriminator;
import de.datomino.peppergis.type.LetterDeliveryType;
import de.datomino.util.assistant.editor.Worker;
import de.datomino.util.assistant.model.ChoiceField;
import de.datomino.util.assistant.model.CsvColumnChoiceField;
import de.datomino.util.assistant.model.CsvContentGuesser;
import de.datomino.util.assistant.model.Fieldset;
import de.datomino.util.callback.CallBack;
import de.datomino.util.message.MessageResolver;
import de.datomino.util.message.error.ErrorMessages;
import java.awt.Window;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.ktde.math.projection.CoordinateFactory;
import org.ktde.util.NameGenerator;
import org.ktde.util.datatypes.Tupel;
import org.ktde.util.io.CsvReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LetterImporter
extends AbstractAddressCsvImporter<LetterImportDto> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LetterImporter.class);
    private ChoiceField<AreaLayerModel> layerField;
    private ChoiceField<CoordinateFactory.Projections> coordinateFactoryField;
    private CsvColumnChoiceField xField;
    private CsvColumnChoiceField yField;
    private CsvColumnChoiceField parcelIdField;
    private CsvColumnChoiceField lastNameField;
    private CsvColumnChoiceField firstNameField;
    private CsvColumnChoiceField companyNameField;
    private CsvColumnChoiceField areaShortcutField;
    private CsvColumnChoiceField letterNumberField;
    private CsvColumnChoiceField letterDeliveryTypeField;
    private CsvColumnChoiceField dateField;
    private CsvColumnChoiceField deleteField;

    public LetterImporter() {
        MessageResolver messageResolver = ModelEnviroment.getMessageResolver();
        Collection<AreaLayerModel> areaLayers = new ModelEnviroment(null).getAllCaller().getAreaCaller().getAreaLayersForType(AreaObjectGenInfoDiscriminator.values());
        this.layerField = new ChoiceField<1>(ModelEnviroment.getMessageResolver().resolveMessage("messages.import.area.layer", new Serializable[0]), (Collection<1>)areaLayers, new NameGenerator<AreaLayerModel>(){

            @Override
            public String getName(AreaLayerModel t) {
                return t == null ? ModelEnviroment.getMessageResolver().resolveMessage("messages.default.pleaseChoose", new Serializable[0]) : t.getDisplayname();
            }
        });
        Collection<CoordinateFactory.Projections> projections = CoordinateFactory.getListableProjections();
        CoordinateFactory.Projections[] values = new CoordinateFactory.Projections[projections.size()];
        values = projections.toArray(values);
        this.coordinateFactoryField = new ChoiceField<CoordinateFactory.Projections>(messageResolver.resolveMessage("messages.default.coordinateFactory", new Serializable[0]), values, new EnumMessageResolverNameGenerator(), CoordinateFactory.Projections.Wgs84);
        this.xField = new CsvColumnChoiceField(messageResolver.resolveMessageForEnum(GenericCsvDto.AddressColumns.X), (Serializable)((Object)GenericCsvDto.AddressColumns.X), this.createRegexForXCoordinate(), true);
        this.yField = new CsvColumnChoiceField(messageResolver.resolveMessageForEnum(GenericCsvDto.AddressColumns.Y), (Serializable)((Object)GenericCsvDto.AddressColumns.Y), this.createRegexForYCoordinate(), true);
        this.parcelIdField = new CsvColumnChoiceField(messageResolver.resolveMessageForEnum(LetterImportDto.Columns.PARCEL_ID), (Serializable)((Object)LetterImportDto.Columns.PARCEL_ID), this.createRegex("Geb\u00e4ude-Nummer", "Geb\u00e4ude", "GBD-Nr."), false);
        this.lastNameField = new CsvColumnChoiceField(messageResolver.resolveMessageForEnum(LetterImportDto.Columns.LAST_NAME), (Serializable)((Object)LetterImportDto.Columns.LAST_NAME), this.createRegex("Nachname", "Familienname"), true);
        this.companyNameField = new CsvColumnChoiceField(messageResolver.resolveMessageForEnum(LetterImportDto.Columns.COMPANY_NAME), (Serializable)((Object)LetterImportDto.Columns.COMPANY_NAME), this.createRegex("Firma", "Firmenname", "Kundenfirmenname"), true);
        this.firstNameField = new CsvColumnChoiceField(messageResolver.resolveMessageForEnum(LetterImportDto.Columns.FIRST_NAME), (Serializable)((Object)LetterImportDto.Columns.FIRST_NAME), this.createRegex("Vorname"), true);
        this.areaShortcutField = new CsvColumnChoiceField(messageResolver.resolveMessageForEnum(LetterImportDto.Columns.AREA_SHORTCUT), (Serializable)((Object)LetterImportDto.Columns.AREA_SHORTCUT), this.createRegex("Gebiets-Nummer", "Gebietsnummer", "Gebiet", "Gebiets-ID"), false);
        this.letterNumberField = new CsvColumnChoiceField(messageResolver.resolveMessageForEnum(LetterImportDto.Columns.LETTER_NUMBER), (Serializable)((Object)LetterImportDto.Columns.LETTER_NUMBER), this.createRegex("Briefnummer", "Brief-Nr.", "Brief-ID", "Nummer", "ID"), false);
        this.letterDeliveryTypeField = new CsvColumnChoiceField(messageResolver.resolveMessage(LetterDeliveryType.class.getName(), new Serializable[0]), (Serializable)((Object)LetterImportDto.Columns.DELIVERY_TYPE), this.createRegex("Brief-Zustelltyp", "Zustelltyp"), true);
        this.dateField = new CsvColumnChoiceField(messageResolver.resolveMessageForEnum(LetterImportDto.Columns.DATE), (Serializable)((Object)LetterImportDto.Columns.DATE), this.createRegex("Brief-Datum", "Datum"), false);
        this.deleteField = new CsvColumnChoiceField(messageResolver.resolveMessageForEnum(LetterImportDto.Columns.DELETE), (Serializable)((Object)LetterImportDto.Columns.DELETE), this.createRegex("L\u00f6schen", "zu l\u00f6schen", "entfernen", "delete"), true);
    }

    @Override
    protected void addCsvFields(List<CsvColumnChoiceField> choiceFields) {
        choiceFields.add(this.letterNumberField);
        choiceFields.add(this.firstNameField);
        choiceFields.add(this.lastNameField);
        choiceFields.add(this.companyNameField);
        choiceFields.add(this.parcelIdField);
        super.addCsvFields(choiceFields);
        choiceFields.add(this.xField);
        choiceFields.add(this.yField);
        choiceFields.add(this.areaShortcutField);
        choiceFields.add(this.letterDeliveryTypeField);
        choiceFields.add(this.dateField);
        choiceFields.add(this.deleteField);
    }

    @Override
    public String getTitle() {
        return ModelEnviroment.getMessageResolver().resolveMessage("importer.letter.title", new Serializable[0]);
    }

    @Override
    protected List<Fieldset> getAdditionalFieldsets() {
        Fieldset geo = new Fieldset(ModelEnviroment.getMessageResolver().resolveMessage("messages.importer.letter.geo", new Serializable[0]));
        geo.addField(this.layerField);
        geo.addField(this.coordinateFactoryField);
        return Collections.singletonList(geo);
    }

    @Override
    protected void writeToDto(LetterImportDto dto) {
        super.writeToDto(dto);
        dto.setAreaLayer((AreaLayerDto)((Object)((AreaLayerModel)this.layerField.getValue()).createDto()));
        dto.setCoordinateFactory((CoordinateFactory.Projections)((Object)this.coordinateFactoryField.getValue()));
        dto.setSource(((File)this.fileField.getValue()).getName());
    }

    @Override
    protected List<CallBack<Boolean, Window>> getAdditonalFileLeaveActions(final CsvContentGuesser contentGuesser) {
        List<CallBack<Boolean, Window>> actions2 = super.getAdditonalFileLeaveActions(contentGuesser);
        ArrayList<CallBack<Boolean, Window>> allActions = new ArrayList<CallBack<Boolean, Window>>(actions2.size() + 1);
        allActions.addAll(actions2);
        allActions.add(new CallBack<Boolean, Window>(){

            public Boolean execute(Window ... s) {
                File file = contentGuesser.getFile();
                if (file == null || !file.isFile()) {
                    throw new RuntimeException(new FileNotFoundException(file == null ? "" : file.getAbsolutePath()));
                }
                try {
                    CsvReader csvReader = new CsvReader(file, contentGuesser.getEncoding());
                    csvReader.setDelim(Character.valueOf(contentGuesser.getDelim()));
                    csvReader.setText(Character.valueOf(contentGuesser.getTextQuote()));
                    csvReader.readLine();
                    csvReader.close();
                }
                catch (IOException e1) {
                    throw new RuntimeException(e1);
                }
                return true;
            }
        });
        return allActions;
    }

    protected LetterImportDto getDto() {
        LetterImportDto dto = new LetterImportDto();
        this.writeToDto(dto);
        return dto;
    }

    @Override
    public Worker getWorker(final Window parent) {
        return new Worker(){
            private Worker.State state;
            private String resultString;

            @Override
            public void process() {
                ModelEnviroment modelEnviroment = new ModelEnviroment(null);
                StringBuilder builder = new StringBuilder();
                try {
                    Tupel result;
                    String message = ModelEnviroment.getMessageResolver().resolveMessage("messages.import.letter.importing", new Serializable[0]);
                    AbstractAsynchronousDialog<LetterImportReportDto> asynchronousDialog = new AbstractAsynchronousDialog<LetterImportReportDto>(parent, message, message, 1, true, modelEnviroment){
                        private static final long serialVersionUID = -1127458576478099632L;

                        @Override
                        protected AsynchronousDto<LetterImportReportDto> getAsynchronousDto(String token) {
                            return this.getModelEnviroment().getAllCaller().getAsynchronousCaller().getImportLetterCsvResult(token);
                        }

                        @Override
                        protected String startAsynchronous() {
                            return this.getModelEnviroment().getAllCaller().getAsynchronousCaller().importLetterCsv(LetterImporter.this.getDto());
                        }
                    };
                    try {
                        result = asynchronousDialog.run();
                    }
                    catch (Exception e) {
                        if (e instanceof ClientImportException) {
                            throw (ClientImportException)e;
                        }
                        if (e instanceof RuntimeException) {
                            throw (RuntimeException)e;
                        }
                        throw new RuntimeException(e);
                    }
                    LetterImportReportDto report = (LetterImportReportDto)result.getElement1();
                    ClientSwingUtil.saveContentToFile(report.getContent(), parent);
                    String reportMessage = ModelEnviroment.getMessageResolver().resolveMessage("messages.importer.letter.result", report.getNewCount(), report.getUpdatedCount(), report.getDeletedCount(), report.getUnchangedCount(), report.getRejectedCount(), report.getPostWorkCount());
                    builder.append(reportMessage).append("\n");
                    ErrorMessages errorMessages = report.getErrorMessages();
                    if (errorMessages.hasErrors()) {
                        builder.append(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.error", new Serializable[0])).append(":\n\n");
                        builder.append(ModelEnviroment.getMessageResolver().resolveMessages(errorMessages, "\n", 10));
                        this.state = Worker.State.ERROR;
                    } else {
                        this.state = Worker.State.OK;
                    }
                }
                catch (ClientImportException e) {
                    LOGGER.warn(e.getMessage(), e);
                    ErrorMessages errorMessages = e.getErrorMessages();
                    if (errorMessages != null && errorMessages.hasErrors()) {
                        builder.append(ModelEnviroment.getMessageResolver().resolveMessages(errorMessages, "\n", 10));
                    }
                    builder.append(e.getMessage());
                }
                this.resultString = builder.toString();
            }

            @Override
            public String getResultString() {
                return this.resultString;
            }

            @Override
            public Worker.State getResultState() {
                return this.state;
            }
        };
    }
}

