/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.importer.geotrack;

import de.datomino.peppergis.client.gui.asynchronous.AbstractAsynchronousDialog;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.importer.AbstractXmlImporter;
import de.datomino.peppergis.dto.asynchronous.AsynchronousDto;
import de.datomino.peppergis.dto.importer.GeoTrackGpxImportDto;
import de.datomino.peppergis.dto.importer.GeoTrackImportResultDto;
import de.datomino.peppergis.exception.ClientImportException;
import de.datomino.util.assistant.editor.Worker;
import de.datomino.util.assistant.model.Fieldset;
import de.datomino.util.assistant.model.StringField;
import de.datomino.util.message.error.ErrorMessages;
import java.awt.Window;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.ktde.util.datatypes.Tupel;

public class GeoTrackGpxImporter
extends AbstractXmlImporter<GeoTrackGpxImportDto> {
    private StringField tourField;
    private StringField accountField;
    private ModelEnviroment modelEnviroment;

    public GeoTrackGpxImporter(Window parent) {
        super(Collections.singletonList(new FileNameExtensionFilter("GPX", "gpx", "GPX")));
        this.modelEnviroment = new ModelEnviroment(parent);
        this.tourField = new StringField(ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.tour", new Serializable[0]));
        this.accountField = new StringField(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.account", new Serializable[0]));
    }

    @Override
    public Worker getWorker(final Window parent) {
        return new Worker(){
            private Worker.State state;
            private Tupel<GeoTrackImportResultDto, Boolean> geoTrackImportResultDto;

            @Override
            public void process() {
                final GeoTrackGpxImportDto geoTrackGpxImportDto = new GeoTrackGpxImportDto();
                GeoTrackGpxImporter.this.writeToDto(geoTrackGpxImportDto);
                String message = ModelEnviroment.getMessageResolver().resolveMessage("messages.import.geoTrack.importing", new Serializable[0]);
                AbstractAsynchronousDialog<GeoTrackImportResultDto> asynchronousDialog = new AbstractAsynchronousDialog<GeoTrackImportResultDto>(parent, message, message, 1, GeoTrackGpxImporter.this.modelEnviroment){
                    private static final long serialVersionUID = 583077827525099193L;

                    @Override
                    protected AsynchronousDto<GeoTrackImportResultDto> getAsynchronousDto(String token) {
                        return this.getModelEnviroment().getAllCaller().getAsynchronousCaller().getImportGeoTrackingsResultGpx(token);
                    }

                    @Override
                    protected String startAsynchronous() {
                        return this.getModelEnviroment().getAllCaller().getAsynchronousCaller().importGeoTrackingsGpx(geoTrackGpxImportDto);
                    }
                };
                try {
                    this.geoTrackImportResultDto = asynchronousDialog.run();
                }
                catch (ClientImportException e) {
                    this.geoTrackImportResultDto = new Tupel<GeoTrackImportResultDto, Boolean>(new GeoTrackImportResultDto(), false);
                    this.geoTrackImportResultDto.getElement1().setErrorMessages(e.getErrorMessages());
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                ErrorMessages errorMessages = this.geoTrackImportResultDto.getElement1().getErrorMessages();
                this.state = errorMessages != null && errorMessages.hasErrors() ? Worker.State.ERROR : Worker.State.OK;
            }

            @Override
            public String getResultString() {
                ErrorMessages errorMessages = this.geoTrackImportResultDto.getElement1().getErrorMessages();
                if (errorMessages != null && errorMessages.hasErrors()) {
                    StringBuilder sb = new StringBuilder(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.error", new Serializable[0])).append(": ");
                    sb.append(ModelEnviroment.getMessageResolver().resolveMessages(errorMessages, "\n"));
                    return sb.toString();
                }
                return "Importierte Geotracks: " + this.geoTrackImportResultDto.getElement1().getCount();
            }

            @Override
            public Worker.State getResultState() {
                return this.state;
            }
        };
    }

    @Override
    protected void writeToDto(GeoTrackGpxImportDto dto) {
        super.writeToDto(dto);
        dto.setAccount((String)this.accountField.getValue());
        dto.setTourName((String)this.tourField.getValue());
    }

    @Override
    public String getTitle() {
        return ModelEnviroment.getMessageResolver().resolveMessage("messages.import.geoTrackImport.gpx", new Serializable[0]);
    }

    @Override
    protected List<Fieldset> getAdditionalFileFieldSets() {
        List<Fieldset> additionalFileFieldSets = super.getAdditionalFileFieldSets();
        if (additionalFileFieldSets == null) {
            additionalFileFieldSets = Collections.emptyList();
        }
        ArrayList<Fieldset> newAdditionalFileFieldSets = new ArrayList<Fieldset>(additionalFileFieldSets.size() + 1);
        newAdditionalFileFieldSets.addAll(additionalFileFieldSets);
        Fieldset fieldset = new Fieldset();
        fieldset.addField(this.tourField);
        fieldset.addField(this.accountField);
        newAdditionalFileFieldSets.add(fieldset);
        return newAdditionalFileFieldSets;
    }
}

