/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.importer.geotrack;

import de.datomino.peppergis.client.gui.asynchronous.AbstractAsynchronousDialog;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.importer.AbstractCsvImporter;
import de.datomino.peppergis.client.message.EnumMessageResolverNameGenerator;
import de.datomino.peppergis.dto.asynchronous.AsynchronousDto;
import de.datomino.peppergis.dto.importer.GenericCsvDto;
import de.datomino.peppergis.dto.importer.GeoTrackCsvImportDto;
import de.datomino.peppergis.dto.importer.GeoTrackImportResultDto;
import de.datomino.peppergis.exception.ClientImportException;
import de.datomino.util.assistant.editor.Worker;
import de.datomino.util.assistant.model.ChoiceField;
import de.datomino.util.assistant.model.CsvColumnChoiceField;
import de.datomino.util.assistant.model.Fieldset;
import de.datomino.util.message.error.ErrorMessages;
import java.awt.Window;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.ktde.math.projection.CoordinateFactory;
import org.ktde.util.datatypes.Tupel;

public class GeoTrackCsvImporter
extends AbstractCsvImporter<GeoTrackCsvImportDto> {
    private ModelEnviroment modelEnviroment;
    private ChoiceField<CoordinateFactory.Projections> coordinateFactoryField;

    public GeoTrackCsvImporter(Window parent) {
        this.modelEnviroment = new ModelEnviroment(parent);
        Collection<CoordinateFactory.Projections> projections = CoordinateFactory.getListableProjections();
        CoordinateFactory.Projections[] values = new CoordinateFactory.Projections[projections.size()];
        values = projections.toArray(values);
        this.coordinateFactoryField = new ChoiceField<CoordinateFactory.Projections>(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.coordinateFactory", new Serializable[0]), values, new EnumMessageResolverNameGenerator(""), CoordinateFactory.Projections.Wgs84);
    }

    @Override
    public Worker getWorker(final Window parent) {
        return new Worker(){
            private Worker.State state;
            private Tupel<GeoTrackImportResultDto, Boolean> geoTrackImportResultDto;

            @Override
            public void process() {
                final GeoTrackCsvImportDto geoTrackCsvImportDto = new GeoTrackCsvImportDto();
                GeoTrackCsvImporter.this.writeToDto(geoTrackCsvImportDto);
                String message = ModelEnviroment.getMessageResolver().resolveMessage("messages.import.geoTrack.importing", new Serializable[0]);
                AbstractAsynchronousDialog<GeoTrackImportResultDto> asynchronousDialog = new AbstractAsynchronousDialog<GeoTrackImportResultDto>(parent, message, message, 1, GeoTrackCsvImporter.this.modelEnviroment){
                    private static final long serialVersionUID = 583077827525099193L;

                    @Override
                    protected AsynchronousDto<GeoTrackImportResultDto> getAsynchronousDto(String token) {
                        return this.getModelEnviroment().getAllCaller().getAsynchronousCaller().getImportGeoTrackingsResultCsv(token);
                    }

                    @Override
                    protected String startAsynchronous() {
                        return this.getModelEnviroment().getAllCaller().getAsynchronousCaller().importGeoTrackingsCsv(geoTrackCsvImportDto);
                    }
                };
                try {
                    this.geoTrackImportResultDto = asynchronousDialog.run();
                }
                catch (ClientImportException e) {
                    this.geoTrackImportResultDto = new Tupel<GeoTrackImportResultDto, Boolean>(new GeoTrackImportResultDto(), false);
                    this.geoTrackImportResultDto.getElement1().setErrorMessages(e.getErrorMessages());
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                ErrorMessages errorMessages = this.geoTrackImportResultDto.getElement1().getErrorMessages();
                this.state = errorMessages != null && errorMessages.hasErrors() ? Worker.State.ERROR : Worker.State.OK;
            }

            @Override
            public String getResultString() {
                ErrorMessages errorMessages = this.geoTrackImportResultDto.getElement1().getErrorMessages();
                if (errorMessages != null && errorMessages.hasErrors()) {
                    StringBuilder sb = new StringBuilder(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.error", new Serializable[0])).append(": ");
                    sb.append(ModelEnviroment.getMessageResolver().resolveMessages(errorMessages, "\n"));
                    return sb.toString();
                }
                return "Importierte Geotracks: " + this.geoTrackImportResultDto.getElement1().getCount();
            }

            @Override
            public Worker.State getResultState() {
                return this.state;
            }
        };
    }

    @Override
    protected void addCsvFields(List<CsvColumnChoiceField> choiceFields) {
        choiceFields.add(new CsvColumnChoiceField(this.getMessageForEnum(GeoTrackCsvImportDto.GeoTrackColumns.TOUR_NAME), (Serializable)((Object)GeoTrackCsvImportDto.GeoTrackColumns.TOUR_NAME), "^(?:tournummer)$", true));
        choiceFields.add(new CsvColumnChoiceField(this.getMessageForEnum(GeoTrackCsvImportDto.GeoTrackColumns.ACCOUNT_NAME), (Serializable)((Object)GeoTrackCsvImportDto.GeoTrackColumns.ACCOUNT_NAME), "^(?:account)$", false));
        choiceFields.add(new CsvColumnChoiceField(this.getMessageForEnum(GeoTrackCsvImportDto.GeoTrackColumns.TIME), (Serializable)((Object)GeoTrackCsvImportDto.GeoTrackColumns.TIME), "^(?:time)$", false));
        choiceFields.add(new CsvColumnChoiceField(this.getMessageForEnum(GeoTrackCsvImportDto.GeoTrackColumns.GEOTRACK_TYPE), (Serializable)((Object)GeoTrackCsvImportDto.GeoTrackColumns.GEOTRACK_TYPE), "^(?:type)$", true));
        choiceFields.add(new CsvColumnChoiceField(this.getMessageForEnum(GenericCsvDto.AddressColumns.X), (Serializable)((Object)GenericCsvDto.AddressColumns.X), "^(?:x)$", true));
        choiceFields.add(new CsvColumnChoiceField(this.getMessageForEnum(GenericCsvDto.AddressColumns.Y), (Serializable)((Object)GenericCsvDto.AddressColumns.Y), "^(?:y)$", true));
    }

    protected String getMessageForEnum(Enum<?> value) {
        return ModelEnviroment.getMessageResolver().resolveMessage(value.getClass().getName().replace('$', '.') + "." + value.name(), new Serializable[0]);
    }

    @Override
    public String getTitle() {
        return ModelEnviroment.getMessageResolver().resolveMessage("messages.import.geoTrackImport.csv", new Serializable[0]);
    }

    @Override
    protected List<Fieldset> getAdditionalFieldsets() {
        Fieldset geo = new Fieldset(ModelEnviroment.getMessageResolver().resolveMessage("messages.importer.parcel.geo", new Serializable[0]));
        geo.addField(this.coordinateFactoryField);
        return Collections.singletonList(geo);
    }

    @Override
    public void writeToDto(GeoTrackCsvImportDto dto) {
        super.writeToDto(dto);
        dto.setCoordinateFactoryName(((CoordinateFactory.Projections)((Object)this.coordinateFactoryField.getValue())).name());
    }
}

