/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.importer.deliverer;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.importer.AbstractCsvImporter;
import de.datomino.peppergis.dto.importer.DelivererCsvImportDto;
import de.datomino.peppergis.dto.importer.DelivererImportReportDto;
import de.datomino.peppergis.dto.importer.GenericCsvDto;
import de.datomino.peppergis.exception.DelivererImportException;
import de.datomino.util.assistant.editor.Worker;
import de.datomino.util.assistant.model.CsvColumnChoiceField;
import de.datomino.util.assistant.model.Page;
import de.datomino.util.message.Message;
import de.datomino.util.message.error.ErrorMessages;
import de.datomino.util.swing.SpringUtilities;
import java.awt.Window;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.SpringLayout;

public class DelivererImporter
extends AbstractCsvImporter<GenericCsvDto> {
    private CsvColumnChoiceField delivererNumberField;
    private CsvColumnChoiceField nameField;
    private CsvColumnChoiceField factorField;
    private CsvColumnChoiceField branchField;
    private CsvColumnChoiceField accountField;
    private CsvColumnChoiceField passwordField;
    private CsvColumnChoiceField hourRewardField;
    private CsvColumnChoiceField kmRewardField;
    private JCheckBox createBranch;
    private Window parent;

    public DelivererImporter(Window parent) {
        this.parent = parent;
        this.delivererNumberField = new CsvColumnChoiceField(ModelEnviroment.getMessageResolver().resolveMessage("messages.importer.delivererNumber", new Serializable[0]), (Serializable)((Object)DelivererCsvImportDto.Field.NUMBER), this.createRegex("nummer", "Fahrernummer", "Fahrer-Nr."), true);
        this.nameField = new CsvColumnChoiceField(ModelEnviroment.getMessageResolver().resolveMessage("messages.importer.delivererName", new Serializable[0]), (Serializable)((Object)DelivererCsvImportDto.Field.NAME), this.createRegex("name", "Fahrername", "Fahrer"), true);
        this.factorField = new CsvColumnChoiceField(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.humanFactor", new Serializable[0]), (Serializable)((Object)DelivererCsvImportDto.Field.FACTOR), this.createRegex("factor", "Schwierigkeitsgrad"), true);
        this.branchField = new CsvColumnChoiceField(ModelEnviroment.getMessageResolver().resolveMessage("messages.importer.branch", new Serializable[0]), (Serializable)((Object)DelivererCsvImportDto.Field.BRANCH), this.createRegex("branch", "Gruppe"), true);
        this.accountField = new CsvColumnChoiceField(ModelEnviroment.getMessageResolver().resolveMessage("messages.importer.delivererAccount", new Serializable[0]), (Serializable)((Object)DelivererCsvImportDto.Field.ACCOUNT), this.createRegex("account", "login"), true);
        this.passwordField = new CsvColumnChoiceField(ModelEnviroment.getMessageResolver().resolveMessage("messages.importer.delivererPassword", new Serializable[0]), (Serializable)((Object)DelivererCsvImportDto.Field.PASSWORD), this.createRegex("passwort", "pw", "kennwort"), true);
        this.hourRewardField = new CsvColumnChoiceField(ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.cost.hour", new Serializable[0]), (Serializable)((Object)DelivererCsvImportDto.Field.HOUR_REWARD), this.createRegex("stundenkosten", "zeitkosten", "std-kosten"), true);
        this.kmRewardField = new CsvColumnChoiceField(ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.cost.km", new Serializable[0]), (Serializable)((Object)DelivererCsvImportDto.Field.KILOMETER_REWARD), this.createRegex("kilometerkosten", "streckenkosten", "km-kosten"), true);
    }

    @Override
    protected void addCsvFields(List<CsvColumnChoiceField> choiceFields) {
        choiceFields.add(this.delivererNumberField);
        choiceFields.add(this.nameField);
        choiceFields.add(this.factorField);
        choiceFields.add(this.hourRewardField);
        choiceFields.add(this.kmRewardField);
        choiceFields.add(this.branchField);
        choiceFields.add(this.accountField);
        choiceFields.add(this.passwordField);
    }

    @Override
    public Worker getWorker(Window parent) {
        return new Worker(){
            private String resultString;
            private Worker.State resultState;

            @Override
            public void process() {
                ModelEnviroment modelEnviroment = new ModelEnviroment(DelivererImporter.this.parent);
                DelivererCsvImportDto dto = new DelivererCsvImportDto();
                DelivererImporter.this.writeToDto(dto);
                dto.setCreateBranch(DelivererImporter.this.createBranch.isSelected());
                StringBuilder sb = new StringBuilder();
                try {
                    DelivererImportReportDto resultDto = modelEnviroment.getAllCaller().getImportCaller().importDeliverer(dto);
                    if (resultDto.isError()) {
                        ErrorMessages errorMessages = resultDto.getErrorMessages();
                        for (Message message : errorMessages) {
                            sb.append(ModelEnviroment.getMessageResolver().resolveMessage(message)).append("\n");
                        }
                        this.resultState = Worker.State.ERROR;
                    } else {
                        sb.append(ModelEnviroment.getMessageResolver().resolveMessage("importer.deliverer.resultMessage", Integer.valueOf(resultDto.getNewDelivererNumbers().size()), Integer.valueOf(resultDto.getUpdatedDelivererNumbers().size())));
                        this.resultState = Worker.State.OK;
                    }
                }
                catch (DelivererImportException e) {
                    ErrorMessages errorMessages = e.getErrorMessages();
                    for (Message message : errorMessages) {
                        sb.append(ModelEnviroment.getMessageResolver().resolveMessage(message)).append("\n");
                    }
                    this.resultState = Worker.State.ERROR;
                }
                this.resultString = sb.toString();
            }

            @Override
            public String getResultString() {
                return this.resultString;
            }

            @Override
            public Worker.State getResultState() {
                return this.resultState;
            }
        };
    }

    @Override
    public String getTitle() {
        return ModelEnviroment.getMessageResolver().resolveMessage("messages.importer.deliverer", new Serializable[0]);
    }

    @Override
    protected List<Page> getAdditionalPages() {
        List<Page> pages = super.getAdditionalPages();
        if (pages == null) {
            pages = new ArrayList<Page>(1);
        }
        Page optionPage = new Page(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.other", new Serializable[0]));
        JPanel optionPane = new JPanel(new SpringLayout());
        this.createBranch = new JCheckBox(ModelEnviroment.getMessageResolver().resolveMessage("gui.branch.create", new Serializable[0]));
        optionPane.add(this.createBranch);
        SpringUtilities.makeCompactGrid(optionPane, 1, 1, 5, 5, 5, 5);
        optionPage.setAdditionalComponent(optionPane);
        pages.add(optionPage);
        return pages;
    }
}

