/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.importer.deliverer;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.importer.AbstractCsvImporter;
import de.datomino.peppergis.client.model.area.AreaLayerModel;
import de.datomino.peppergis.dto.importer.DelivererCsvImportDto;
import de.datomino.peppergis.dto.importer.DelivererImportReportDto;
import de.datomino.peppergis.dto.importer.GenericCsvDto;
import de.datomino.peppergis.exception.DelivererImportException;
import de.datomino.peppergis.type.AreaObjectGenInfoDiscriminator;
import de.datomino.util.assistant.editor.Worker;
import de.datomino.util.assistant.model.CsvColumnChoiceField;
import de.datomino.util.assistant.model.Page;
import de.datomino.util.message.Message;
import de.datomino.util.message.error.ErrorMessages;
import de.datomino.util.message.error.ExceptionErrorMessage;
import de.datomino.util.swing.SpringUtilities;
import java.awt.Window;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SpringLayout;

public class AreaDelivererImporter
extends AbstractCsvImporter<GenericCsvDto> {
    private CsvColumnChoiceField delivererNumberField;
    private CsvColumnChoiceField nameField;
    private CsvColumnChoiceField factorField;
    private CsvColumnChoiceField branchField;
    private CsvColumnChoiceField passwordField;
    private CsvColumnChoiceField hourRewardField;
    private CsvColumnChoiceField kmRewardMotorField;
    private CsvColumnChoiceField kmRewardFootField;
    private CsvColumnChoiceField kmRewardBikeField;
    private CsvColumnChoiceField maxSalaryField;
    private CsvColumnChoiceField surchargeField;
    private CsvColumnChoiceField nightSurchargeField;
    private CsvColumnChoiceField rewardStartTimeField;
    private Window parent;
    private JCheckBox createBranch;
    private JList<String> areaLayerList;

    public AreaDelivererImporter(Window parent) {
        this.parent = parent;
        this.delivererNumberField = new CsvColumnChoiceField(ModelEnviroment.getMessageResolver().resolveMessage("messages.areaDelivererNumber", new Serializable[0]), (Serializable)((Object)DelivererCsvImportDto.Field.NUMBER), this.createRegex("nummer"), true);
        this.nameField = new CsvColumnChoiceField(ModelEnviroment.getMessageResolver().resolveMessage("messages.areaDeliverer.name", new Serializable[0]), (Serializable)((Object)DelivererCsvImportDto.Field.NAME), this.createRegex("name"), false);
        this.factorField = new CsvColumnChoiceField(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.humanFactor", new Serializable[0]), (Serializable)((Object)DelivererCsvImportDto.Field.FACTOR), this.createRegex("factor", "Schwierigkeitsgrad"), true);
        this.branchField = new CsvColumnChoiceField(ModelEnviroment.getMessageResolver().resolveMessage("messages.importer.branch", new Serializable[0]), (Serializable)((Object)DelivererCsvImportDto.Field.BRANCH), this.createRegex("branch", "gruppe"), true);
        this.passwordField = new CsvColumnChoiceField(ModelEnviroment.getMessageResolver().resolveMessage("messages.importer.delivererPassword", new Serializable[0]), (Serializable)((Object)DelivererCsvImportDto.Field.PASSWORD), this.createRegex("passwort", "Account-Passwort"), true);
        this.hourRewardField = new CsvColumnChoiceField(ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.cost.hour", new Serializable[0]), (Serializable)((Object)DelivererCsvImportDto.Field.HOUR_REWARD), this.createRegex("stundenkosten", "Std-Kosten"), false);
        this.kmRewardMotorField = new CsvColumnChoiceField(ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.cost.km.motor", new Serializable[0]), (Serializable)((Object)DelivererCsvImportDto.Field.KILOMETER_REWARD_MOTOR), this.createRegex("kilometerkosten", "Km-Kosten Auto"), true);
        this.kmRewardFootField = new CsvColumnChoiceField(ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.cost.km.foot", new Serializable[0]), (Serializable)((Object)DelivererCsvImportDto.Field.KILOMETER_REWARD_FOOT), this.createRegex("kilometerkosten", "Km-Kosten Fu\u00df"), true);
        this.kmRewardBikeField = new CsvColumnChoiceField(ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.cost.km.bike", new Serializable[0]), (Serializable)((Object)DelivererCsvImportDto.Field.KILOMETER_REWARD_BIKE), this.createRegex("kilometerkosten", "Km-Kosten Rad"), true);
        this.maxSalaryField = new CsvColumnChoiceField(ModelEnviroment.getMessageResolver().resolveMessage("messages.reward.maxSalary", new Serializable[0]), (Serializable)((Object)DelivererCsvImportDto.Field.MAX_SALARY), this.createRegex("monatslohn", "Monatslohn max."), true);
        this.surchargeField = new CsvColumnChoiceField(ModelEnviroment.getMessageResolver().resolveMessage("messages.reward.surcharge", new Serializable[0]), (Serializable)((Object)DelivererCsvImportDto.Field.SURCHARGE), this.createRegex("pauschaler zuschlag"), true);
        this.nightSurchargeField = new CsvColumnChoiceField(ModelEnviroment.getMessageResolver().resolveMessage("messages.reward.nightsurcharge", new Serializable[0]), (Serializable)((Object)DelivererCsvImportDto.Field.NIGHT_SURCHARGE), this.createRegex("nachtzuschlag"), true);
        this.rewardStartTimeField = new CsvColumnChoiceField(ModelEnviroment.getMessageResolver().resolveMessage("messages.reward.starttime", new Serializable[0]), (Serializable)((Object)DelivererCsvImportDto.Field.REWARD_START_TIME), this.createRegex("g\u00fcltigkeit von", "Lohn ab"), true);
        Collection<AreaLayerModel> areaLayers = new ModelEnviroment(parent).getAllCaller().getAreaCaller().getAreaLayersForType(AreaObjectGenInfoDiscriminator.values());
        ArrayList<String> layerNames = new ArrayList<String>(areaLayers.size());
        for (AreaLayerModel layerModel : areaLayers) {
            layerNames.add(layerModel.getDisplayname());
        }
        this.areaLayerList = new JList<String>(layerNames.toArray(new String[layerNames.size()]));
    }

    @Override
    protected void addCsvFields(List<CsvColumnChoiceField> choiceFields) {
        choiceFields.add(this.delivererNumberField);
        choiceFields.add(this.nameField);
        choiceFields.add(this.factorField);
        choiceFields.add(this.hourRewardField);
        choiceFields.add(this.kmRewardMotorField);
        choiceFields.add(this.kmRewardFootField);
        choiceFields.add(this.kmRewardBikeField);
        choiceFields.add(this.maxSalaryField);
        choiceFields.add(this.surchargeField);
        choiceFields.add(this.nightSurchargeField);
        choiceFields.add(this.rewardStartTimeField);
        choiceFields.add(this.branchField);
        choiceFields.add(this.passwordField);
    }

    @Override
    public Worker getWorker(Window parent) {
        return new Worker(){
            private String resultString;
            private Worker.State resultState;

            @Override
            public void process() {
                ModelEnviroment modelEnviroment = new ModelEnviroment(AreaDelivererImporter.this.parent);
                DelivererCsvImportDto dto = new DelivererCsvImportDto();
                AreaDelivererImporter.this.writeToDto(dto);
                dto.setCreateBranch(AreaDelivererImporter.this.createBranch.isSelected());
                dto.setLayers(AreaDelivererImporter.this.areaLayerList.getSelectedValuesList());
                StringBuilder sb = new StringBuilder();
                try {
                    DelivererImportReportDto resultDto = modelEnviroment.getAllCaller().getImportCaller().importAreaDeliverer(dto);
                    if (resultDto.isError()) {
                        ErrorMessages errorMessages = resultDto.getErrorMessages();
                        for (Message message : errorMessages) {
                            sb.append(ModelEnviroment.getMessageResolver().resolveMessage(message)).append("\n");
                        }
                        this.resultState = Worker.State.ERROR;
                    } else {
                        sb.append(ModelEnviroment.getMessageResolver().resolveMessage("messages.importer.areaDeliverer.result", Integer.valueOf(resultDto.getNewDelivererNumbers().size()), Integer.valueOf(resultDto.getUpdatedDelivererNumbers().size())));
                        this.resultState = Worker.State.OK;
                    }
                }
                catch (DelivererImportException e) {
                    ErrorMessages errorMessages = e.getErrorMessages();
                    DelivererImportReportDto dDto = e.getDelivererImportReportDto();
                    errorMessages.addAllErrorMessages(dDto.getErrorMessages());
                    for (Message message : errorMessages) {
                        sb.append(ModelEnviroment.getMessageResolver().resolveMessage(message)).append("\n");
                    }
                    sb.append("\n\n").append(ModelEnviroment.getMessageResolver().resolveMessage("messages.importer.areaDeliverer.result", Integer.valueOf(dDto.getNewDelivererNumbers().size()), Integer.valueOf(dDto.getUpdatedDelivererNumbers().size())));
                    this.resultState = Worker.State.ERROR;
                }
                catch (Exception e) {
                    ExceptionErrorMessage exceptionErrorMessage = new ExceptionErrorMessage(e);
                    sb.append(ModelEnviroment.getMessageResolver().resolveMessage(exceptionErrorMessage)).append("\n");
                    this.resultState = Worker.State.ERROR;
                }
                this.resultString = sb.toString();
            }

            @Override
            public String getResultString() {
                return this.resultString;
            }

            @Override
            public Worker.State getResultState() {
                return this.resultState;
            }
        };
    }

    @Override
    public String getTitle() {
        return ModelEnviroment.getMessageResolver().resolveMessage("messages.importer.areaDeliverer", new Serializable[0]);
    }

    @Override
    protected List<Page> getAdditionalPages() {
        List<Page> pages = super.getAdditionalPages();
        if (pages == null) {
            pages = new ArrayList<Page>(2);
        }
        Page layerPage = new Page(ModelEnviroment.getMessageResolver().resolveMessage("messages.import.area.layer", new Serializable[0]));
        JScrollPane layerScrollPane = new JScrollPane(this.areaLayerList);
        layerPage.setAdditionalComponent(layerScrollPane);
        pages.add(layerPage);
        Page optionPage = new Page(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.other", new Serializable[0]));
        JPanel optionPane = new JPanel(new SpringLayout());
        this.createBranch = new JCheckBox(ModelEnviroment.getMessageResolver().resolveMessage("gui.branch.create", new Serializable[0]));
        optionPane.add(this.createBranch);
        SpringUtilities.makeCompactGrid(optionPane, 1, 1, 5, 5, 5, 5);
        optionPage.setAdditionalComponent(optionPane);
        pages.add(optionPage);
        return pages;
    }
}

