/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.importer.attribute;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.area.AreaAttributeValueDescriptorModel;
import de.datomino.peppergis.client.util.wrapper.area.attribute.AreaAttributeValueDescriptorModelAttributeWrapper;
import de.datomino.peppergis.client.util.wrapper.common.attribute.AttributeValueDescriptorModel;
import de.datomino.peppergis.dto.asynchronous.AsynchronousDto;
import de.datomino.peppergis.dto.attribute.AttributeWithLayerCsvDto;
import de.datomino.peppergis.dto.importer.AttributeValueImportResultDto;
import de.datomino.peppergis.importer.attribute.AbstractAttributeValueWithLayerImporter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.ktde.util.NameGenerator;
import org.ktde.util.StringUtil;
import org.ktde.util.datatypes.Tripel;
import org.ktde.util.datatypes.Tupel;

public class AreaAttributeValueImporter
extends AbstractAttributeValueWithLayerImporter<Tupel<String, String>> {
    @Override
    protected List<AttributeValueDescriptorModel<?, ?>> getDescriptors() {
        Collection<AreaAttributeValueDescriptorModel> descriptors = this.getModelEnviroment().getAllCaller().getAreaCaller().fetchAllAreaAttributeValueDescriptors();
        ArrayList list = new ArrayList(descriptors.size());
        for (AreaAttributeValueDescriptorModel descriptor : descriptors) {
            list.add(new AreaAttributeValueDescriptorModelAttributeWrapper(descriptor));
        }
        return list;
    }

    @Override
    protected List<Tripel<String, Serializable, String>> getIdentColumns() {
        return Collections.singletonList(new Tripel<String, String, String>(ModelEnviroment.getMessageResolver().resolveMessage("messages.area.shortcut", new Serializable[0]), "ID", this.createRegex("nummer", "Gebietsnummer", "Bezirksnummer", "Bezirks-ID", "Gebiets-ID")));
    }

    @Override
    protected String getDialogTitle() {
        return ModelEnviroment.getMessageResolver().resolveMessage("messages.import.importAreaAttributeValues", new Serializable[0]);
    }

    @Override
    protected String getInitialMessage() {
        return ModelEnviroment.getMessageResolver().resolveMessage("messages.import.importAreaAttributeValues", new Serializable[0]);
    }

    @Override
    protected String startAsynchronous(AttributeWithLayerCsvDto attributeCsvDto) {
        return this.getModelEnviroment().getAllCaller().getAsynchronousCaller().importAreaAttributeValues(attributeCsvDto);
    }

    @Override
    protected AsynchronousDto<AttributeValueImportResultDto<Tupel<String, String>>> getAsynchronousDto(String token) {
        return this.getModelEnviroment().getAllCaller().getAsynchronousCaller().getImportAreaAttributeValuesResult(token);
    }

    @Override
    public String getTitle() {
        return ModelEnviroment.getMessageResolver().resolveMessage("messages.import.importAreaAttributeValues", new Serializable[0]);
    }

    @Override
    protected String getObjectNamePlural() {
        return ModelEnviroment.getMessageResolver().resolveMessage("messages.area.areas", new Serializable[0]);
    }

    @Override
    protected Serializable transformResultObjectToString(Collection<Tupel<String, String>> notFoundObjects) {
        return StringUtil.implode(notFoundObjects, ", ", new NameGenerator<Tupel<String, String>>(){

            @Override
            public String getName(Tupel<String, String> t) {
                return t.getElement1() + " - " + t.getElement2();
            }
        });
    }

    @Override
    protected String getIdentifierMessageKey() {
        return "gui.area.areaObject";
    }
}

