/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.importer.attribute;

import de.datomino.peppergis.client.gui.asynchronous.AbstractAsynchronousDialog;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.importer.AbstractCsvImporter;
import de.datomino.peppergis.client.model.base.AttributeGroupModel;
import de.datomino.peppergis.client.util.wrapper.common.attribute.AttributeValueDescriptorModel;
import de.datomino.peppergis.dto.asynchronous.AsynchronousDto;
import de.datomino.peppergis.dto.attribute.AttributeCsvDto;
import de.datomino.peppergis.dto.importer.AttributeValueImportResultDto;
import de.datomino.peppergis.exception.ClientImportException;
import de.datomino.peppergis.importer.attribute.AttributeCsvColumnChoiceField;
import de.datomino.util.assistant.editor.Worker;
import de.datomino.util.assistant.model.CsvColumnChoiceField;
import de.datomino.util.assistant.model.Fieldset;
import de.datomino.util.assistant.model.Page;
import de.datomino.util.callback.CallBack;
import de.datomino.util.message.MessageResolver;
import de.datomino.util.message.error.ErrorMessages;
import java.awt.Window;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.ktde.util.datatypes.Tripel;
import org.ktde.util.datatypes.Tupel;

public abstract class AbstractAttributeValueImporter<T extends Serializable, S extends AttributeCsvDto>
extends AbstractCsvImporter<S> {
    private ModelEnviroment modelEnviroment = new ModelEnviroment(null);

    @Override
    public Worker getWorker(final Window parent) {
        return new Worker(){
            private Worker.State state;
            private String resultString;

            @Override
            public void process() {
                ModelEnviroment modelEnviroment = new ModelEnviroment(null);
                StringBuilder builder = new StringBuilder();
                try {
                    Tupel attributeValueImportResultDto;
                    AbstractAsynchronousDialog asynchronousDialog = new AbstractAsynchronousDialog<AttributeValueImportResultDto<T>>(parent, AbstractAttributeValueImporter.this.getDialogTitle(), AbstractAttributeValueImporter.this.getInitialMessage(), 1, true, modelEnviroment){
                        private static final long serialVersionUID = -1127458576478099632L;

                        @Override
                        protected AsynchronousDto<AttributeValueImportResultDto<T>> getAsynchronousDto(String token) {
                            return AbstractAttributeValueImporter.this.getAsynchronousDto(token);
                        }

                        @Override
                        protected String startAsynchronous() {
                            Object attributeCsvDto = AbstractAttributeValueImporter.this.createDto();
                            AbstractAttributeValueImporter.this.writeToDto(attributeCsvDto);
                            return AbstractAttributeValueImporter.this.startAsynchronous(attributeCsvDto);
                        }
                    };
                    try {
                        attributeValueImportResultDto = asynchronousDialog.run();
                    }
                    catch (Exception e) {
                        if (e instanceof ClientImportException) {
                            throw (ClientImportException)e;
                        }
                        if (e instanceof RuntimeException) {
                            throw (RuntimeException)e;
                        }
                        throw new RuntimeException(e);
                    }
                    ErrorMessages errorMessages = ((AttributeValueImportResultDto)attributeValueImportResultDto.getElement1()).getErrorMessages();
                    if (errorMessages.hasErrors()) {
                        builder.append("Fehler:\n");
                        builder.append(ModelEnviroment.getMessageResolver().resolveMessages(errorMessages, "\n"));
                    } else {
                        builder.append(ModelEnviroment.getMessageResolver().resolveMessage("messages.import.importCommonResult", new Serializable[]{Integer.valueOf(((AttributeValueImportResultDto)attributeValueImportResultDto.getElement1()).getFoundObjects().size()), AbstractAttributeValueImporter.this.getObjectNamePlural(), AbstractAttributeValueImporter.this.transformResultObjectToString(((AttributeValueImportResultDto)attributeValueImportResultDto.getElement1()).getNotFoundObjects())}));
                    }
                }
                catch (ClientImportException e) {
                    ErrorMessages errorMessages = e.getErrorMessages();
                    if (errorMessages != null && errorMessages.hasErrors()) {
                        builder.append(ModelEnviroment.getMessageResolver().resolveMessages(errorMessages, "\n"));
                    }
                    builder.append(e.getMessage());
                }
                this.resultString = builder.toString();
            }

            @Override
            public String getResultString() {
                return this.resultString;
            }

            @Override
            public Worker.State getResultState() {
                return this.state;
            }
        };
    }

    @Override
    protected void addCsvFields(List<CsvColumnChoiceField> choiceFields) {
        List<Tripel<String, Serializable, String>> idents = this.getIdentColumns();
        for (Tripel<String, Serializable, String> ident : idents) {
            choiceFields.add(new CsvColumnChoiceField(ident.getElement1(), ident.getElement2(), ident.getElement3(), false));
        }
        List<CsvColumnChoiceField> descriptorFields = this.getDescriptorColumnChoiceFields();
        choiceFields.addAll(descriptorFields);
    }

    private List<? extends CsvColumnChoiceField> getDescriptorColumnChoiceFields() {
        List<AttributeValueDescriptorModel<?, ?>> descriptors = this.getDescriptors();
        ArrayList<AttributeCsvColumnChoiceField> fields = new ArrayList<AttributeCsvColumnChoiceField>(descriptors.size());
        for (AttributeValueDescriptorModel<?, ?> descriptor : descriptors) {
            String key = descriptor.getKey();
            fields.add(new AttributeCsvColumnChoiceField(descriptor.getName(), new AttributeCsvDto.AttributeKey(key), this.createRegex(descriptor.getName(), descriptor.getKey()), true, descriptor.getAttributeGroup()));
        }
        return fields;
    }

    protected ModelEnviroment getModelEnviroment() {
        return this.modelEnviroment;
    }

    @Override
    protected List<CsvColumnChoiceField> getColumnMapFields() {
        List<CsvColumnChoiceField> fields = super.getColumnMapFields();
        List<Tripel<String, Serializable, String>> identColumns = this.getIdentColumns();
        int start = identColumns.size();
        List<CsvColumnChoiceField> descriptorFields = this.getDescriptorColumnChoiceFields();
        Iterator<CsvColumnChoiceField> iter = fields.iterator();
        ArrayList<CsvColumnChoiceField> identFields = new ArrayList<CsvColumnChoiceField>(start);
        for (int i = 0; i < start; ++i) {
            identFields.add(iter.next());
        }
        HashMap<Serializable, CsvColumnChoiceField> map = new HashMap<Serializable, CsvColumnChoiceField>();
        while (iter.hasNext()) {
            CsvColumnChoiceField next = iter.next();
            map.put(next.getCanonicalName(), next);
        }
        fields.clear();
        fields.addAll(identFields);
        for (CsvColumnChoiceField descriptorEntry : descriptorFields) {
            CsvColumnChoiceField alreadyExistingField = (CsvColumnChoiceField)map.get(descriptorEntry.getCanonicalName());
            if (alreadyExistingField == null) {
                fields.add(descriptorEntry);
                continue;
            }
            fields.add(alreadyExistingField);
        }
        return fields;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected List<Page> createPage(Iterator<CsvColumnChoiceField> columnMapFieldsLocal, Iterator<Fieldset> addfieldsets, List<CallBack<Boolean, Window>> leaveActions) {
        MessageResolver messageResolver = ModelEnviroment.getMessageResolver();
        ArrayList<Page> pages = new ArrayList<Page>();
        HashMap fieldMap = new HashMap();
        LinkedList<AttributeCsvColumnChoiceField> nullGroupList = new LinkedList<AttributeCsvColumnChoiceField>();
        LinkedList<CsvColumnChoiceField> regularGroupList = new LinkedList<CsvColumnChoiceField>();
        while (columnMapFieldsLocal.hasNext()) {
            CsvColumnChoiceField next = columnMapFieldsLocal.next();
            if (next instanceof AttributeCsvColumnChoiceField) {
                void var12_12;
                AttributeCsvColumnChoiceField attributeCsvColumnChoiceField = (AttributeCsvColumnChoiceField)next;
                AttributeGroupModel attributeGroupModel = attributeCsvColumnChoiceField.getAttributeGroupModel();
                if (attributeGroupModel == null) {
                    nullGroupList.add(attributeCsvColumnChoiceField);
                    continue;
                }
                List list = (List)fieldMap.get(attributeGroupModel);
                if (list == null) {
                    LinkedList linkedList = new LinkedList();
                    fieldMap.put(attributeGroupModel, linkedList);
                }
                var12_12.add(attributeCsvColumnChoiceField);
                continue;
            }
            regularGroupList.add(next);
        }
        Page regularPage = this.createRegularPage(addfieldsets, regularGroupList);
        pages.add(regularPage);
        Page nullGroupPage = new Page(messageResolver.resolveMessage("message.page.nullAttribute", new Serializable[0]));
        for (CsvColumnChoiceField csvColumnChoiceField : nullGroupList) {
            nullGroupPage.addField(csvColumnChoiceField);
        }
        pages.add(nullGroupPage);
        ArrayList keySet = new ArrayList(fieldMap.keySet());
        Collections.sort(keySet, new Comparator<AttributeGroupModel>(){

            @Override
            public int compare(AttributeGroupModel o1, AttributeGroupModel o2) {
                String n1 = o1.getName();
                String n2 = o2.getName();
                return n1.compareTo(n2);
            }
        });
        for (AttributeGroupModel attributeGroupModel : keySet) {
            List list = (List)fieldMap.get(attributeGroupModel);
            Page page = new Page(attributeGroupModel.getName());
            for (CsvColumnChoiceField csvColumnChoiceField : list) {
                page.addField(csvColumnChoiceField);
            }
            pages.add(page);
        }
        if (pages.isEmpty()) {
            Page page = new Page(messageResolver.resolveMessage("messages.page.content.title", new Serializable[0]));
        } else {
            Page page = (Page)pages.get(pages.size() - 1);
        }
        for (CallBack<Boolean, Window> action : leaveActions) {
            void var12_20;
            var12_20.addLeaveAction(action);
        }
        return pages;
    }

    protected Page createRegularPage(Iterator<Fieldset> addfieldsets, List<CsvColumnChoiceField> regularGroupList) {
        MessageResolver messageResolver = ModelEnviroment.getMessageResolver();
        Page regularPage = new Page(messageResolver.resolveMessage(this.getIdentifierMessageKey(), new Serializable[0]));
        for (CsvColumnChoiceField csvColumnChoiceField : regularGroupList) {
            regularPage.addField(csvColumnChoiceField);
        }
        if (addfieldsets != null && addfieldsets.hasNext()) {
            while (addfieldsets.hasNext()) {
                regularPage.addFieldset(addfieldsets.next());
            }
        }
        return regularPage;
    }

    protected abstract String getIdentifierMessageKey();

    protected abstract List<AttributeValueDescriptorModel<?, ?>> getDescriptors();

    protected abstract List<Tripel<String, Serializable, String>> getIdentColumns();

    protected abstract String getDialogTitle();

    protected abstract String getInitialMessage();

    protected abstract String startAsynchronous(S var1);

    protected abstract AsynchronousDto<AttributeValueImportResultDto<T>> getAsynchronousDto(String var1);

    protected abstract String getObjectNamePlural();

    protected abstract Serializable transformResultObjectToString(Collection<T> var1);

    protected abstract S createDto();
}

