/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.importer.area.worker.data;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.dto.importer.GenericCsvDto;
import de.datomino.peppergis.dto.importer.area.AreaCsvObjectImportDto;
import de.datomino.peppergis.helper.CsvHelper;
import de.datomino.peppergis.importer.area.AbstractAreaAddressRangeCsvImporter;
import de.datomino.peppergis.importer.area.data.CoordinateAreaImportData;
import de.datomino.peppergis.importer.area.worker.data.PolygonImportDataCreator;
import de.datomino.util.csv.CsvLineReader;
import de.datomino.util.geo.ImmutableGeoObjectFactory;
import de.datomino.util.geo.ImmutablePolygonKind;
import de.datomino.util.geo.util.GeoUtils;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.ktde.math.projection.Coordinate;
import org.ktde.math.projection.CoordinateFactory;
import org.ktde.util.StringUtil;
import org.ktde.util.datatypes.Tupel;

public class AreaFromConvexHullCsvImportDataCreator
implements PolygonImportDataCreator<CoordinateAreaImportData, AreaCsvObjectImportDto> {
    private static final AreaFromConvexHullCsvImportDataCreator INSTANCE = new AreaFromConvexHullCsvImportDataCreator();

    private AreaFromConvexHullCsvImportDataCreator() {
    }

    public static AreaFromConvexHullCsvImportDataCreator getInstance() {
        return INSTANCE;
    }

    @Override
    public Collection<CoordinateAreaImportData> getAreaImportData(AreaCsvObjectImportDto dto, ModelEnviroment modelEnviroment) throws Exception {
        Map<Object, String> line = null;
        LinkedHashMap<String, CoordinateAreaImportData> result = new LinkedHashMap<String, CoordinateAreaImportData>();
        CoordinateFactory coordinateFactory = CoordinateFactory.getInstance(dto.getCoordinateFactory());
        CsvLineReader reader = CsvHelper.createReader(dto);
        while ((line = reader.readLine()) != null) {
            Tupel<Coordinate, Map<GenericCsvDto.AddressColumns, String>> tupel;
            Coordinate elem1;
            String key = line.get((Object)AreaCsvObjectImportDto.Columns.AREA_SHORTCUT);
            String displayName = line.get((Object)AreaCsvObjectImportDto.Columns.DISPLAY_NAME);
            if (StringUtil.isBlank(key)) continue;
            CoordinateAreaImportData data = (CoordinateAreaImportData)result.get(key);
            if (data == null) {
                data = new CoordinateAreaImportData(key, displayName);
                result.put(key, data);
            }
            if ((elem1 = (tupel = AbstractAreaAddressRangeCsvImporter.getParcelFromLine(line, coordinateFactory)).getElement1()) == null) continue;
            data.append(ImmutableGeoObjectFactory.createImmutablePoint(elem1));
        }
        return result.values();
    }

    @Override
    public ImmutablePolygonKind getPolygon(CoordinateAreaImportData t) throws Exception {
        ImmutablePolygonKind polygon = t.getPolygon();
        if (polygon == null) {
            return GeoUtils.getConvexHull(t.getPoints());
        }
        return polygon;
    }
}

