/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.importer.area;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.area.AreaLayerModel;
import de.datomino.peppergis.dto.area.AreaLayerDto;
import de.datomino.peppergis.dto.importer.area.AreaCsvObjectImportDto;
import de.datomino.peppergis.dto.importer.area.AreaShapeImportDto;
import de.datomino.peppergis.importer.area.AreaImporter;
import de.datomino.peppergis.importer.area.data.MultiPolygonImportData;
import de.datomino.peppergis.importer.area.worker.AreaFromShapeImportWorker;
import de.datomino.peppergis.type.AreaObjectGenInfoDiscriminator;
import de.datomino.util.assistant.editor.Worker;
import de.datomino.util.assistant.model.ChoiceField;
import de.datomino.util.assistant.model.Fieldset;
import de.datomino.util.assistant.model.FileField;
import de.datomino.util.assistant.model.Page;
import de.datomino.util.assistant.model.StringField;
import de.datomino.util.assistant.model.Wizard;
import de.datomino.util.callback.CallBack;
import de.datomino.util.command.AttributeDescriptor;
import de.datomino.util.command.ShpDbfReader;
import de.datomino.util.message.MessageResolver;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.apache.commons.io.FileUtils;
import org.ktde.math.projection.CoordinateFactory;
import org.ktde.util.NameGenerator;
import org.xBaseJ.xBaseJException;

public class AreaFromShapeImporter
implements AreaImporter<MultiPolygonImportData, AreaShapeImportDto> {
    private FileField shapefileField;
    private ChoiceField<AreaLayerModel> layerField;
    private ChoiceField<CoordinateFactory.Projections> coordinateFactoryField;
    private ChoiceField<String> shortcutColumnField;
    private ChoiceField<String> displayNameColumnField;
    private StringField encodedTypeField;

    public AreaFromShapeImporter() {
        final MessageResolver messageResolver = ModelEnviroment.getMessageResolver();
        this.shapefileField = new FileField(messageResolver.resolveMessage("messages.parameter.file", new Serializable[0]), null, (List<? extends FileFilter>)Collections.singletonList(new FileNameExtensionFilter("SHP", "shp")));
        this.shortcutColumnField = new ChoiceField<String>(messageResolver.resolveMessageForEnum(AreaCsvObjectImportDto.Columns.AREA_SHORTCUT), new String[0]);
        this.displayNameColumnField = new ChoiceField<String>(messageResolver.resolveMessageForEnum(AreaCsvObjectImportDto.Columns.DISPLAY_NAME), new String[0]);
        ModelEnviroment modelEnviroment = new ModelEnviroment(null);
        Collection<AreaLayerModel> areaLayers = modelEnviroment.getAllCaller().getAreaCaller().getAreaLayersForType(new AreaObjectGenInfoDiscriminator[]{AreaObjectGenInfoDiscriminator.AREA_OBJECT_GEN_FREEHAND});
        modelEnviroment.close();
        this.layerField = new ChoiceField<1>(messageResolver.resolveMessage("messages.import.area.layer", new Serializable[0]), (Collection<1>)areaLayers, new NameGenerator<AreaLayerModel>(){

            @Override
            public String getName(AreaLayerModel t) {
                return t == null ? messageResolver.resolveMessage("messages.default.pleaseChoose", new Serializable[0]) : t.getDisplayname();
            }
        });
        Collection<CoordinateFactory.Projections> projections = CoordinateFactory.getListableProjections();
        CoordinateFactory.Projections[] values = new CoordinateFactory.Projections[projections.size()];
        values = projections.toArray(values);
        this.coordinateFactoryField = new ChoiceField<CoordinateFactory.Projections>(messageResolver.resolveMessage("messages.default.coordinateFactory", new Serializable[0]), values);
        this.coordinateFactoryField.setValue(CoordinateFactory.Projections.values()[0]);
        this.encodedTypeField = new StringField(messageResolver.resolveMessage("messages.parameter.encoding", new Serializable[0]), "8859_1");
    }

    @Override
    public Wizard getWizard() {
        final MessageResolver messageResolver = ModelEnviroment.getMessageResolver();
        Wizard wizard = new Wizard(messageResolver.resolveMessage("messages.importer.area.shp.title", new Serializable[0]));
        Page file = new Page(messageResolver.resolveMessage("messages.page.file.title", new Serializable[0]));
        Fieldset fileParams = new Fieldset(messageResolver.resolveMessage("messages.parameter.file.title", new Serializable[0]));
        fileParams.addField(this.shapefileField);
        fileParams.addField(this.encodedTypeField);
        file.addFieldset(fileParams);
        file.addLeaveAction(new CallBack<Boolean, Window>(){

            public Boolean execute(Window ... s) {
                File file = (File)AreaFromShapeImporter.this.shapefileField.getValue();
                AreaFromShapeImporter.this.shortcutColumnField.setChoices(new String[0]);
                AreaFromShapeImporter.this.displayNameColumnField.setChoices(new String[0]);
                String filename = file.getAbsolutePath();
                int lastDotIndex = filename.lastIndexOf(46);
                String prefix = filename.substring(0, lastDotIndex);
                try {
                    AttributeDescriptor[] dbfHeader = ShpDbfReader.getDbfHeader(prefix, (String)AreaFromShapeImporter.this.encodedTypeField.getValue());
                    String[] choices = new String[dbfHeader.length];
                    for (int i = 0; i < dbfHeader.length; ++i) {
                        choices[i] = dbfHeader[i].getName();
                    }
                    AreaFromShapeImporter.this.shortcutColumnField.setChoices(choices);
                    AreaFromShapeImporter.this.displayNameColumnField.setChoices(choices);
                }
                catch (xBaseJException ex) {
                    throw new RuntimeException(messageResolver.resolveMessage("errors.import.file", new Serializable[0]), ex);
                }
                catch (IOException ex) {
                    throw new RuntimeException(messageResolver.resolveMessage("errors.import.file", new Serializable[0]), ex);
                }
                return true;
            }
        });
        wizard.addPage(file);
        Page page2 = new Page(messageResolver.resolveMessage("messages.page.content.title", new Serializable[0]));
        Fieldset columns = new Fieldset();
        columns.addField(this.shortcutColumnField);
        columns.addField(this.displayNameColumnField);
        columns.addField(this.layerField);
        columns.addField(this.coordinateFactoryField);
        page2.addFieldset(columns);
        wizard.addPage(page2);
        return wizard;
    }

    @Override
    public Worker getWorker(Window parent) {
        return new AreaFromShapeImportWorker(this);
    }

    @Override
    public AreaShapeImportDto getDto() {
        AreaShapeImportDto areaShapeImportDto = new AreaShapeImportDto();
        areaShapeImportDto.setCoordinateFactory((CoordinateFactory.Projections)((Object)this.coordinateFactoryField.getValue()));
        areaShapeImportDto.setAreaLayerDto((AreaLayerDto)((Object)((AreaLayerModel)this.layerField.getValue()).createProxy()));
        areaShapeImportDto.setShortCutColumn((String)this.shortcutColumnField.getValue());
        areaShapeImportDto.setDescriptionColumn((String)this.displayNameColumnField.getValue());
        File shapeFile = (File)this.shapefileField.getValue();
        String filename = shapeFile.getAbsolutePath();
        int lastDotIndex = filename.lastIndexOf(46);
        String prefix = filename.substring(0, lastDotIndex);
        try {
            areaShapeImportDto.setShpContent(FileUtils.readFileToByteArray(shapeFile));
            File shxFile = new File(prefix + ".shx");
            if (shxFile.exists()) {
                areaShapeImportDto.setShxContent(FileUtils.readFileToByteArray(shxFile));
            }
            areaShapeImportDto.setDbfContent(FileUtils.readFileToByteArray(new File(prefix + ".dbf")));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        areaShapeImportDto.setEncodedType((String)this.encodedTypeField.getValue());
        return areaShapeImportDto;
    }
}

