/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.importer.area;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.importer.AbstractCsvImporter;
import de.datomino.peppergis.client.message.EnumMessageResolverNameGenerator;
import de.datomino.peppergis.client.model.area.AreaLayerModel;
import de.datomino.peppergis.client.model.area.AreaLayerModelImpl;
import de.datomino.peppergis.dto.importer.area.AreaCsvObjectImportDto;
import de.datomino.peppergis.importer.area.AreaImporter;
import de.datomino.peppergis.importer.area.data.MultiPolygonImportData;
import de.datomino.peppergis.type.AreaObjectGenInfoDiscriminator;
import de.datomino.util.assistant.model.ChoiceField;
import de.datomino.util.assistant.model.CsvColumnChoiceField;
import de.datomino.util.assistant.model.Fieldset;
import de.datomino.util.message.MessageResolver;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.ktde.math.projection.CoordinateFactory;
import org.ktde.util.NameGenerator;

public abstract class AbstractAreaFromStringCsvImporter<U extends AreaCsvObjectImportDto>
extends AbstractCsvImporter<U>
implements AreaImporter<MultiPolygonImportData, U> {
    private ChoiceField<AreaLayerModel> layerField;
    private ChoiceField<CoordinateFactory.Projections> coordinateFactoryField;
    private CsvColumnChoiceField areaShortcutField;
    private CsvColumnChoiceField areaDisplaynameField;
    private CsvColumnChoiceField wkbField;
    private ModelEnviroment modelEnviroment = new ModelEnviroment(null);

    public AbstractAreaFromStringCsvImporter() {
        Collection<AreaLayerModel> areas = this.modelEnviroment.getAllCaller().getAreaCaller().getAreaLayersForType(new AreaObjectGenInfoDiscriminator[]{AreaObjectGenInfoDiscriminator.AREA_OBJECT_GEN_FREEHAND});
        MessageResolver messageResolver = ModelEnviroment.getMessageResolver();
        this.layerField = new ChoiceField<1>(messageResolver.resolveMessage("messages.import.area.layer", new Serializable[0]), (Collection<1>)areas, new NameGenerator<AreaLayerModel>(){

            @Override
            public String getName(AreaLayerModel t) {
                return t == null ? "_Bitte w\u00e4hlen" : t.getDisplayname();
            }
        });
        Collection<CoordinateFactory.Projections> projections = CoordinateFactory.getListableProjections();
        CoordinateFactory.Projections[] values = new CoordinateFactory.Projections[projections.size()];
        values = projections.toArray(values);
        this.coordinateFactoryField = new ChoiceField<CoordinateFactory.Projections>(messageResolver.resolveMessage("messages.default.coordinateFactory", new Serializable[0]), values, new EnumMessageResolverNameGenerator(), CoordinateFactory.Projections.Wgs84);
        this.wkbField = new CsvColumnChoiceField(messageResolver.resolveMessageForEnum(Columns.COORDINATE_STRING), (Serializable)((Object)Columns.COORDINATE_STRING), "^(?:wkb|geom|coordinates|koordinaten.*|koo)$", false);
        this.areaShortcutField = new CsvColumnChoiceField(messageResolver.resolveMessageForEnum(AreaCsvObjectImportDto.Columns.AREA_SHORTCUT), (Serializable)((Object)AreaCsvObjectImportDto.Columns.AREA_SHORTCUT), "^id$", false);
        this.areaDisplaynameField = new CsvColumnChoiceField(messageResolver.resolveMessageForEnum(AreaCsvObjectImportDto.Columns.DISPLAY_NAME), (Serializable)((Object)AreaCsvObjectImportDto.Columns.DISPLAY_NAME), "^id$", false);
    }

    @Override
    protected void addCsvFields(List<CsvColumnChoiceField> choiceFields) {
        choiceFields.add(this.areaShortcutField);
        choiceFields.add(this.areaDisplaynameField);
        choiceFields.add(this.wkbField);
    }

    @Override
    protected List<Fieldset> getAdditionalFieldsets() {
        Fieldset geo = new Fieldset(ModelEnviroment.getMessageResolver().resolveMessage("messages.importer.parcel.geo", new Serializable[0]));
        geo.addField(this.layerField);
        geo.addField(this.coordinateFactoryField);
        return Collections.singletonList(geo);
    }

    @Override
    protected void writeToDto(U dto) {
        super.writeToDto(dto);
        ((AreaCsvObjectImportDto)dto).setCoordinateFactory((CoordinateFactory.Projections)((Object)this.coordinateFactoryField.getValue()));
        ((AreaCsvObjectImportDto)dto).setLayer(((AreaLayerModelImpl)this.layerField.getValue()).createDto());
    }

    public static enum Columns {
        COORDINATE_STRING;

    }
}

