/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.importer.action;

import de.datomino.peppergis.client.communication.BaseCaller;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.UndoManager;
import de.datomino.peppergis.client.model.base.ImportedLocationModel;
import de.datomino.peppergis.client.model.base.LocationModel;
import de.datomino.peppergis.client.model.base.PoiModel;
import de.datomino.peppergis.client.util.StreetNameComparator;
import de.datomino.peppergis.importer.poi.ImportPoiEditorGui;
import de.datomino.peppergis.type.ImportedLocationStatus;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Properties;
import javax.swing.AbstractAction;

public class CheckImportPoisAction
extends AbstractAction {
    private static final long serialVersionUID = -9079954715493538352L;
    private Window parent;
    private Properties properties;

    public CheckImportPoisAction(Window parent) {
        super(ModelEnviroment.getMessageResolver().resolveMessage("importer.poi.check", new Serializable[0]));
        this.parent = parent;
        this.properties = ModelEnviroment.getProperties();
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        ModelEnviroment modelEnviroment = new ModelEnviroment(this.parent);
        BaseCaller baseCaller = modelEnviroment.getAllCaller().getBaseCaller();
        ArrayList<PoiModel> poisWithNullGeom = new ArrayList<PoiModel>(baseCaller.fetchPoisWithNullGeom());
        UndoManager undoManager = modelEnviroment.getUndoManager();
        undoManager.startTransaction();
        for (PoiModel nullGeom : poisWithNullGeom) {
            LocationModel location = nullGeom.getLocation();
            ImportedLocationModel importedLocation = location == null ? null : location.getImportedLocation();
            if (importedLocation == null || importedLocation.getStatus() != null) continue;
            importedLocation.setStatus(ImportedLocationStatus.NOTCHANGED);
        }
        undoManager.finishTransaction("Aktualisieren Importe-Location-Status");
        poisWithNullGeom.addAll(baseCaller.fetchNotCheckedPois());
        Collections.sort(poisWithNullGeom, new StreetNameComparator());
        ImportPoiEditorGui gui = new ImportPoiEditorGui(modelEnviroment, this.properties, poisWithNullGeom);
        gui.showDialog(ModelEnviroment.getMessageResolver().resolveMessage("importer.poi.editor.list", new Serializable[0]), this.parent);
    }
}

