/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.importer.action;

import de.datomino.peppergis.client.communication.StreetNetCaller;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.UndoManager;
import de.datomino.peppergis.client.model.map.ParcelModel;
import de.datomino.peppergis.importer.parcel.ImportParcelEditorGui;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import javax.swing.AbstractAction;
import org.ktde.util.StringUtil;

public class CheckImportParcelsAction
extends AbstractAction {
    private static final long serialVersionUID = 7844463313911847698L;
    private Window parent;
    private Properties properties;

    public CheckImportParcelsAction(Window parent) {
        super(ModelEnviroment.getMessageResolver().resolveMessage("importer.parcel.check", new Serializable[0]));
        this.parent = parent;
        this.properties = ModelEnviroment.getProperties();
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        ModelEnviroment modelEnviroment = new ModelEnviroment(this.parent);
        StreetNetCaller streetNetCaller = modelEnviroment.getAllCaller().getStreetNetCaller();
        ArrayList<ParcelModel> parcelTupels = new ArrayList<ParcelModel>(streetNetCaller.fetchNotCheckedParcels());
        String zero = ModelEnviroment.getProperties().getProperty("parcel.coordinates.ignoreZero");
        if (!StringUtil.isTrue(zero)) {
            Collection<ParcelModel> parcelsWithNullGeom = streetNetCaller.fetchParcelsWithNullGeom();
            for (ParcelModel tupel : parcelsWithNullGeom) {
                if (parcelTupels.contains(tupel)) continue;
                parcelTupels.add(tupel);
            }
        }
        UndoManager undoManager = modelEnviroment.getUndoManager();
        undoManager.joinTransaction();
        undoManager.startTransaction();
        ImportParcelEditorGui gui = new ImportParcelEditorGui(modelEnviroment, this.properties, parcelTupels);
        gui.showDialog(ModelEnviroment.getMessageResolver().resolveMessage("importer.parcel.editor.list", new Serializable[0]), this.parent);
    }
}

