/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.importer;

import de.datomino.logistic.dto.LogisticLocationDto;
import de.datomino.logistic.dto.LogisticQualifiedLocationDto;
import de.datomino.logistic.dto.qualifiers.KatasterSearchLocationQualifierDto;
import de.datomino.logistic.dto.qualifiers.LocationQualifierDescriptorDto;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.importer.MultiAdressChooserDialog;
import de.datomino.util.international.country.Country;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import org.ktde.util.StringUtil;

public abstract class AbstractGeocodeAction
extends AbstractAction {
    private static final long serialVersionUID = -6378320199622029882L;
    private Component parent;
    private boolean streetSelection;
    private LocationQualifierDescriptorDto<?> locationQualifierDescriptorDto;
    private ModelEnviroment modelEnviroment;

    public AbstractGeocodeAction(String name, ModelEnviroment modelEnviroment, LocationQualifierDescriptorDto<?> locationQualifierDescriptorDto, boolean streetSelection, Component parent) {
        super(name);
        this.modelEnviroment = modelEnviroment;
        this.locationQualifierDescriptorDto = locationQualifierDescriptorDto;
        this.streetSelection = streetSelection;
        this.parent = parent;
    }

    protected abstract LogisticLocationDto<Long> getLogisticLocationDto();

    protected abstract void setLogisticLocationDto(LogisticQualifiedLocationDto var1, boolean var2);

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.locationQualifierDescriptorDto instanceof KatasterSearchLocationQualifierDto) {
            int d = JOptionPane.showConfirmDialog(this.parent, ModelEnviroment.getMessageResolver().resolveMessage("messages.search.kataster.confirmationQuestion", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("messages.default.question", new Serializable[0]), 0);
            if (d == 0) {
                this.searchMethod();
            }
        } else {
            this.searchMethod();
        }
    }

    private void searchMethod() {
        LogisticLocationDto<Long> logisticLocationDto = this.getLogisticLocationDto();
        Exception exc = null;
        ArrayList<LogisticQualifiedLocationDto> locations = new ArrayList<LogisticQualifiedLocationDto>(this.modelEnviroment.getAllCaller().getStreetNetCaller().searchAddressWithQualifiersParameterized(logisticLocationDto, null, new LocationQualifierDescriptorDto[]{this.locationQualifierDescriptorDto}));
        new MultiAdressChooserDialog<LogisticQualifiedLocationDto>(this.parent, locations, this.locationQualifierDescriptorDto.isIdentifyable(), this.streetSelection, exc){
            private static final long serialVersionUID = -4587369687076200816L;

            @Override
            protected void setValue(LogisticQualifiedLocationDto o, boolean identifyable) {
                AbstractGeocodeAction.this.setLogisticLocationDto(o, identifyable);
            }

            @Override
            protected String getString(LogisticQualifiedLocationDto o) {
                Double matching;
                String extension;
                String housenumber;
                String street;
                String district;
                boolean districtBlank;
                String city;
                boolean cityBlank;
                String postcode;
                boolean postcodeBlank;
                StringBuilder sb = new StringBuilder();
                Country country = o.getCountry();
                if (country != null) {
                    sb.append(country.getVehicleSign()).append(", ");
                }
                if (!(postcodeBlank = StringUtil.isBlank(postcode = o.getPostcode()))) {
                    sb.append(postcode).append(" ");
                }
                if (!(cityBlank = StringUtil.isBlank(city = o.getCity()))) {
                    sb.append(city);
                }
                if (!(districtBlank = StringUtil.isBlank(district = o.getDistrict()))) {
                    if (!cityBlank) {
                        sb.append(" - ");
                    }
                    sb.append(district);
                }
                if (!StringUtil.isBlank(street = o.getStreet())) {
                    if (!(postcodeBlank && cityBlank && districtBlank)) {
                        sb.append(", ");
                    }
                    sb.append(street).append(" ");
                }
                if (!StringUtil.isBlank(housenumber = o.getHousenumber())) {
                    sb.append(housenumber);
                }
                if (!StringUtil.isBlank(extension = o.getExtension())) {
                    sb.append(extension);
                }
                if ((matching = o.getMatching()) == null) {
                    matching = 0.0;
                }
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(matching);
                return sb.toString();
            }
        };
    }
}

