/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.helper;

import de.datomino.util.geo.ImmutableGeoObjectFactory;
import de.datomino.util.geo.ImmutableLineString;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.ImmutablePolygon;
import de.datomino.util.geo.exception.IllegalPointCountException;
import de.datomino.util.geo.util.GeoUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.ktde.util.datatypes.Tupel;
import org.ktde.util.datatypes.UnionFind;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreetsegmentHelper {
    private static Logger LOGGER = LoggerFactory.getLogger(StreetsegmentHelper.class);

    public static Collection<ImmutablePolygon> getParts(Collection<ImmutableLineString> lineStrings, Integer maxLineStringCount) {
        Collection<Set<ImmutableLineString>> components = StreetsegmentHelper.findComponents(lineStrings);
        HashSet<ImmutablePolygon> parts = new HashSet<ImmutablePolygon>(components.size());
        for (Set<ImmutableLineString> component : components) {
            parts.add(StreetsegmentHelper.findClosure(component, maxLineStringCount));
        }
        return parts;
    }

    private static ImmutablePolygon findClosure(Collection<ImmutableLineString> lineStrings, Integer maxLineStringCount) {
        ImmutableLineString mostBottom = StreetsegmentHelper.getMostBottom(lineStrings);
        ImmutablePoint crossingStart = mostBottom.getStartPoint();
        ImmutablePoint crossingEnd = mostBottom.getEndPoint();
        List<ImmutableLineString> ringA = StreetsegmentHelper.findRing(lineStrings, crossingStart, mostBottom);
        List<ImmutableLineString> ringB = StreetsegmentHelper.findRing(lineStrings, crossingEnd, mostBottom);
        ImmutablePolygon polyA = StreetsegmentHelper.getPolygon(ringA, crossingStart);
        ImmutablePolygon polyB = StreetsegmentHelper.getPolygon(ringB, crossingEnd);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("check area polygons:");
            LOGGER.trace("area a: " + polyA.getArea());
            LOGGER.trace("clockwise a: " + GeoUtils.isClockwise(polyA));
            LOGGER.trace("area b: " + polyB.getArea());
            LOGGER.trace("clockwise b: " + GeoUtils.isClockwise(polyB));
        }
        if (!GeoUtils.isClockwise(polyA)) {
            return polyA;
        }
        return polyB;
    }

    private static ImmutablePolygon getPolygon(List<ImmutableLineString> ring, ImmutablePoint startCrossing) {
        ImmutablePolygon result;
        LinkedList<ImmutablePoint> points = new LinkedList<ImmutablePoint>();
        ImmutablePoint nextCrossing = startCrossing;
        for (ImmutableLineString lineString : ring) {
            ImmutablePoint crossingStart = lineString.getStartPoint();
            ImmutablePoint crossingEnd = lineString.getEndPoint();
            if (crossingStart.equals(nextCrossing)) {
                nextCrossing = crossingEnd;
            } else {
                if (lineString != null) {
                    lineString = lineString.getMirror();
                }
                nextCrossing = crossingStart;
            }
            if (lineString == null) continue;
            points.addAll(lineString.getCoordinates());
        }
        try {
            result = ImmutableGeoObjectFactory.createImmutablePolygon(points);
        }
        catch (IllegalPointCountException e) {
            throw new IllegalStateException("Stra\u00dfennetz scheint inkonsistent.");
        }
        return result;
    }

    private static List<ImmutableLineString> findRing(Collection<ImmutableLineString> lineStrings, ImmutablePoint startCrossing, ImmutableLineString startSide) {
        ImmutablePoint nextCrossing = startCrossing;
        ImmutableLineString currentLineString = startSide;
        LinkedList<ImmutableLineString> result = new LinkedList<ImmutableLineString>();
        boolean finished = false;
        do {
            result.add(currentLineString);
            ImmutablePoint crossingStart = currentLineString.getStartPoint();
            ImmutablePoint crossingEnd = currentLineString.getEndPoint();
            nextCrossing = crossingStart.equals(nextCrossing) ? crossingEnd : crossingStart;
            List<ImmutableLineString> crossingOrder = StreetsegmentHelper.getOrderedLineStrings(nextCrossing, lineStrings);
            if (startCrossing.equals(nextCrossing)) {
                Tupel<List<ImmutableLineString>, List<ImmutableLineString>> inout = StreetsegmentHelper.getAlternating(nextCrossing, startSide, result, true, false, false);
                finished = true;
                for (ImmutableLineString test : inout.getElement1()) {
                    if (!lineStrings.contains(test)) continue;
                    finished = false;
                    break;
                }
            }
            if (finished) continue;
            boolean found = false;
            ImmutableLineString nextSide = null;
            for (ImmutableLineString side : crossingOrder) {
                if (side.equals(currentLineString)) {
                    found = true;
                    continue;
                }
                if (!lineStrings.contains(side)) continue;
                if (found) {
                    nextSide = side;
                    break;
                }
                if (nextSide != null) continue;
                nextSide = side;
            }
            currentLineString = nextSide;
        } while (!finished);
        return result;
    }

    private static Tupel<List<ImmutableLineString>, List<ImmutableLineString>> getAlternating(ImmutablePoint curCrossing, ImmutableLineString anchor, List<ImmutableLineString> switches, boolean firstIsTrue, boolean partStartIsTrue, boolean partStartAltIsTrue) {
        LinkedList<ImmutableLineString> setTrue = new LinkedList<ImmutableLineString>();
        LinkedList<ImmutableLineString> setFalse = new LinkedList<ImmutableLineString>();
        List<ImmutableLineString> orderedLineStrings = StreetsegmentHelper.getOrderedLineStrings(curCrossing, switches);
        int from = -1;
        int i = 0;
        for (ImmutableLineString lineString : orderedLineStrings) {
            if (lineString.equals(anchor)) {
                from = i;
                break;
            }
            ++i;
        }
        if (from == -1) {
            LOGGER.error("line string not adjacent to crossing");
        }
        boolean addmode = firstIsTrue;
        int c = orderedLineStrings.size();
        for (i = 0; i < c; ++i) {
            ImmutableLineString lineString = orderedLineStrings.get((from + i) % c);
            if (switches.contains(lineString)) {
                if (addmode) {
                    if (partStartAltIsTrue) {
                        setTrue.add(lineString);
                    } else {
                        setFalse.add(lineString);
                    }
                } else if (addmode) {
                    if (partStartIsTrue) {
                        setTrue.add(lineString);
                    } else {
                        setFalse.add(lineString);
                    }
                }
                addmode = !addmode;
                continue;
            }
            if (addmode) {
                setTrue.add(lineString);
                continue;
            }
            setFalse.add(lineString);
        }
        return new Tupel<List<ImmutableLineString>, List<ImmutableLineString>>(setTrue, setFalse);
    }

    private static List<ImmutableLineString> getOrderedLineStrings(final ImmutablePoint crossing, Collection<ImmutableLineString> lineStrings) {
        ArrayList<ImmutableLineString> result = new ArrayList<ImmutableLineString>(StreetsegmentHelper.findNeighLineStrings(crossing, lineStrings));
        Collections.sort(result, new Comparator<ImmutableLineString>(){

            @Override
            public int compare(ImmutableLineString o1, ImmutableLineString o2) {
                Double a1 = o1.getEndPoint() == crossing ? StreetsegmentHelper.computeAngle(crossing, o1, false) : StreetsegmentHelper.computeAngle(crossing, o1, true);
                Double a2 = o2.getEndPoint() == crossing ? StreetsegmentHelper.computeAngle(crossing, o2, false) : StreetsegmentHelper.computeAngle(crossing, o2, true);
                return a1.compareTo(a2);
            }
        });
        return result;
    }

    private static Collection<Set<ImmutableLineString>> findComponents(Collection<ImmutableLineString> lineStrings) {
        UnionFind<ImmutableLineString> unionFind = new UnionFind<ImmutableLineString>();
        for (ImmutableLineString street : lineStrings) {
            ImmutablePoint crossingStart = ((ImmutableLineString)street.getGeom()).getStartPoint();
            ImmutablePoint crossingEnd = ((ImmutableLineString)street.getGeom()).getEndPoint();
            for (ImmutableLineString neighLineString : StreetsegmentHelper.findNeighLineStrings(crossingStart, lineStrings)) {
                unionFind.union(street, neighLineString);
            }
            for (ImmutableLineString neighLineString : StreetsegmentHelper.findNeighLineStrings(crossingEnd, lineStrings)) {
                unionFind.union(street, neighLineString);
            }
        }
        HashMap<ImmutableLineString, HashSet<ImmutableLineString>> componentKeys = new HashMap<ImmutableLineString, HashSet<ImmutableLineString>>();
        HashSet<Set<ImmutableLineString>> result = new HashSet<Set<ImmutableLineString>>();
        for (ImmutableLineString lineString : lineStrings) {
            ImmutableLineString root = unionFind.getRoot(lineString);
            HashSet<ImmutableLineString> set = (HashSet<ImmutableLineString>)componentKeys.get(root);
            if (set == null) {
                set = new HashSet<ImmutableLineString>();
                componentKeys.put(root, set);
                result.add(set);
            }
            set.add(lineString);
        }
        return result;
    }

    private static Collection<ImmutableLineString> findNeighLineStrings(ImmutablePoint crossing, Collection<ImmutableLineString> lineStrings) {
        HashSet<ImmutableLineString> result = new HashSet<ImmutableLineString>();
        for (ImmutableLineString lineString : lineStrings) {
            if (!lineString.getStartPoint().equals(crossing) && !lineString.getEndPoint().equals(crossing)) continue;
            result.add(lineString);
        }
        return result;
    }

    private static ImmutableLineString getMostBottom(Collection<ImmutableLineString> lineStrings) {
        double minY = Double.MAX_VALUE;
        HashSet<ImmutableLineString> candidates = new HashSet<ImmutableLineString>();
        for (ImmutableLineString lineString : lineStrings) {
            if (lineString == null) continue;
            double locMinY = lineString.getMinY();
            if (locMinY == minY) {
                candidates.add(lineString);
                continue;
            }
            if (!(locMinY < minY)) continue;
            candidates.clear();
            candidates.add(lineString);
            minY = locMinY;
        }
        ImmutableLineString bottomMost = (ImmutableLineString)candidates.iterator().next();
        for (ImmutableLineString candidate : candidates) {
            if (!StreetsegmentHelper.isMoreBottom(candidate, bottomMost)) continue;
            bottomMost = candidate;
        }
        return bottomMost;
    }

    private static boolean isMoreBottom(ImmutableLineString candidate, ImmutableLineString failure) {
        ImmutablePoint failureRight;
        int step;
        double minY = candidate.getMinY();
        int failureIndex = StreetsegmentHelper.getBottom(minY, failure.getCoordinates());
        ImmutablePoint failureLeft = failureIndex - (step = 1) > 0 ? failure.getCoordinates().get(failureIndex - step) : null;
        ImmutablePoint immutablePoint = failureRight = failureIndex + step < failure.getCoordinates().size() ? failure.getCoordinates().get(failureIndex + step) : null;
        while (failureLeft != null && failureRight != null) {
            ImmutablePoint bottomRight;
            int bottomIndex;
            ImmutablePoint bottomLeft;
            double bottom;
            double failureBottom = (failureLeft == null ? 0.0 : failureLeft.getY()) + (failureRight == null ? 0.0 : failureRight.getY());
            if (failureBottom > (bottom = ((bottomLeft = (bottomIndex = StreetsegmentHelper.getBottom(minY, candidate.getCoordinates())) - step > 0 ? candidate.getCoordinates().get(bottomIndex - step) : null) == null ? 0.0 : bottomLeft.getY()) + ((bottomRight = bottomIndex + step < candidate.getCoordinates().size() ? candidate.getCoordinates().get(bottomIndex + step) : null) == null ? 0.0 : bottomRight.getY()))) {
                return true;
            }
            if (failureBottom < bottom) {
                return false;
            }
            failureLeft = failureIndex - ++step > 0 ? failure.getCoordinates().get(failureIndex - step) : null;
            failureRight = failureIndex + step < failure.getCoordinates().size() ? failure.getCoordinates().get(failureIndex + step) : null;
        }
        return false;
    }

    private static int getBottom(double minY, List<ImmutablePoint> points) {
        int index = 0;
        for (ImmutablePoint point : points) {
            if (point.getY() == minY) break;
            ++index;
        }
        return index;
    }

    private static double computeAngle(ImmutablePoint crossing, ImmutableLineString segment, boolean start) {
        List<ImmutablePoint> points = ((ImmutableLineString)segment.getGeom()).getCoordinates();
        int first = 0;
        int second = 1;
        if (!start) {
            int s = points.size();
            first = s - 1;
            second = s - 2;
        }
        ImmutablePoint sp1 = points.get(first);
        ImmutablePoint sp2 = points.get(second);
        return (Math.atan2(sp2.getY() - sp1.getY(), sp2.getX() - sp1.getX()) * 180.0 / Math.PI + 360.0) % 360.0;
    }
}

