/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.helper;

import de.datomino.peppergis.helper.PointEntityId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public final class PointEntityUtil {
    private PointEntityUtil() {
    }

    public static List<PointEntityId> transformToPointEntityIds(Collection<Long> ids, PointEntityId.PointEnityType pointEnityType) {
        ArrayList<PointEntityId> result = new ArrayList<PointEntityId>(ids.size());
        for (Long id : ids) {
            result.add(new PointEntityId(id, pointEnityType));
        }
        return result;
    }

    public static List<Long> transformToIds(Collection<PointEntityId> pointEntityIds) {
        ArrayList<Long> ids = new ArrayList<Long>(pointEntityIds.size());
        for (PointEntityId peid : pointEntityIds) {
            ids.add(peid.getId());
        }
        return ids;
    }

    public static List<Long> transformAndFilterToIds(Collection<PointEntityId> pointEntityIds, PointEntityId.PointEnityType pointEnityType) {
        LinkedList<Long> ids = new LinkedList<Long>();
        for (PointEntityId peid : pointEntityIds) {
            if (peid.getPointEnityType() != pointEnityType) continue;
            ids.add(peid.getId());
        }
        return ids;
    }
}

