/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.helper;

import de.datomino.logistic.type.StopType;
import de.datomino.peppergis.helper.PointEntityId;
import de.datomino.util.geo.ImmutableLineString;
import de.datomino.util.geo.ImmutablePoint;
import org.apache.commons.lang.builder.ToStringBuilder;

public class PointEntity {
    private PointEntityId id;
    private ImmutablePoint geom;
    private ImmutablePoint accessGeom;
    private ImmutablePoint otherAccessGeom;
    private ImmutableLineString streetLineString;
    private Long routeSegmentId;
    private Long otherRouteSegmentId;
    private ImmutableLineString routeSegmentLineString;
    private String postcode;
    private String city;
    private String district;
    private String street;
    private String housenumber;
    private String extension;
    private Integer sortOrder;
    private Double parcelLocation;
    private StopType stopType;

    public PointEntity(PointEntityId id, ImmutablePoint geom, ImmutablePoint accessGeom) {
        this.id = id;
        this.geom = geom;
        this.accessGeom = accessGeom == null ? geom : accessGeom;
    }

    public ImmutablePoint getGeom() {
        return this.geom;
    }

    public ImmutablePoint getAccessGeom() {
        return this.accessGeom;
    }

    public ImmutablePoint getOtherAccessGeom() {
        return this.otherAccessGeom;
    }

    public void setOtherAccessGeom(ImmutablePoint otherAccessGeom) {
        this.otherAccessGeom = otherAccessGeom;
    }

    public Long getRouteSegmentId() {
        return this.routeSegmentId;
    }

    public void setRouteSegmentId(Long routeSegmentId) {
        this.routeSegmentId = routeSegmentId;
    }

    public Long getOtherRouteSegmentId() {
        return this.otherRouteSegmentId;
    }

    public void setOtherRouteSegmentId(Long otherRouteSegmentId) {
        this.otherRouteSegmentId = otherRouteSegmentId;
    }

    public ImmutableLineString getRouteSegmentLineString() {
        return this.routeSegmentLineString;
    }

    public void setRouteSegmentLineString(ImmutableLineString routeSegmentLineString) {
        this.routeSegmentLineString = routeSegmentLineString;
    }

    public String getPostcode() {
        return this.postcode;
    }

    public void setPostcode(String postcode) {
        this.postcode = postcode;
    }

    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getDistrict() {
        return this.district;
    }

    public void setDistrict(String district) {
        this.district = district;
    }

    public PointEntityId getId() {
        return this.id;
    }

    public void setId(PointEntityId id) {
        this.id = id;
    }

    public ImmutableLineString getStreetLineString() {
        return this.streetLineString;
    }

    public void setStreetLineString(ImmutableLineString streetLineString) {
        this.streetLineString = streetLineString;
    }

    public String getStreet() {
        return this.street;
    }

    public void setStreet(String street) {
        this.street = street;
    }

    public String getHousenumber() {
        return this.housenumber;
    }

    public void setHousenumber(String housenumber) {
        this.housenumber = housenumber;
    }

    public String getExtension() {
        return this.extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public Integer getSortOrder() {
        return this.sortOrder;
    }

    public void setSortOrder(Integer sortOrder) {
        this.sortOrder = sortOrder;
    }

    public Double getParcelLocation() {
        return this.parcelLocation;
    }

    public void setParcelLocation(Double parcelLocation) {
        this.parcelLocation = parcelLocation;
    }

    public StopType getStopType() {
        if (this.stopType == null) {
            this.stopType = StopType.NORMAL;
        }
        return this.stopType;
    }

    public void setStopType(StopType stopType) {
        this.stopType = stopType;
    }

    public String toString() {
        return new ToStringBuilder(this).append("id", this.getId()).append("geom", this.getGeom()).append("accessGeom", this.getAccessGeom()).append("streetLineString", this.getStreetLineString()).append("routeSegmentId", this.getRouteSegmentId()).append("routeSegmentLineString", this.getRouteSegmentLineString()).append("postcode", this.getPostcode()).append("street", this.getStreet()).append("housenumber", this.getHousenumber()).append("extension", this.getExtension()).toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof PointEntity) {
            PointEntity other = (PointEntity)obj;
            return this.id.equals(other.id);
        }
        return false;
    }
}

