/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.helper;

import java.util.HashMap;
import java.util.Map;
import org.ktde.util.StringUtil;
import org.ktde.util.datatypes.Tupel;

public enum ParcelImporterStreetStandarizingType {
    NONE,
    STR,
    STRASSE,
    STRASZE,
    STR_DOT;

    private static final String[] SUFFIX_TO_REPLACE;
    private static final Map<Character, String> SPECIAL;

    public static String standardize(String street, ParcelImporterStreetStandarizingType type) {
        return ParcelImporterStreetStandarizingType.standardize(street, type, false);
    }

    public static String standardize(String street, ParcelImporterStreetStandarizingType type, boolean replaceSpecial) {
        String result = street;
        if (type != null && street != null) {
            switch (type) {
                case NONE: {
                    break;
                }
                case STR: {
                    Tupel<String, Boolean> tupel = ParcelImporterStreetStandarizingType.getStub(street);
                    if (tupel == null) break;
                    result = ParcelImporterStreetStandarizingType.addSuffix(tupel, "str");
                    break;
                }
                case STRASSE: {
                    Tupel<String, Boolean> tupel = ParcelImporterStreetStandarizingType.getStub(street);
                    if (tupel == null) break;
                    result = ParcelImporterStreetStandarizingType.addSuffix(tupel, "strasse");
                    break;
                }
                case STRASZE: {
                    Tupel<String, Boolean> tupel = ParcelImporterStreetStandarizingType.getStub(street);
                    if (tupel == null) break;
                    result = ParcelImporterStreetStandarizingType.addSuffix(tupel, "stra\u00dfe");
                    break;
                }
                case STR_DOT: {
                    Tupel<String, Boolean> tupel = ParcelImporterStreetStandarizingType.getStub(street);
                    if (tupel == null) break;
                    result = ParcelImporterStreetStandarizingType.addSuffix(tupel, "str.");
                }
            }
        }
        return replaceSpecial ? StringUtil.normalize(result, SPECIAL) : result;
    }

    private static String addSuffix(Tupel<String, Boolean> tupel, String newSuffix) {
        String suffix = newSuffix;
        if (tupel.getElement2().booleanValue()) {
            suffix = Character.toUpperCase(newSuffix.charAt(0)) + newSuffix.substring(1);
        }
        return tupel.getElement1() + suffix;
    }

    private static Tupel<String, Boolean> getStub(String street) {
        String sStreet = street.toLowerCase();
        Integer cut = null;
        for (String suffix : SUFFIX_TO_REPLACE) {
            if (!sStreet.endsWith(suffix)) continue;
            cut = suffix.length();
            break;
        }
        if (cut == null) {
            return null;
        }
        String result = street.substring(0, street.length() - cut);
        boolean capital = Character.isUpperCase(street.charAt(street.length() - cut));
        return new Tupel<String, Boolean>(result, capital);
    }

    static {
        SUFFIX_TO_REPLACE = new String[]{"str.", "str", "strasse", "stra\u00dfe"};
        SPECIAL = new HashMap<Character, String>();
        SPECIAL.put(Character.valueOf('\u00e4'), "ae");
        SPECIAL.put(Character.valueOf('\u00f6'), "oe");
        SPECIAL.put(Character.valueOf('\u00fc'), "ue");
        SPECIAL.put(Character.valueOf('\u00c4'), "Ae");
        SPECIAL.put(Character.valueOf('\u00d6'), "Oe");
        SPECIAL.put(Character.valueOf('\u00dc'), "Ue");
        SPECIAL.put(Character.valueOf('\u00df'), "ss");
    }
}

