/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.exception;

import de.datomino.peppergis.exception.ClientExportException;
import java.util.Collection;

public class UploadPmdException
extends ClientExportException {
    private static final long serialVersionUID = -528457247486344543L;
    private Type type = Type.UNDEFINED;
    private Collection<String> usedShortcuts;
    private String targetLayer;

    protected UploadPmdException(String message) {
        super(message);
    }

    protected UploadPmdException(Throwable cause) {
        super(cause);
    }

    protected UploadPmdException(Collection<String> usedShortcuts) {
        this("Shortcuts in use");
        this.usedShortcuts = usedShortcuts;
        this.type = Type.SHORTCUTS_IN_USE;
    }

    protected UploadPmdException() {
        this("invalid target layer");
        this.type = Type.INVALID_TARGET_LAYER;
    }

    public Type getType() {
        return this.type;
    }

    public Collection<String> getUsedShortcuts() {
        return this.usedShortcuts;
    }

    public String getTargetLayer() {
        return this.targetLayer;
    }

    public static UploadPmdException createInvalidTargetLayerException(String targetLayerName) {
        UploadPmdException uploadPmdException = new UploadPmdException();
        uploadPmdException.type = Type.INVALID_TARGET_LAYER;
        uploadPmdException.targetLayer = targetLayerName;
        return uploadPmdException;
    }

    public static UploadPmdException createUsesShortcutException(Collection<String> usedShortcuts) {
        UploadPmdException uploadPmdException = new UploadPmdException();
        uploadPmdException.type = Type.SHORTCUTS_IN_USE;
        uploadPmdException.usedShortcuts = usedShortcuts;
        return uploadPmdException;
    }

    public static UploadPmdException createUndefinedException() {
        UploadPmdException uploadPmdException = new UploadPmdException();
        uploadPmdException.type = Type.UNDEFINED;
        return uploadPmdException;
    }

    public static enum Type {
        UNDEFINED,
        SHORTCUTS_IN_USE,
        INVALID_TARGET_LAYER;

    }
}

