/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.dto.task;

import de.datomino.peppergis.dto.task.TaskReport;
import de.datomino.peppergis.dto.task.TaskStatus;
import de.datomino.peppergis.dto.task.TaskType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ServerTaskManagerStatus
implements Serializable {
    private static final long serialVersionUID = -6298630674717084173L;
    private Map<Long, List<TaskReport>> userTaskMap = new HashMap<Long, List<TaskReport>>();

    public void addUser(Long userId) {
        List<TaskReport> list = this.userTaskMap.get(userId);
        if (list == null) {
            list = this.createEmptyList();
            this.userTaskMap.put(userId, list);
        }
    }

    public void addTaskReport(Long userId, Long id, TaskType type, TaskStatus status, Date creationTime, Date startTime) {
        List<TaskReport> list = this.userTaskMap.get(userId);
        if (list == null) {
            list = this.createEmptyList();
            this.userTaskMap.put(userId, list);
        }
        list.add(new TaskReport(userId, id, type, status, creationTime, startTime));
    }

    private ArrayList<TaskReport> createEmptyList() {
        return new ArrayList<TaskReport>(){
            private static final long serialVersionUID = -4445756193326326621L;

            @Override
            public boolean add(TaskReport e) {
                boolean b;
                if (this.contains(e)) {
                    b = false;
                } else {
                    b = super.add(e);
                    Collections.sort(this, new Comparator<TaskReport>(){

                        @Override
                        public int compare(TaskReport o1, TaskReport o2) {
                            return Long.compare(o1.getId(), o2.getId());
                        }
                    });
                }
                return b;
            }
        };
    }

    public boolean isIdle() {
        return this.getRunningCount() == 0 && this.getWaitingCount() == 0;
    }

    public int getRunningCount() {
        int count = 0;
        for (List<TaskReport> list : this.userTaskMap.values()) {
            for (TaskReport report : list) {
                if (report.getStatus() != TaskStatus.RUNNING) continue;
                ++count;
            }
        }
        return count;
    }

    public int getWaitingCount() {
        int count = 0;
        for (List<TaskReport> list : this.userTaskMap.values()) {
            for (TaskReport report : list) {
                if (report.getStatus() != TaskStatus.READY) continue;
                ++count;
            }
        }
        return count;
    }

    public Map<Long, List<TaskReport>> getUserTaskMap() {
        return this.userTaskMap;
    }
}

