/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.dto.report.adp;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class AdpReportDto
implements Serializable {
    private static final long serialVersionUID = 6845513102931719030L;
    private List<Day> days = new LinkedList<Day>();

    public void addDay(Day day) {
        this.days.add(day);
    }

    public List<Day> getDays() {
        return this.days;
    }

    public static class Day
    implements Serializable,
    Comparable<Day> {
        private static final long serialVersionUID = -3367412999321155623L;
        private Date date;
        private int onlyMainCount;
        private Map<Integer, Integer> counts = new HashMap<Integer, Integer>();

        public Day(Date date) {
            this.date = date;
        }

        public Date getDate() {
            return this.date;
        }

        public Map<Integer, Integer> getCounts() {
            return this.counts;
        }

        public int getOnlyMainCount() {
            return this.onlyMainCount;
        }

        public void incOnlyMainCount() {
            ++this.onlyMainCount;
        }

        public void incCount(Integer countType) {
            Integer count = this.counts.get(countType);
            if (count == null) {
                this.counts.put(countType, 1);
            } else {
                this.counts.put(countType, count + 1);
            }
        }

        @Override
        public int compareTo(Day o) {
            return this.getDate().compareTo(o.getDate());
        }
    }
}

