/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.dto.importer;

import de.datomino.util.comparator.ComparatorBuilder;
import de.datomino.util.time.TimeUtil;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.ktde.util.datatypes.Tupel;

public class PersonalPlanningImportReportDto
implements Serializable {
    private static final long serialVersionUID = -3884826137626806268L;
    private Map<String, SortedSet<PersonalPlanningUnit>> setPlannings = new HashMap<String, SortedSet<PersonalPlanningUnit>>();
    private SortedSet<String> newDeliveres = new TreeSet<String>();
    private SortedSet<String> notFoundDeliverers = new TreeSet<String>();
    private SortedSet<Tupel<String, String>> notFoundAreas = new TreeSet<Tupel<String, String>>();
    private SortedSet<String> notFoundDeliveryRounds = new TreeSet<String>();
    private SortedSet<PersonalPlanningUnit> unallowedDeliveryRounds = new TreeSet<PersonalPlanningUnit>();
    private SortedSet<String> unallowedLayers = new TreeSet<String>();
    private SortedSet<PersonalPlanningUnit> alreadyExisting = new TreeSet<PersonalPlanningUnit>();

    public void addPlanning(String delivererNumber, String layer, String areaKey, Date date, String deliveryRound) {
        SortedSet<PersonalPlanningUnit> sortedSet = this.setPlannings.get(delivererNumber);
        if (sortedSet == null) {
            sortedSet = new TreeSet<PersonalPlanningUnit>();
            this.setPlannings.put(delivererNumber, sortedSet);
        }
        sortedSet.add(new PersonalPlanningUnit(layer, areaKey, date, deliveryRound));
    }

    public void addNewDeliverer(String delivererNumber) {
        this.newDeliveres.add(delivererNumber);
    }

    public void addNotFoundDeliverer(String delivererNumber) {
        this.notFoundDeliverers.add(delivererNumber);
    }

    public void addNotFoundArea(String layer, String area) {
        this.notFoundAreas.add(new Tupel<String, String>(layer, area));
    }

    public void addNotFoundDeliveryRound(String deliveryRound) {
        this.notFoundDeliveryRounds.add(deliveryRound);
    }

    public void addUnallowedDeliveryRound(String deliveryRound, String layer, String area, Date date) {
        this.unallowedDeliveryRounds.add(new PersonalPlanningUnit(layer, area, date, deliveryRound));
    }

    public void addUnallowedLayer(String layerId) {
        this.unallowedLayers.add(layerId);
    }

    public void addAlreadyExisting(String deliveryRound, String layer, String area, Date date) {
        this.alreadyExisting.add(new PersonalPlanningUnit(layer, area, date, deliveryRound));
    }

    public Map<String, SortedSet<PersonalPlanningUnit>> getSetPlannings() {
        return this.setPlannings;
    }

    public SortedSet<String> getNewDeliveres() {
        return this.newDeliveres;
    }

    public SortedSet<String> getNotFoundDeliverers() {
        return this.notFoundDeliverers;
    }

    public SortedSet<Tupel<String, String>> getNotFoundAreas() {
        return this.notFoundAreas;
    }

    public SortedSet<String> getNotFoundDeliveryRounds() {
        return this.notFoundDeliveryRounds;
    }

    public SortedSet<PersonalPlanningUnit> getUnallowedDeliveryRounds() {
        return this.unallowedDeliveryRounds;
    }

    public SortedSet<String> getUnallowedLayers() {
        return this.unallowedLayers;
    }

    public SortedSet<PersonalPlanningUnit> getAlreadyExisting() {
        return this.alreadyExisting;
    }

    public static class PersonalPlanningUnit
    implements Serializable,
    Comparable<PersonalPlanningUnit> {
        private static final long serialVersionUID = 2446720046573763225L;
        private String layer;
        private String areaKey;
        private Date date;
        private String deliveryRound;

        public PersonalPlanningUnit(String layer, String areaKey, Date date, String deliveryRound) {
            this.layer = layer;
            this.areaKey = areaKey;
            this.date = TimeUtil.normalize(date);
            this.deliveryRound = deliveryRound;
        }

        public String getLayer() {
            return this.layer;
        }

        public String getAreaKey() {
            return this.areaKey;
        }

        public Date getDate() {
            return this.date;
        }

        public String getDeliveryRound() {
            return this.deliveryRound;
        }

        public boolean equals(Object obj) {
            if (obj instanceof PersonalPlanningUnit) {
                PersonalPlanningUnit other = (PersonalPlanningUnit)obj;
                return new EqualsBuilder().append(this.getLayer(), other.getLayer()).append(this.getAreaKey(), other.getAreaKey()).append(this.getDate(), other.getDate()).append(this.getDeliveryRound(), other.getDeliveryRound()).isEquals();
            }
            return false;
        }

        public int hashCode() {
            return new HashCodeBuilder().append(this.getLayer()).append(this.getAreaKey()).append(this.getDate()).append(this.getDeliveryRound()).toHashCode();
        }

        @Override
        public int compareTo(PersonalPlanningUnit o) {
            return new ComparatorBuilder().append(this.getLayer(), o.getLayer()).append(this.getAreaKey(), o.getAreaKey()).append(this.getDate(), o.getDate()).append(this.getDeliveryRound(), o.getDeliveryRound()).compare();
        }
    }
}

