/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.datamanager.renderer;

import de.datomino.peppergis.client.gui.AbstractMapEditorPanel;
import de.datomino.peppergis.client.gui.map.RendererNode;
import de.datomino.peppergis.client.gui.subscription.SubscriptionFilterableMarkerRenderer;
import de.datomino.peppergis.client.model.area.AreaLayerModel;
import de.datomino.peppergis.client.model.base.SubscriptionModel;
import de.datomino.peppergis.client.util.StreetNameComparator;
import de.datomino.peppergis.client.util.model.location.LocationWrapper;
import de.datomino.peppergis.client.util.model.location.LocationWrapperFactory;
import de.datomino.peppergis.client.util.model.subscription.SubscriptionLocationObject;
import de.datomino.peppergis.datamanager.renderer.DataManagerJunctionRenderModule;
import de.datomino.peppergis.datamanager.renderer.DataManagerRendererUtil;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.model.GeoObjectBucketsModel;
import de.datomino.util.geo.model.GeomExtractor;
import java.awt.Color;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.TreeSet;

public class DataManagerSubscriptionRenderer
extends SubscriptionFilterableMarkerRenderer {
    private static final long serialVersionUID = 2993499244485822683L;
    private Collection<SubscriptionModel> selectedSubscriptionsInLegend;
    private DataManagerJunctionRenderModule junctionRenderer;

    public DataManagerSubscriptionRenderer(String name, String title, AbstractMapEditorPanel editorPanel, Double maxUpp, GeoObjectBucketsModel<SubscriptionLocationObject, ImmutablePoint> bucketsModel, AreaLayerModel layer, DataManagerJunctionRenderModule junctionRenderer) {
        super(name, title, editorPanel, maxUpp, bucketsModel, layer);
        this.initializeMarkedObjects(new TreeSet<SubscriptionLocationObject>(new StreetNameComparator<SubscriptionLocationObject, SubscriptionModel>(){

            @Override
            protected SubscriptionModel getM(SubscriptionLocationObject o) {
                return (SubscriptionModel)o.getModel();
            }
        }));
        this.junctionRenderer = junctionRenderer;
        this.setPointRenderer(new DefaultPointRenderer());
        ((DefaultPointRenderer)this.getPointRenderer()).setSubscriptionRenderer(this);
    }

    @Override
    protected Collection<SubscriptionModel> createSubscriptionCollection(Collection<SubscriptionLocationObject> markedObjects) {
        return new ArrayList<SubscriptionModel>(markedObjects.size());
    }

    @Override
    public Collection<SubscriptionLocationObject> getMarkedObjects() {
        return this.markedObjects;
    }

    @Override
    protected boolean isProperLayer(SubscriptionLocationObject sub) {
        return this.layer == null || ((SubscriptionModel)sub.getModel()).getAreaLayer() == this.layer;
    }

    public void setLayer(AreaLayerModel layer) {
        this.layer = layer;
    }

    public Collection<SubscriptionModel> getSelectedSubscriptionsInLegend() {
        return this.selectedSubscriptionsInLegend;
    }

    public void setSelectedSubscriptionsInLegend(Collection<SubscriptionModel> selectedSubscriptionsInLegend) {
        this.selectedSubscriptionsInLegend = selectedSubscriptionsInLegend;
    }

    public void clearSelectedSubscriptionsInLegend() {
        if (this.selectedSubscriptionsInLegend != null) {
            this.selectedSubscriptionsInLegend.clear();
        }
    }

    @Override
    protected void paintFirst(Collection<SubscriptionLocationObject> objects, double upp, Graphics2D g2d) {
        super.paintFirst(objects, upp, g2d);
        if (this.junctionRenderer.isActive()) {
            for (SubscriptionLocationObject object : objects) {
                this.junctionRenderer.render(g2d, upp, ((SubscriptionModel)object.getModel()).getLocation());
            }
        }
    }

    @Override
    protected void paintOnToAfterMarkDrawn(Collection<SubscriptionLocationObject> objects, double upp, Graphics2D g2da) {
        super.paintOnToAfterMarkDrawn(objects, upp, g2da);
        DataManagerRendererUtil.drawPin(objects, upp, g2da, this.selectedSubscriptionsInLegend, this.getAreaPointRenderer(), this.getNavigatorPanel().getCoordinateFactory(), new GeomExtractor<SubscriptionLocationObject, ImmutablePoint>(){

            @Override
            public ImmutablePoint getGeom(SubscriptionLocationObject object) {
                LocationWrapper locationWrapper = LocationWrapperFactory.INSTANCE.createLocationWrapper(((SubscriptionModel)object.getModel()).getLocation());
                return locationWrapper.getGeoLocation();
            }
        });
    }

    private static class DefaultPointRenderer
    extends SubscriptionFilterableMarkerRenderer.DummyPointRenderer {
        private DefaultPointRenderer() {
        }

        @Override
        protected RendererNode createRendererNode(SubscriptionLocationObject object, ImmutablePoint geom, double margin, Color colorOfAreaObject) {
            Integer index = this.getListIndex(object);
            if (index > -1) {
                return new RendererNode(index.toString(), geom.getCoordinate(), DefaultPointRenderer.getFrameColor((SubscriptionModel)object.getModel()), colorOfAreaObject, margin);
            }
            return new RendererNode("", geom.getCoordinate(), DefaultPointRenderer.getFrameColor((SubscriptionModel)object.getModel()), colorOfAreaObject, margin);
        }

        private int getListIndex(SubscriptionLocationObject subscriptionLocationObject) {
            TreeSet treeSet = (TreeSet)this.renderer.getMarkedObjects();
            return treeSet.contains(subscriptionLocationObject) ? treeSet.headSet(subscriptionLocationObject, true).size() : -1;
        }

        @Override
        protected ImmutablePoint getToThePoint(SubscriptionLocationObject object, ImmutablePoint geom) {
            LocationWrapper locationWrapper = LocationWrapperFactory.INSTANCE.createLocationWrapper(((SubscriptionModel)object.getModel()).getLocation());
            ImmutablePoint point = locationWrapper.getGeoLocation();
            if (point != null) {
                return (ImmutablePoint)point.getTransformed(geom.getCoordinateFactory());
            }
            return super.getToThePoint(object, geom);
        }
    }
}

