/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.datamanager.renderer;

import de.datomino.peppergis.client.gui.AbstractMapEditorPanel;
import de.datomino.peppergis.client.gui.renderer.area.AreaPointRenderer;
import de.datomino.peppergis.client.gui.stop.StopFilterableMarkerRenderer;
import de.datomino.peppergis.client.model.tour.StopModel;
import de.datomino.peppergis.client.util.model.location.LocationWrapper;
import de.datomino.peppergis.client.util.model.location.LocationWrapperFactory;
import de.datomino.peppergis.client.util.model.stop.StopLocationObject;
import de.datomino.peppergis.datamanager.renderer.DataManagerJunctionRenderModule;
import de.datomino.peppergis.datamanager.util.StreetNameIdComparator;
import de.datomino.util.collection.CollectionUtil;
import de.datomino.util.collection.Transformer;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.model.GeoObjectBucketsModel;
import java.awt.Color;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.TreeSet;
import org.ktde.math.projection.Coordinate;

public class DataManagerStopRenderer
extends StopFilterableMarkerRenderer {
    private static final long serialVersionUID = -4038812469290001889L;
    private Collection<StopModel> selectedStopsInLegend;
    private AbstractMapEditorPanel editorPanel;
    private DataManagerJunctionRenderModule junctionRenderer;

    public DataManagerStopRenderer(String name, String title, AbstractMapEditorPanel editorPanel, Double maxUpp, GeoObjectBucketsModel<StopLocationObject, ImmutablePoint> bucketsModel, DataManagerJunctionRenderModule junctionRenderer) {
        super(name, title, editorPanel, maxUpp, bucketsModel);
        this.editorPanel = editorPanel;
        this.initializeMarkedObjects(new TreeSet<StopLocationObject>(new StreetNameIdComparator<StopLocationObject, StopModel>(){

            @Override
            protected StopModel getM(StopLocationObject o) {
                return (StopModel)o.getModel();
            }
        }));
        this.junctionRenderer = junctionRenderer;
        this.setPointRenderer(new DefaultPointRenderer());
    }

    @Override
    public void showMarked(Collection<StopLocationObject> markedObjects) {
        if (markedObjects == null) {
            return;
        }
        ArrayList stops = new ArrayList(markedObjects.size());
        CollectionUtil.transform(markedObjects, stops, new Transformer<StopLocationObject, StopModel>(){

            @Override
            public StopModel transform(StopLocationObject t) {
                return (StopModel)t.getModel();
            }
        });
        this.editorPanel.updatePanelAfterMark(this.getRenderObjectType(), stops);
    }

    @Override
    public Collection<StopLocationObject> getMarkedObjects() {
        return this.markedObjects;
    }

    public Collection<StopModel> getSelectedStopsInLegend() {
        return this.selectedStopsInLegend;
    }

    public void setSelectedStopsInLegend(Collection<StopModel> selectedStopsInLegend) {
        this.selectedStopsInLegend = selectedStopsInLegend;
    }

    public void clearSelectedStopsInLegend() {
        if (this.selectedStopsInLegend != null) {
            this.selectedStopsInLegend.clear();
        }
    }

    @Override
    protected void paintFirst(Collection<StopLocationObject> objects, double upp, Graphics2D g2d) {
        super.paintFirst(objects, upp, g2d);
        if (this.junctionRenderer.isActive()) {
            for (StopLocationObject object : objects) {
                this.junctionRenderer.render(g2d, upp, ((StopModel)object.getModel()).getLocation());
            }
        }
    }

    @Override
    protected void paintOnToAfterMarkDrawn(Collection<StopLocationObject> objects, double upp, Graphics2D g2da) {
        super.paintOnToAfterMarkDrawn(objects, upp, g2da);
        AreaPointRenderer areaPointRenderer = new AreaPointRenderer(g2da, upp, this.getNavigatorPanel().getCoordinateFactory());
        double margin = 10.0 * Math.pow(upp, -0.2) * upp;
        for (StopLocationObject object : objects) {
            LocationWrapper locationWrapper;
            ImmutablePoint point;
            if (this.selectedStopsInLegend == null || !this.selectedStopsInLegend.contains(object.getModel()) || (point = (locationWrapper = LocationWrapperFactory.INSTANCE.createLocationWrapper(((StopModel)object.getModel()).getLocation())).getGeoLocation()) == null) continue;
            point = (ImmutablePoint)point.getTransformed(this.getNavigatorPanel().getCoordinateFactory());
            Coordinate coordinate = point.getCoordinate();
            coordinate = coordinate.getFactory().createCoordinate(coordinate.getX(), coordinate.getY() + upp * 5.0);
            areaPointRenderer.drawPin(coordinate, margin, Color.GREEN);
        }
    }

    private static class DefaultPointRenderer
    extends StopFilterableMarkerRenderer.DummyPointRenderer {
        private DefaultPointRenderer() {
        }

        @Override
        protected ImmutablePoint getToThePoint(StopLocationObject stopLocationObject, ImmutablePoint geom) {
            LocationWrapper locationWrapper = LocationWrapperFactory.INSTANCE.createLocationWrapper(((StopModel)stopLocationObject.getModel()).getLocation());
            ImmutablePoint point = locationWrapper.getGeoLocation();
            if (point != null) {
                return (ImmutablePoint)point.getTransformed(geom.getCoordinateFactory());
            }
            return super.getToThePoint(stopLocationObject, geom);
        }
    }
}

