/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.datamanager.renderer;

import de.datomino.peppergis.client.gui.renderer.area.AreaPointRenderer;
import de.datomino.peppergis.client.model.Model;
import de.datomino.peppergis.client.util.AbstractLocationObject;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.model.GeomExtractor;
import java.awt.Color;
import java.awt.Graphics2D;
import java.util.Collection;
import org.ktde.math.projection.Coordinate;
import org.ktde.math.projection.CoordinateFactory;

public final class DataManagerRendererUtil {
    public static <M extends Model, L extends AbstractLocationObject<M>> void drawPin(Collection<L> objects, double upp, Graphics2D g2da, Collection<M> selectedInLegend, AreaPointRenderer areaPointRenderer, CoordinateFactory coordinateFactory, GeomExtractor<L, ImmutablePoint> geomExtractor) {
        double margin = 10.0 * Math.pow(upp, -0.2) * upp;
        for (AbstractLocationObject object : objects) {
            ImmutablePoint point;
            if (selectedInLegend == null || !selectedInLegend.contains(object.getModel()) || (point = geomExtractor.getGeom(object)) == null) continue;
            point = (ImmutablePoint)point.getTransformed(coordinateFactory);
            Coordinate coordinate = point.getCoordinate();
            coordinate = coordinate.getFactory().createCoordinate(coordinate.getX(), coordinate.getY() + upp * 5.0);
            if (areaPointRenderer == null) {
                areaPointRenderer = new AreaPointRenderer(g2da, upp, coordinateFactory);
            }
            areaPointRenderer.drawPin(coordinate, margin, Color.GREEN);
        }
    }
}

