/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.datamanager.renderer;

import de.datomino.peppergis.client.gui.AbstractMapEditorPanel;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.gui.poi.PoiFilterableMarkerRenderer;
import de.datomino.peppergis.client.gui.renderer.area.AreaPointRenderer;
import de.datomino.peppergis.client.model.area.AreaLayerModel;
import de.datomino.peppergis.client.model.base.PoiModel;
import de.datomino.peppergis.client.util.model.location.LocationWrapper;
import de.datomino.peppergis.client.util.model.location.LocationWrapperFactory;
import de.datomino.peppergis.client.util.model.poi.PoiLocationObject;
import de.datomino.peppergis.datamanager.renderer.DataManagerJunctionRenderModule;
import de.datomino.peppergis.datamanager.renderer.DataManagerRendererUtil;
import de.datomino.peppergis.datamanager.util.StreetNameIdComparator;
import de.datomino.util.collection.CollectionUtil;
import de.datomino.util.collection.Transformer;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.model.GeoObjectBucketsModel;
import de.datomino.util.geo.model.GeomExtractor;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.TreeSet;

public class DataManagerPoiRenderer
extends PoiFilterableMarkerRenderer {
    private static final long serialVersionUID = -4704429185967936675L;
    private Collection<PoiModel> selectedPoisInLegend;
    private DataManagerJunctionRenderModule junctionRenderer;

    public DataManagerPoiRenderer(String name, String title, AbstractMapEditorPanel editorPanel, Double maxUpp, GeoObjectBucketsModel<PoiLocationObject, ImmutablePoint> bucketsModel, ModelEnviroment modelEnviroment, AreaLayerModel areaLayerModel, DataManagerJunctionRenderModule junctionRenderer) {
        super(name, title, editorPanel, maxUpp, bucketsModel, modelEnviroment, areaLayerModel);
        this.initializeMarkedObjects(new TreeSet<PoiLocationObject>(new StreetNameIdComparator<PoiLocationObject, PoiModel>(){

            @Override
            protected PoiModel getM(PoiLocationObject o) {
                return (PoiModel)o.getModel();
            }
        }));
        this.junctionRenderer = junctionRenderer;
    }

    @Override
    protected boolean isToDrawObject(PoiLocationObject s) {
        return true;
    }

    @Override
    public void showMarked(Collection<PoiLocationObject> markedObjects) {
        if (markedObjects == null) {
            return;
        }
        ArrayList pois = new ArrayList(markedObjects.size());
        CollectionUtil.transform(markedObjects, pois, new Transformer<PoiLocationObject, PoiModel>(){

            @Override
            public PoiModel transform(PoiLocationObject t) {
                return (PoiModel)t.getModel();
            }
        });
        this.editorPanel.updatePanelAfterMark(this.getRenderObjectType(), pois);
    }

    @Override
    public Collection<PoiLocationObject> getMarkedObjects() {
        return this.markedObjects;
    }

    public Collection<PoiModel> getSelectedPoisInLegend() {
        return this.selectedPoisInLegend;
    }

    public void setSelectedPoisInLegend(Collection<PoiModel> selectedPoisInLegend) {
        this.selectedPoisInLegend = selectedPoisInLegend;
    }

    public void clearSelectedPoisInLegend() {
        if (this.selectedPoisInLegend != null) {
            this.selectedPoisInLegend.clear();
        }
    }

    @Override
    protected void paintFirst(Collection<PoiLocationObject> objects, double upp, Graphics2D g2d) {
        super.paintFirst(objects, upp, g2d);
        if (this.junctionRenderer.isActive()) {
            for (PoiLocationObject object : objects) {
                this.junctionRenderer.render(g2d, upp, ((PoiModel)object.getModel()).getLocation());
            }
        }
    }

    @Override
    protected void paintOnToAfterMarkDrawn(Collection<PoiLocationObject> objects, double upp, Graphics2D g2da) {
        super.paintOnToAfterMarkDrawn(objects, upp, g2da);
        AreaPointRenderer areaPointRenderer = new AreaPointRenderer(g2da, upp, this.getNavigatorPanel().getCoordinateFactory());
        DataManagerRendererUtil.drawPin(objects, upp, g2da, this.selectedPoisInLegend, areaPointRenderer, this.getNavigatorPanel().getCoordinateFactory(), new GeomExtractor<PoiLocationObject, ImmutablePoint>(){

            @Override
            public ImmutablePoint getGeom(PoiLocationObject object) {
                LocationWrapper locationWrapper = LocationWrapperFactory.INSTANCE.createLocationWrapper(((PoiModel)object.getModel()).getLocation());
                return locationWrapper.getGeoLocation();
            }
        });
    }
}

