/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.datamanager.renderer;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.gui.map.RendererNode;
import de.datomino.peppergis.client.gui.parcel.ParcelDialog;
import de.datomino.peppergis.client.gui.parcel.ParcelFilterableMarkerRenderer;
import de.datomino.peppergis.client.model.area.AreaLayerModel;
import de.datomino.peppergis.client.model.map.ParcelModel;
import de.datomino.peppergis.client.util.model.parcel.ParcelLocationObject;
import de.datomino.peppergis.datamanager.renderer.DataManagerJunctionRenderModule;
import de.datomino.peppergis.datamanager.renderer.DataManagerRendererUtil;
import de.datomino.peppergis.datamanager.util.StreetNameIdComparator;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.model.GeoObjectBucketsModel;
import de.datomino.util.geo.model.GeomExtractor;
import de.datomino.util.swing.SwingUtils;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.TreeSet;
import org.ktde.swing.navigator.NavigatorPanel;

public abstract class DataManagerParcelRenderer
extends ParcelFilterableMarkerRenderer {
    private static final long serialVersionUID = 1755555964993306974L;
    private Collection<ParcelModel> selectedParcelsInLegend;
    private DataManagerJunctionRenderModule junctionRenderer;

    public DataManagerParcelRenderer(String name, NavigatorPanel navigatorPanel, Double maxUpp, GeoObjectBucketsModel<ParcelLocationObject, ImmutablePoint> bucketsModel, AreaLayerModel sourceAreaLayerModel, boolean updateCoordinates, ModelEnviroment modelEnviroment, DataManagerJunctionRenderModule junctionRenderer) {
        super(name, navigatorPanel, maxUpp, bucketsModel, sourceAreaLayerModel, updateCoordinates, modelEnviroment);
        this.initializeMarkedObjects(new TreeSet<ParcelLocationObject>(new StreetNameIdComparator<ParcelLocationObject, ParcelModel>(){

            @Override
            protected ParcelModel getM(ParcelLocationObject o) {
                return (ParcelModel)o.getModel();
            }
        }));
        this.junctionRenderer = junctionRenderer;
        this.setPointRenderer(new DefaultPointRenderer());
        ((DefaultPointRenderer)this.getPointRenderer()).setParcelRenderer(this);
    }

    @Override
    protected Collection<ParcelModel> createParcelCollection(Collection<ParcelLocationObject> markedObjects) {
        return new ArrayList<ParcelModel>(markedObjects.size());
    }

    @Override
    public Collection<ParcelLocationObject> getMarkedObjects() {
        return this.markedObjects;
    }

    public Collection<ParcelModel> getSelectedParcelsInLegend() {
        return this.selectedParcelsInLegend;
    }

    public void setSelectedParcelsInLegend(Collection<ParcelModel> selectedParcelsInLegend) {
        this.selectedParcelsInLegend = selectedParcelsInLegend;
    }

    public void clearSelectedParcelsInLegend() {
        if (this.selectedParcelsInLegend != null) {
            this.selectedParcelsInLegend.clear();
        }
    }

    @Override
    protected ParcelDialog createParcelDialog(Collection<ParcelModel> parcels) {
        return new ParcelDialog(SwingUtils.findWindowParent(this.getNavigatorPanel()), parcels.iterator().next(), Dialog.ModalityType.APPLICATION_MODAL, this.getModelEnviroment(), false, this.isUpdateCoordinates()){
            private static final long serialVersionUID = 6107140297579076722L;

            @Override
            protected boolean isExternalEditEnabled() {
                return false;
            }
        };
    }

    @Override
    protected void paintFirst(Collection<ParcelLocationObject> objects, double upp, Graphics2D g2d) {
        super.paintFirst(objects, upp, g2d);
        if (this.junctionRenderer.isActive()) {
            for (ParcelLocationObject object : objects) {
                this.junctionRenderer.render(g2d, upp, (ParcelModel)object.getModel());
            }
        }
    }

    @Override
    protected void paintOnToAfterMarkDrawn(Collection<ParcelLocationObject> objects, double upp, Graphics2D g2da) {
        super.paintOnToAfterMarkDrawn(objects, upp, g2da);
        DataManagerRendererUtil.drawPin(objects, upp, g2da, this.selectedParcelsInLegend, this.getAreaPointRenderer(), this.getNavigatorPanel().getCoordinateFactory(), new GeomExtractor<ParcelLocationObject, ImmutablePoint>(){

            @Override
            public ImmutablePoint getGeom(ParcelLocationObject object) {
                return ((ParcelModel)object.getModel()).getGeom();
            }
        });
    }

    private static class DefaultPointRenderer
    extends ParcelFilterableMarkerRenderer.DummyPointRenderer {
        private DefaultPointRenderer() {
        }

        @Override
        protected RendererNode createRendererNode(ParcelLocationObject object, double margin, ImmutablePoint point, Color colorOfParcel, Color backColor) {
            Integer index = this.getListIndex(object);
            if (index > -1) {
                return new RendererNode(index.toString(), point.getCoordinate(), backColor, colorOfParcel, margin);
            }
            return new RendererNode("", point.getCoordinate(), backColor, colorOfParcel, margin);
        }

        private int getListIndex(ParcelLocationObject parcelLocationObject) {
            TreeSet treeSet = (TreeSet)this.renderer.getMarkedObjects();
            return treeSet.contains(parcelLocationObject) ? treeSet.headSet(parcelLocationObject, true).size() : -1;
        }
    }
}

