/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.datamanager.renderer;

import de.datomino.peppergis.client.gui.AbstractListCellRenderer;
import de.datomino.peppergis.client.model.map.ParcelModel;
import de.datomino.peppergis.client.util.ParcelModelUtil;
import de.datomino.peppergis.client.util.SegmentModelUtil;
import de.datomino.peppergis.type.SegmentStatus;
import de.datomino.util.geo.ImmutableGeoObjectFactory;
import de.datomino.util.geo.ImmutablePoint;
import java.awt.Color;
import java.util.Arrays;
import org.ktde.math.projection.Wgs84Factory;
import org.ktde.util.StringUtil;

public class DataManagerParcelListCellRenderer
extends AbstractListCellRenderer<ParcelModel> {
    @Override
    protected String getStringFromValue(ParcelModel parcel) {
        if (parcel == null) {
            return "";
        }
        this.colorOfText = ParcelModelUtil.getColorOfParcel(parcel, null, null, Color.BLACK);
        SegmentStatus segmentStatus = ParcelModelUtil.getSegmentStatus(parcel);
        if (segmentStatus != null && segmentStatus.isBad(null)) {
            this.colorOfText = SegmentModelUtil.getSegmentStatusColor(segmentStatus);
        }
        String address = ParcelModelUtil.getAddress(parcel);
        address = address + " - " + ParcelModelUtil.getDistrictName(parcel);
        String importKey = StringUtil.getNotNull(parcel.getImportKey());
        address = address + " (ID: " + importKey + ")";
        ImmutablePoint geom = parcel.getGeom();
        if (geom == null) {
            geom = ImmutableGeoObjectFactory.createImmutablePoint(Wgs84Factory.INSTANCE.createCoordinate(0.0, 0.0));
        }
        geom = (ImmutablePoint)geom.getTransformed(Wgs84Factory.INSTANCE);
        address = address + ", Lon: " + this.formatCoord(geom.getX()) + ", Lat: " + this.formatCoord(geom.getY());
        return address;
    }

    private String formatCoord(double coord) {
        if (coord == 0.0) {
            return "0.000000";
        }
        long m = Math.round(Math.floor(coord));
        long d = Math.round((coord - (double)m) * 1000000.0);
        String dString = Long.toString(d).replace(".", "");
        int newLength = 6 - dString.length();
        char[] c = new char[newLength < 0 ? 0 : newLength];
        Arrays.fill(c, '0');
        return m + "." + new String(c) + dString;
    }
}

