/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.datamanager.renderer;

import de.datomino.peppergis.client.gui.AbstractMapEditorPanel;
import de.datomino.peppergis.client.gui.letter.LetterFilterableMarkerRenderer;
import de.datomino.peppergis.client.gui.map.RendererNode;
import de.datomino.peppergis.client.model.area.AreaLayerModel;
import de.datomino.peppergis.client.model.base.LetterModel;
import de.datomino.peppergis.client.util.StreetNameComparator;
import de.datomino.peppergis.client.util.model.letter.LetterLocationObject;
import de.datomino.peppergis.client.util.model.location.LocationWrapper;
import de.datomino.peppergis.client.util.model.location.LocationWrapperFactory;
import de.datomino.peppergis.datamanager.renderer.DataManagerJunctionRenderModule;
import de.datomino.peppergis.datamanager.renderer.DataManagerRendererUtil;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.model.GeoObjectBucketsModel;
import de.datomino.util.geo.model.GeomExtractor;
import java.awt.Color;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.TreeSet;

public class DataManagerLetterRenderer
extends LetterFilterableMarkerRenderer {
    private static final long serialVersionUID = -7949809665389846924L;
    private Collection<LetterModel> selectedLettersInLegend;
    private DataManagerJunctionRenderModule junctionRenderer;

    public DataManagerLetterRenderer(String name, String title, AbstractMapEditorPanel editorPanel, Double maxUpp, GeoObjectBucketsModel<LetterLocationObject, ImmutablePoint> bucketsModel, AreaLayerModel layer, DataManagerJunctionRenderModule junctionRenderer) {
        super(name, title, editorPanel, maxUpp, bucketsModel, layer);
        this.initializeMarkedObjects(new TreeSet<LetterLocationObject>(new StreetNameComparator<LetterLocationObject, LetterModel>(){

            @Override
            protected LetterModel getM(LetterLocationObject o) {
                return (LetterModel)o.getModel();
            }
        }));
        this.junctionRenderer = junctionRenderer;
        this.setPointRenderer(new DefaultPointRenderer());
        ((DefaultPointRenderer)this.getPointRenderer()).setLetterRenderer(this);
    }

    @Override
    protected Collection<LetterModel> createLetterCollection(Collection<LetterLocationObject> markedObjects) {
        return new ArrayList<LetterModel>(markedObjects.size());
    }

    @Override
    public Collection<LetterLocationObject> getMarkedObjects() {
        return this.markedObjects;
    }

    @Override
    protected boolean isProperLayer(LetterLocationObject sub) {
        return this.layer == null || super.isProperLayer(sub);
    }

    public Collection<LetterModel> getSelectedLettersInLegend() {
        return this.selectedLettersInLegend;
    }

    public void setSelectedLettersInLegend(Collection<LetterModel> selectedLettersInLegend) {
        this.selectedLettersInLegend = selectedLettersInLegend;
    }

    public void clearSelectedLettersInLegend() {
        if (this.selectedLettersInLegend != null) {
            this.selectedLettersInLegend.clear();
        }
    }

    public void setLayer(AreaLayerModel layer) {
        this.layer = layer;
    }

    @Override
    protected boolean isToDrawObject(LetterLocationObject s) {
        return true;
    }

    @Override
    protected void paintFirst(Collection<LetterLocationObject> objects, double upp, Graphics2D g2d) {
        super.paintFirst(objects, upp, g2d);
        if (this.junctionRenderer.isActive()) {
            for (LetterLocationObject object : objects) {
                this.junctionRenderer.render(g2d, upp, ((LetterModel)object.getModel()).getLocation());
            }
        }
    }

    @Override
    protected void paintOnToAfterMarkDrawn(Collection<LetterLocationObject> objects, double upp, Graphics2D g2da) {
        super.paintOnToAfterMarkDrawn(objects, upp, g2da);
        DataManagerRendererUtil.drawPin(objects, upp, g2da, this.selectedLettersInLegend, this.getAreaPointRenderer(), this.getNavigatorPanel().getCoordinateFactory(), new GeomExtractor<LetterLocationObject, ImmutablePoint>(){

            @Override
            public ImmutablePoint getGeom(LetterLocationObject object) {
                LocationWrapper locationWrapper = LocationWrapperFactory.INSTANCE.createLocationWrapper(((LetterModel)object.getModel()).getLocation());
                return locationWrapper.getGeoLocation();
            }
        });
    }

    private static class DefaultPointRenderer
    extends LetterFilterableMarkerRenderer.DummyPointRenderer {
        private DefaultPointRenderer() {
        }

        @Override
        protected RendererNode createRendererNode(LetterLocationObject object, ImmutablePoint geom, double margin, Color colorOfAreaObject) {
            Integer index = this.getListIndex(object);
            if (index > -1) {
                return new RendererNode(index.toString(), geom.getCoordinate(), this.getFrameColor((LetterModel)object.getModel()), colorOfAreaObject, margin);
            }
            return new RendererNode("", geom.getCoordinate(), this.getFrameColor((LetterModel)object.getModel()), colorOfAreaObject, margin);
        }

        private int getListIndex(LetterLocationObject subscriptionLocationObject) {
            TreeSet treeSet = (TreeSet)this.renderer.getMarkedObjects();
            return treeSet.contains(subscriptionLocationObject) ? treeSet.headSet(subscriptionLocationObject, true).size() : -1;
        }
    }
}

