/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.datamanager.gui;

import de.datomino.peppergis.client.gui.common.AbstractCommonDialog;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.Model;
import de.datomino.peppergis.client.model.base.LocationModel;
import de.datomino.peppergis.client.model.map.ParcelModel;
import de.datomino.peppergis.client.util.LocationModelUtil;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class DeleteJunctionsDialog
extends AbstractCommonDialog {
    private static final long serialVersionUID = -5297427844800494228L;
    private List<? extends Model> list;
    private JCheckBox footBox;
    private JCheckBox bikeBox;
    private JCheckBox motorBox;

    public DeleteJunctionsDialog(List<? extends Model> list, ModelEnviroment modelEnviroment, Component parent, String title, Dialog.ModalityType modalityType) {
        super(modelEnviroment, parent, title, modalityType);
        this.list = list;
    }

    @Override
    protected Component getMainComponent() {
        JPanel panel = new JPanel(new GridLayout(3, 1));
        this.footBox = new JCheckBox(ModelEnviroment.getMessageResolver().resolveMessage("gui.route.foot", new Serializable[0]));
        panel.add(this.footBox);
        this.bikeBox = new JCheckBox(ModelEnviroment.getMessageResolver().resolveMessage("gui.route.bike", new Serializable[0]));
        panel.add(this.bikeBox);
        this.motorBox = new JCheckBox(ModelEnviroment.getMessageResolver().resolveMessage("gui.route.motorcar", new Serializable[0]));
        panel.add(this.motorBox);
        return panel;
    }

    @Override
    protected Action getOkAction() {
        return new AbstractAction(this.getOkActionName()){
            private static final long serialVersionUID = -5048286249729443261L;

            @Override
            public void actionPerformed(ActionEvent e) {
                DeleteJunctionsDialog.this.dispose();
                DeleteJunctionsDialog.this.deleteJunctions();
            }
        };
    }

    private void deleteJunctions() {
        boolean foot = this.footBox.isSelected();
        boolean bike = this.bikeBox.isSelected();
        boolean motor = this.motorBox.isSelected();
        if (foot || bike || motor) {
            this.modelEnviroment.getUndoManager().startTransaction();
            for (Model model : this.list) {
                LocationModel locationModel = LocationModelUtil.getLocationModel(model);
                ParcelModel parcel = null;
                if (model instanceof ParcelModel) {
                    parcel = (ParcelModel)model;
                } else if (locationModel != null) {
                    parcel = locationModel.getParcel();
                }
                if (parcel != null) {
                    if (foot) {
                        parcel.setFootSegment(null);
                        parcel.setManualFootSegmentUpdate(false);
                    }
                    if (bike) {
                        parcel.setBikeSegment(null);
                        parcel.setManualBikeSegmentUpdate(false);
                    }
                    if (motor) {
                        parcel.setMotorSegment(null);
                        parcel.setManualMotorSegmentUpdate(false);
                    }
                }
                if (locationModel == null) continue;
                if (foot) {
                    locationModel.setFootSegment(null);
                }
                if (bike) {
                    locationModel.setBikeSegment(null);
                }
                if (!motor) continue;
                locationModel.setMotorSegment(null);
            }
            this.modelEnviroment.getUndoManager().finishTransaction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.delete.junctions", new Serializable[0]));
        }
    }
}

