/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.datamanager.gui;

import de.datomino.logistic.type.RouteVehicleType;
import de.datomino.peppergis.client.gui.AbstractMapEditorPanel;
import de.datomino.peppergis.client.gui.location.AbstractControlPanel;
import de.datomino.peppergis.client.gui.location.AbstractLocationEditorPane;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.gui.map.SegmentHoverRenderer;
import de.datomino.peppergis.client.gui.renderer.AbstractFilterableMarkerNavigatorRenderer;
import de.datomino.peppergis.client.model.Model;
import de.datomino.peppergis.client.model.area.AreaLayerModel;
import de.datomino.peppergis.client.model.base.PoiModel;
import de.datomino.peppergis.client.model.map.ParcelModel;
import de.datomino.peppergis.client.model.map.SegmentModel;
import de.datomino.peppergis.client.model.tour.StopModel;
import de.datomino.peppergis.client.util.AbstractLocationObject;
import de.datomino.peppergis.client.util.ClientFormUtil;
import de.datomino.peppergis.client.util.model.location.LocationWrapperFactory;
import de.datomino.peppergis.client.util.model.parcel.ParcelLocationObject;
import de.datomino.peppergis.client.util.model.poi.PoiLocationObject;
import de.datomino.peppergis.client.util.model.stop.StopLocationObject;
import de.datomino.peppergis.datamanager.gui.DataManagerGui;
import de.datomino.peppergis.datamanager.handler.DataManagerListMouseHandler;
import de.datomino.peppergis.datamanager.renderer.DataManagerComboBoxListCellRenderer;
import de.datomino.peppergis.datamanager.renderer.DataManagerJunctionRenderModule;
import de.datomino.peppergis.datamanager.renderer.DataManagerParcelRenderer;
import de.datomino.peppergis.datamanager.renderer.DataManagerPoiRenderer;
import de.datomino.peppergis.datamanager.renderer.DataManagerStopRenderer;
import de.datomino.peppergis.type.DataManagerType;
import de.datomino.peppergis.util.FormUtil;
import de.datomino.peppergis.util.GeoUtil;
import de.datomino.util.collection.CollectionUtil;
import de.datomino.util.collection.Transformer;
import de.datomino.util.geo.ImmutableGeoObjectFactory;
import de.datomino.util.geo.ImmutableLineString;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.model.BucketsFetchCallback;
import de.datomino.util.geo.model.DefaultGeoObjectBucketsModel;
import de.datomino.util.geo.model.GeomExtractor;
import de.datomino.util.geo.model.StaticGeoObjectBucketsModel;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import org.ktde.math.projection.Coordinate;
import org.ktde.math.projection.CoordinateFactory;
import org.ktde.math.projection.Wgs84Factory;
import org.ktde.swing.AbstractToggleAction;

public class DataManagerMapEditorPanel
extends AbstractMapEditorPanel {
    private final double MAXUPP = 10.0;
    private static final long serialVersionUID = 1678917966802798225L;
    private CardLayout resultListCardLayout;
    private StaticGeoObjectBucketsModel<ParcelLocationObject, ImmutablePoint> parcelBucketsModel;
    private DataManagerParcelRenderer parcelRenderer;
    private StaticGeoObjectBucketsModel<PoiLocationObject, ImmutablePoint> poiBucketsModel;
    private DataManagerPoiRenderer poiRenderer;
    private StaticGeoObjectBucketsModel<StopLocationObject, ImmutablePoint> stopBucketsModel;
    private DataManagerStopRenderer stopRenderer;
    private DefaultGeoObjectBucketsModel<SegmentModel, ImmutableLineString> segmentBucketsModel;
    private SegmentHoverRenderer segmentHoverRenderer;
    private DataManagerJunctionRenderModule junctionRenderer;
    private DataManagerGui dataManagerGui;
    private JPanel resultListPanel;
    private Map<DataManagerType, JList<? extends Model>> resultListMap;
    private int rendererSortOrder;
    private AbstractToggleAction showMotorSegmentAction;
    private AbstractToggleAction showFootSegmentAction;
    private AbstractToggleAction showBikeSegmentAction;
    private final AbstractControlPanel controlPanel;

    public DataManagerMapEditorPanel(DataManagerGui parent) {
        super(parent.getModelEnvironment());
        JPanel panel;
        super.initialize();
        this.setDividerSize(2);
        this.rendererSortOrder = DataManagerMapEditorPanel.getSortOrderData();
        this.dataManagerGui = parent;
        this.resultListMap = new EnumMap<DataManagerType, JList<? extends Model>>(DataManagerType.class);
        this.resultListCardLayout = new CardLayout();
        this.resultListPanel = new JPanel(this.resultListCardLayout);
        this.resultListPanel.setBorder(BorderFactory.createLoweredSoftBevelBorder());
        this.resultListPanel.setMinimumSize(FormUtil.SIZEOFLISTANDTREE);
        this.setLeftComponent(this.resultListPanel);
        this.initSegmentRenderer();
        Component rightComp = this.getRightComponent();
        if (!(rightComp instanceof JPanel) || !((panel = (JPanel)rightComp).getLayout() instanceof BorderLayout)) {
            panel = new JPanel(new BorderLayout());
            panel.add((Component)this.getNavigatorPanel(), "Center");
            this.setRightComponent(panel);
        }
        this.initSegmentActions();
        this.controlPanel = new AbstractControlPanel(this.getNavigatorPanel(), this.dataManagerGui.getModelEnvironment(), this.showMotorSegmentAction, this.showBikeSegmentAction, this.showFootSegmentAction, true, true, false, false){
            private static final long serialVersionUID = 6061174268444863940L;

            @Override
            protected void doAfterCoordinateFound(ImmutablePoint point) {
            }

            @Override
            protected void doAfterCoordinateFound(Coordinate coordinate) {
            }

            @Override
            public void update() {
                DataManagerMapEditorPanel.this.update();
            }
        };
        panel.add((Component)this.controlPanel, "North");
        this.junctionRenderer = new DataManagerJunctionRenderModule(this.getModelEnviroment());
    }

    private void initSegmentRenderer() {
        this.segmentBucketsModel = new DefaultGeoObjectBucketsModel<SegmentModel, ImmutableLineString>(this.getNavigatorPanel().getCoordinateFactory().getRefScale() * 5000.0, this.getNavigatorPanel().getCoordinateFactory(), new GeomExtractor<SegmentModel, ImmutableLineString>(){

            @Override
            public ImmutableLineString getGeom(SegmentModel object) {
                return object.getGeom();
            }
        });
        this.segmentBucketsModel.setFetchCallback(new BucketsFetchCallback<SegmentModel, ImmutableLineString>(){

            @Override
            public Collection<SegmentModel> fetch(Coordinate topLeft, Coordinate bottomRight) {
                return DataManagerMapEditorPanel.this.getModelEnviroment().getAllCaller().getStreetNetCaller().fetchSegments(topLeft, bottomRight);
            }
        });
        this.segmentHoverRenderer = new SegmentHoverRenderer(this.getNavigatorPanel(), (Double)AbstractLocationEditorPane.DEFAULTMAXUPP, this.segmentBucketsModel, this.getModelEnviroment(), true, this.getParent());
        this.segmentHoverRenderer.setNavigatorPanel(this.getNavigatorPanel());
        this.segmentHoverRenderer.setSortOrder(1000);
        this.getNavigatorPanel().addRenderer(this.segmentHoverRenderer);
    }

    private void initSegmentActions() {
        this.showMotorSegmentAction = new AbstractToggleAction(ModelEnviroment.getMessageResolver().resolveMessage("gui.route.motorcar", new Serializable[0])){
            private static final long serialVersionUID = -9108000987585896652L;

            @Override
            public void turnOn() {
                DataManagerMapEditorPanel.this.getSegmentHoverRenderer().turnOn();
                DataManagerMapEditorPanel.this.getSegmentHoverRenderer().setForMotorSegment(true);
                DataManagerMapEditorPanel.this.getJunctionRenderer().addType(RouteVehicleType.MOTORCAR);
                DataManagerMapEditorPanel.this.engageRenderer(DataManagerMapEditorPanel.this.dataManagerGui.getCurrentType());
                DataManagerMapEditorPanel.this.showMotorSegmentAction.putValue("SwingSelectedKey", new Boolean(true));
                DataManagerMapEditorPanel.this.repaint(10L);
            }

            @Override
            public void turnOff() {
                DataManagerMapEditorPanel.this.getSegmentHoverRenderer().setSelected(DataManagerMapEditorPanel.this.showBikeSegmentAction.isSelected() || DataManagerMapEditorPanel.this.showFootSegmentAction.isSelected());
                DataManagerMapEditorPanel.this.getSegmentHoverRenderer().setForMotorSegment(false);
                DataManagerMapEditorPanel.this.getJunctionRenderer().removeType(RouteVehicleType.MOTORCAR);
                DataManagerMapEditorPanel.this.showMotorSegmentAction.putValue("SwingSelectedKey", new Boolean(false));
                DataManagerMapEditorPanel.this.repaint(10L);
            }
        };
        this.showBikeSegmentAction = new AbstractToggleAction(ModelEnviroment.getMessageResolver().resolveMessage("gui.route.bike", new Serializable[0])){
            private static final long serialVersionUID = 8373192196258156238L;

            @Override
            public void turnOn() {
                DataManagerMapEditorPanel.this.getSegmentHoverRenderer().turnOn();
                DataManagerMapEditorPanel.this.getSegmentHoverRenderer().setForBikeSegment(true);
                DataManagerMapEditorPanel.this.getJunctionRenderer().addType(RouteVehicleType.BIKE);
                DataManagerMapEditorPanel.this.engageRenderer(DataManagerMapEditorPanel.this.dataManagerGui.getCurrentType());
                DataManagerMapEditorPanel.this.showBikeSegmentAction.putValue("SwingSelectedKey", new Boolean(true));
                DataManagerMapEditorPanel.this.repaint(10L);
            }

            @Override
            public void turnOff() {
                DataManagerMapEditorPanel.this.getSegmentHoverRenderer().setSelected(DataManagerMapEditorPanel.this.showMotorSegmentAction.isSelected() || DataManagerMapEditorPanel.this.showFootSegmentAction.isSelected());
                DataManagerMapEditorPanel.this.getSegmentHoverRenderer().setForBikeSegment(false);
                DataManagerMapEditorPanel.this.getJunctionRenderer().removeType(RouteVehicleType.BIKE);
                DataManagerMapEditorPanel.this.showBikeSegmentAction.putValue("SwingSelectedKey", new Boolean(false));
                DataManagerMapEditorPanel.this.repaint(10L);
            }
        };
        this.showFootSegmentAction = new AbstractToggleAction(ModelEnviroment.getMessageResolver().resolveMessage("gui.route.foot", new Serializable[0])){
            private static final long serialVersionUID = -7474495824562503867L;

            @Override
            public void turnOn() {
                DataManagerMapEditorPanel.this.getSegmentHoverRenderer().turnOn();
                DataManagerMapEditorPanel.this.getSegmentHoverRenderer().setForFootSegment(true);
                DataManagerMapEditorPanel.this.getJunctionRenderer().addType(RouteVehicleType.FOOT);
                DataManagerMapEditorPanel.this.engageRenderer(DataManagerMapEditorPanel.this.dataManagerGui.getCurrentType());
                DataManagerMapEditorPanel.this.showFootSegmentAction.putValue("SwingSelectedKey", new Boolean(true));
                DataManagerMapEditorPanel.this.repaint(10L);
            }

            @Override
            public void turnOff() {
                DataManagerMapEditorPanel.this.getSegmentHoverRenderer().setSelected(DataManagerMapEditorPanel.this.showMotorSegmentAction.isSelected() || DataManagerMapEditorPanel.this.showBikeSegmentAction.isSelected());
                DataManagerMapEditorPanel.this.getSegmentHoverRenderer().setForFootSegment(false);
                DataManagerMapEditorPanel.this.getJunctionRenderer().removeType(RouteVehicleType.FOOT);
                DataManagerMapEditorPanel.this.showFootSegmentAction.putValue("SwingSelectedKey", new Boolean(false));
                DataManagerMapEditorPanel.this.repaint(10L);
            }
        };
    }

    public void setMapEditorModel(DataManagerType type) {
        if (this.resultListMap.get((Object)type) == null) {
            switch (type) {
                case PARCEL: {
                    JList parcelList = new JList();
                    parcelList.setModel(new DefaultComboBoxModel());
                    DataManagerComboBoxListCellRenderer parcelListCellRenderer = new DataManagerComboBoxListCellRenderer(this.dataManagerGui, false);
                    parcelList.setCellRenderer(parcelListCellRenderer);
                    parcelListCellRenderer.setWithIndex(true);
                    this.setUpListPanel(type, parcelList);
                    this.parcelBucketsModel = this.getStaticBucketsModel();
                    this.parcelRenderer = new DataManagerParcelRenderer(AbstractFilterableMarkerNavigatorRenderer.RenderObjectType.PARCELAREARENDERER.name(), this.navigator, (Double)this.MAXUPP, this.parcelBucketsModel, null, this.continuousLayout, this.dataManagerGui.getModelEnvironment(), this.junctionRenderer){
                        private static final long serialVersionUID = 2123429403266610803L;

                        @Override
                        protected void updatePanelAfterMark(AbstractFilterableMarkerNavigatorRenderer.RenderObjectType renderObjectType, Collection<ParcelModel> parcels) {
                            DataManagerMapEditorPanel.this.updatePanelAfterMark(renderObjectType, parcels);
                        }
                    };
                    this.addRenderer(this.parcelRenderer);
                    break;
                }
                case CUSTOMER: 
                case PICKPOINT: 
                case AREALOCATION: 
                case DELIVERERLOCATION: 
                case GROUPLOCATION: 
                case MAINLOCATION: 
                case AREADELIVERERLOCATION: {
                    JList poiList = new JList();
                    poiList.setModel(new DefaultComboBoxModel());
                    poiList.setCellRenderer(new DataManagerComboBoxListCellRenderer(this.dataManagerGui, false));
                    this.setUpListPanel(type, poiList);
                    if (this.poiRenderer != null) break;
                    this.poiBucketsModel = this.getStaticBucketsModel();
                    this.poiRenderer = new DataManagerPoiRenderer(AbstractFilterableMarkerNavigatorRenderer.RenderObjectType.POIRENDERER.name(), AbstractFilterableMarkerNavigatorRenderer.RenderObjectType.POIRENDERER.name(), this, (Double)this.MAXUPP, this.poiBucketsModel, this.dataManagerGui.getModelEnvironment(), null, this.junctionRenderer);
                    this.addRenderer(this.poiRenderer);
                    break;
                }
                case STOPS: {
                    JList stopList = new JList();
                    stopList.setModel(new DefaultComboBoxModel());
                    stopList.setCellRenderer(new DataManagerComboBoxListCellRenderer(this.dataManagerGui, false));
                    this.setUpListPanel(type, stopList);
                    this.stopBucketsModel = this.getStaticBucketsModel();
                    this.stopRenderer = new DataManagerStopRenderer(AbstractFilterableMarkerNavigatorRenderer.RenderObjectType.STOPRENDERER.name(), AbstractFilterableMarkerNavigatorRenderer.RenderObjectType.STOPRENDERER.name(), this, this.MAXUPP, this.stopBucketsModel, this.junctionRenderer);
                    this.addRenderer(this.stopRenderer);
                    break;
                }
            }
        }
        this.engageRenderer(type);
        this.applyData();
        this.resultListCardLayout.show(this.resultListPanel, type.name());
        ComboBoxModel cbm = (ComboBoxModel)this.resultListMap.get((Object)type).getModel();
        this.dataManagerGui.getSelectionComboBox().setModel(cbm);
    }

    private void addRenderer(AbstractFilterableMarkerNavigatorRenderer<?, ?, ?, ?, ?, ?, ?> renderer) {
        renderer.setSortOrder(this.rendererSortOrder++);
        this.navigator.getToggleActions().addAction(renderer);
        this.navigator.addRenderer(renderer);
        renderer.setActive(true);
        renderer.turnOn();
    }

    private void setUpListPanel(DataManagerType type, JList<? extends Model> list) {
        this.resultListMap.put(type, list);
        JScrollPane scrollPane = new JScrollPane(list);
        JPanel pane = new JPanel(new BorderLayout());
        pane.add((Component)scrollPane, "Center");
        this.resultListPanel.add((Component)pane, type.name());
        list.addListSelectionListener(this.dataManagerGui.getListSelectionHandler());
        list.getModel().addListDataListener(this.dataManagerGui.getListSelectionHandler());
        list.addMouseListener(new DataManagerListMouseHandler(list, this.dataManagerGui));
    }

    public void engageRenderer(DataManagerType type) {
        if (this.poiRenderer != null) {
            boolean poiOn = EnumSet.range(DataManagerType.CUSTOMER, DataManagerType.PICKPOINT).contains((Object)type);
            this.poiRenderer.setActive(poiOn);
            this.poiRenderer.setTurnedOn(poiOn);
        }
        if (this.parcelRenderer != null) {
            boolean parcelOn = type == DataManagerType.PARCEL;
            this.parcelRenderer.setActive(parcelOn);
            this.parcelRenderer.setTurnedOn(parcelOn);
        }
        if (this.stopRenderer != null) {
            boolean stopOn = type == DataManagerType.STOPS;
            this.stopRenderer.setActive(stopOn);
            this.stopRenderer.setTurnedOn(stopOn);
        }
    }

    public void applyData() {
        List<? extends Model> resultList = this.dataManagerGui.getResultDataMap().get((Object)this.dataManagerGui.getCurrentType());
        this.clearBuckets();
        this.clearMarked();
        this.clearLists();
        this.centerModels(resultList, true);
    }

    public void centerModels(List<? extends Model> models) {
        this.centerModels(models, false);
    }

    public void centerModels(List<? extends Model> models, boolean addToBuckets) {
        Collection<Coordinate> coordinates;
        switch (this.dataManagerGui.getCurrentType()) {
            case CUSTOMER: 
            case PICKPOINT: 
            case AREALOCATION: 
            case DELIVERERLOCATION: 
            case GROUPLOCATION: 
            case MAINLOCATION: 
            case AREADELIVERERLOCATION: {
                Collection<PoiLocationObject> poiLocationObjects = this.getLocationObjects(models, new PoiTransformer());
                if (addToBuckets) {
                    this.poiBucketsModel.addAll(poiLocationObjects);
                }
                coordinates = this.getCoordinates(poiLocationObjects, false);
                break;
            }
            case PARCEL: {
                Collection<ParcelLocationObject> parcelLocationObjects = this.getLocationObjects(models, new ParcelTransformer());
                if (addToBuckets) {
                    this.parcelBucketsModel.addAll(parcelLocationObjects);
                }
                coordinates = this.getCoordinates(parcelLocationObjects, false);
                break;
            }
            case STOPS: {
                Collection<StopLocationObject> stopLocationObjects = this.getLocationObjects(models, new StopTransformer());
                if (addToBuckets) {
                    this.stopBucketsModel.addAll(stopLocationObjects);
                }
                coordinates = this.getCoordinates(stopLocationObjects, false);
                break;
            }
            default: {
                coordinates = new LinkedList<Coordinate>();
            }
        }
        this.centerCoordinates(coordinates);
    }

    private void clearBuckets() {
        if (this.poiBucketsModel != null) {
            this.poiBucketsModel.clear();
        }
        if (this.parcelBucketsModel != null) {
            this.parcelBucketsModel.clear();
        }
        if (this.stopBucketsModel != null) {
            this.stopBucketsModel.clear();
        }
    }

    private void clearMarked() {
        if (this.poiRenderer != null) {
            this.poiRenderer.clearMarked();
        }
        if (this.parcelRenderer != null) {
            this.parcelRenderer.clearMarked();
        }
        if (this.stopRenderer != null) {
            this.stopRenderer.clearMarked();
        }
    }

    private void clearLists() {
        for (JList<? extends Model> list : this.resultListMap.values()) {
            ListModel<? extends Model> lm = list.getModel();
            if (!(lm instanceof DefaultComboBoxModel)) continue;
            ((DefaultComboBoxModel)lm).removeAllElements();
        }
    }

    private <L extends AbstractLocationObject<? extends Model>> Collection<Coordinate> getCoordinates(Collection<L> locationObjects, boolean withZeroCoordinates) {
        LinkedList<Coordinate> coordinates = new LinkedList<Coordinate>();
        for (AbstractLocationObject o : locationObjects) {
            ImmutablePoint immutablePoint = o.getImmutablePoint();
            if (immutablePoint == null) continue;
            Coordinate coordinate = immutablePoint.getCoordinate();
            Coordinate wgs84Coordinate = Wgs84Factory.INSTANCE.createCoordinate(coordinate);
            if (!withZeroCoordinates && !(wgs84Coordinate.getX() > 0.0) && !(wgs84Coordinate.getY() > 0.0)) continue;
            coordinates.add(coordinate);
        }
        return coordinates;
    }

    public void setMarked(DataManagerType type, List<? extends Model> marked, Collection<? extends Model> unMarked) {
        Collection<Coordinate> coordinates;
        if (marked == null) {
            marked = Collections.emptyList();
        }
        boolean unMark = unMarked != null && !unMarked.isEmpty();
        switch (type) {
            case CUSTOMER: 
            case PICKPOINT: 
            case AREALOCATION: 
            case DELIVERERLOCATION: 
            case GROUPLOCATION: 
            case MAINLOCATION: 
            case AREADELIVERERLOCATION: {
                this.poiRenderer.addMarkedObjects(this.getLocationObjects(marked, new PoiTransformer()), unMarked == null);
                if (unMark) {
                    this.poiRenderer.removeMarkedObjects(this.getLocationObjects(unMarked, new PoiTransformer()));
                }
                this.poiRenderer.showMarked();
                this.poiRenderer.clearSelectedPoisInLegend();
                coordinates = this.getCoordinates(this.poiRenderer.getMarkedObjects(), false);
                break;
            }
            case PARCEL: {
                this.parcelRenderer.addMarkedObjects(this.getLocationObjects(marked, new ParcelTransformer()), unMarked == null);
                if (unMark) {
                    this.parcelRenderer.removeMarkedObjects(this.getLocationObjects(unMarked, new ParcelTransformer()));
                }
                this.parcelRenderer.showMarked();
                this.parcelRenderer.clearSelectedParcelsInLegend();
                coordinates = this.getCoordinates(this.parcelRenderer.getMarkedObjects(), false);
                break;
            }
            case STOPS: {
                this.stopRenderer.addMarkedObjects(this.getLocationObjects(marked, new StopTransformer()), unMarked == null);
                if (unMark) {
                    this.stopRenderer.removeMarkedObjects(this.getLocationObjects(unMarked, new StopTransformer()));
                }
                this.stopRenderer.showMarked();
                this.stopRenderer.clearSelectedStopsInLegend();
                coordinates = this.getCoordinates(this.stopRenderer.getMarkedObjects(), false);
                break;
            }
            default: {
                coordinates = new LinkedList<Coordinate>();
            }
        }
        this.centerCoordinates(coordinates);
    }

    public void centerModel(DataManagerType type, Model model) {
        AbstractLocationObject<Object> locationObject;
        switch (type) {
            case CUSTOMER: 
            case PICKPOINT: 
            case AREALOCATION: 
            case DELIVERERLOCATION: 
            case GROUPLOCATION: 
            case MAINLOCATION: 
            case AREADELIVERERLOCATION: {
                PoiTransformer poiTransformer = new PoiTransformer();
                locationObject = poiTransformer.transform((PoiModel)model);
                break;
            }
            case PARCEL: {
                ParcelTransformer parcelTransformer = new ParcelTransformer();
                locationObject = parcelTransformer.transform((ParcelModel)model);
                break;
            }
            case STOPS: {
                StopTransformer stopTransformer = new StopTransformer();
                locationObject = stopTransformer.transform((StopModel)model);
                break;
            }
            default: {
                locationObject = null;
            }
        }
        if (locationObject != null && locationObject.getImmutablePoint() != null) {
            this.navigator.center(locationObject.getImmutablePoint().getCoordinate());
        }
    }

    protected void centerCoordinates(Collection<Coordinate> coordinates) {
        if (!coordinates.isEmpty()) {
            this.navigator.center(coordinates, 0);
        }
        if (this.navigator.getUpp() < 0.25) {
            this.navigator.setUpp(0.25);
        }
    }

    private <M extends Model, L extends AbstractLocationObject<M>> Collection<L> getLocationObjects(Collection<M> models, Transformer<M, L> transformer) {
        LinkedList locationObjects = new LinkedList();
        CollectionUtil.transform(models, locationObjects, transformer);
        return locationObjects;
    }

    private <M extends AbstractLocationObject<? extends Model>> StaticGeoObjectBucketsModel<M, ImmutablePoint> getStaticBucketsModel() {
        StaticGeoObjectBucketsModel bucketsModel = new StaticGeoObjectBucketsModel(new GeomExtractor<M, ImmutablePoint>(){

            @Override
            public ImmutablePoint getGeom(M object) {
                return ((AbstractLocationObject)object).getImmutablePointFromModel();
            }
        }, this.getNavigatorPanel().getCoordinateFactory());
        return bucketsModel;
    }

    public void update() {
        Coordinate newCoordinate;
        Double newX = Double.valueOf(this.controlPanel.getxSpinner().getValue().toString());
        Double newY = Double.valueOf(this.controlPanel.getySpinner().getValue().toString());
        String coordinateFactoryName = (String)this.controlPanel.getCoordinateFormat().getSelectedItem();
        CoordinateFactory factory = CoordinateFactory.getInstance(coordinateFactoryName);
        if (factory == null) {
            factory = Wgs84Factory.INSTANCE;
        }
        if (GeoUtil.isNullPoint(ImmutableGeoObjectFactory.createImmutablePoint(newCoordinate = factory.createCoordinate(newX, newY)))) {
            String s = ClientFormUtil.getNumberString(newX) + ", " + ClientFormUtil.getNumberString(newY);
            JOptionPane.showMessageDialog(this, ModelEnviroment.getMessageResolver().resolveMessage("messages.attribute.error.format.integer", new Serializable[]{s}), "", 2);
            return;
        }
        this.navigator.center(newCoordinate);
    }

    public SegmentHoverRenderer getSegmentHoverRenderer() {
        return this.segmentHoverRenderer;
    }

    public DataManagerJunctionRenderModule getJunctionRenderer() {
        return this.junctionRenderer;
    }

    public AbstractToggleAction getShowMotorSegmentAction() {
        return this.showMotorSegmentAction;
    }

    public AbstractToggleAction getShowFootSegmentAction() {
        return this.showFootSegmentAction;
    }

    public AbstractToggleAction getShowBikeSegmentAction() {
        return this.showBikeSegmentAction;
    }

    private <M extends Model> void setListElements(DataManagerType type, Collection<M> elements) {
        JList<? extends Model> jList = this.resultListMap.get((Object)type);
        DefaultComboBoxModel defaultListModel = (DefaultComboBoxModel)jList.getModel();
        defaultListModel.removeAllElements();
        for (Model element : elements) {
            defaultListModel.addElement(element);
        }
    }

    @Override
    public void updatePanelAfterMark(AbstractFilterableMarkerNavigatorRenderer.RenderObjectType name, Collection<? extends Model> marked) {
        this.dataManagerGui.setNoFocusChange(true);
        this.setListElements(this.dataManagerGui.getCurrentType(), marked);
        this.dataManagerGui.setMarkedTable(marked, null, false);
        this.dataManagerGui.getSelectionComboBox().setSelectedIndex(-1);
        this.dataManagerGui.getGeoEditorPane().setAddressToSearch(LocationWrapperFactory.INSTANCE.createNullLocationWrapper());
        this.dataManagerGui.setNoFocusChange(false);
    }

    public JList<?> getPanelList() {
        return this.resultListMap.get((Object)this.dataManagerGui.getCurrentType());
    }

    public void setLayer(AreaLayerModel layer) {
    }

    public void setSelectedInLegend(Collection<? extends Model> selected) {
        switch (this.dataManagerGui.getCurrentType()) {
            case CUSTOMER: 
            case PICKPOINT: 
            case AREALOCATION: 
            case DELIVERERLOCATION: 
            case GROUPLOCATION: 
            case MAINLOCATION: 
            case AREADELIVERERLOCATION: {
                this.poiRenderer.setSelectedPoisInLegend(selected);
                break;
            }
            case PARCEL: {
                this.parcelRenderer.setSelectedParcelsInLegend(selected);
                break;
            }
            case STOPS: {
                this.stopRenderer.setSelectedStopsInLegend(selected);
                break;
            }
        }
        this.navigator.repaint();
    }

    @Override
    protected boolean isSearchOnlyForParcel() {
        return false;
    }

    private class StopTransformer
    extends SLSTransformer<StopModel, StopLocationObject> {
        private StopTransformer() {
        }

        @Override
        ParcelModel getParcel(StopModel model) {
            return model.getLocation().getParcel();
        }

        @Override
        StopLocationObject getLocationObjectWithParcel(StopModel model) {
            return new StopLocationObject(model, this.getParcel(model).getGeom());
        }

        @Override
        StopLocationObject getLocationObjectWithImportedLocation(StopModel model) {
            return new StopLocationObject(model, model.getLocation().getImportedLocation().getGeoLocation());
        }
    }

    private abstract class SLSTransformer<M extends Model, L extends AbstractLocationObject<M>>
    implements Transformer<M, L> {
        private SLSTransformer() {
        }

        @Override
        public L transform(M t) {
            if (this.getParcel(t) != null) {
                return this.getLocationObjectWithParcel(t);
            }
            return this.getLocationObjectWithImportedLocation(t);
        }

        abstract ParcelModel getParcel(M var1);

        abstract L getLocationObjectWithParcel(M var1);

        abstract L getLocationObjectWithImportedLocation(M var1);
    }

    private class ParcelTransformer
    implements Transformer<ParcelModel, ParcelLocationObject> {
        private ParcelTransformer() {
        }

        @Override
        public ParcelLocationObject transform(ParcelModel t) {
            return new ParcelLocationObject(t, t.getGeom());
        }
    }

    private class PoiTransformer
    implements Transformer<PoiModel, PoiLocationObject> {
        private PoiTransformer() {
        }

        @Override
        public PoiLocationObject transform(PoiModel t) {
            return new PoiLocationObject(t);
        }
    }
}

