/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.datamanager.gui;

import de.datomino.peppergis.client.geometric.GeoClientHelper;
import de.datomino.peppergis.client.gui.location.AbstractGeomEditorMapPane;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.Model;
import de.datomino.peppergis.client.model.map.SegmentModel;
import de.datomino.peppergis.datamanager.gui.DataManagerGui;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.Serializable;
import javax.swing.JOptionPane;
import org.ktde.math.projection.Coordinate;

public class DataManagerGeomEditorMapPane
extends AbstractGeomEditorMapPane<DataManagerGui> {
    private static final long serialVersionUID = 1019598198046282330L;

    public DataManagerGeomEditorMapPane(DataManagerGui parent, boolean routeSegmentEditable) {
        this(parent, routeSegmentEditable, true);
    }

    public DataManagerGeomEditorMapPane(DataManagerGui parent, boolean routeSegmentEditable, boolean withSearchRendering) {
        super(new BorderLayout());
        this.parent = parent;
        this.routeSegmentEditable = routeSegmentEditable;
        this.geoClientHelper = new GeoClientHelper(parent.getModelEnvironment());
        this.initializedMapPanel();
        this.add((Component)this.navigatorPanel, "Center");
        this.add((Component)this.creatControlPanel(withSearchRendering), "North");
        this.getSearchLocationAction().setParcelOnly(false);
    }

    @Override
    public void update() {
        super.update();
        this.setCoordinate(this.getResult().getCoordinate(), true);
    }

    @Override
    protected void updateParent() {
        ((DataManagerGui)this.parent).getMapEditorPanel().repaint(10L);
    }

    @Override
    protected ModelEnviroment getModelEnvironment() {
        return ((DataManagerGui)this.parent).getModelEnvironment();
    }

    @Override
    public void setCoordinate(Coordinate coordinate, boolean updated) {
        this.setCoordinate(coordinate, updated, true);
    }

    public void setCoordinate(Coordinate coordinate, boolean updated, boolean transaction) {
        super.setCoordinate(coordinate, true);
        this.getCoordinateEditorLayerRenderer().setActive(true);
        if (transaction) {
            ((DataManagerGui)this.parent).applyGeomResult(this.getResult());
        }
    }

    @Override
    protected void doAfterFindingCoordinate(Coordinate coordinate) {
        super.doAfterFindingCoordinate(coordinate);
        this.setCoordinate(coordinate, true, true);
    }

    @Override
    public void setSegments(SegmentModel motorSegment, SegmentModel footSegment, SegmentModel bikeSegment, boolean init) {
        this.setSegments(motorSegment, footSegment, bikeSegment, init, true);
    }

    public void setSegments(SegmentModel motorSegment, SegmentModel footSegment, SegmentModel bikeSegment, boolean init, boolean transaction) {
        super.setSegments(motorSegment, footSegment, bikeSegment, init);
        if (transaction) {
            ((DataManagerGui)this.parent).applyGeomResult(this.getResult());
        }
    }

    public boolean isSegmentChanged(Model model) {
        boolean changed = this.isChanged();
        if (changed) {
            int d = JOptionPane.showConfirmDialog(this, ModelEnviroment.getMessageResolver().resolveMessage("messages.datamanager.segment.saveNewAttachments", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("messages.default.question", new Serializable[0]), 1, 3);
            switch (d) {
                case 0: {
                    if (model == null) {
                        this.update();
                    } else {
                        ((DataManagerGui)this.parent).applyGeomResult(this.getSelectedResult(), model);
                    }
                    changed = false;
                    break;
                }
                case 1: {
                    this.restoreSegments();
                    changed = false;
                    break;
                }
            }
        }
        return changed;
    }
}

