/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.datamanager.gui;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.datamanager.actions.DataClientExportFileAction;
import de.datomino.peppergis.datamanager.gui.DataManagerGui;
import de.datomino.peppergis.type.UserRole;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;

public class DataManagerControlGui
extends JMenuBar {
    private static final long serialVersionUID = 7314181282817625113L;
    private DataClientExportFileAction exportResult;
    private DataClientExportFileAction exportMarked;
    private DataManagerGui dataManagerGui;
    private JMenuItem menuItemExportResult;
    private JMenuItem menuItemExportMarked;

    public DataManagerControlGui(DataManagerGui dataManagerGui) {
        this.dataManagerGui = dataManagerGui;
        this.buildLayout();
    }

    private void buildLayout() {
        JMenu exportMenu;
        JMenu importMenu = this.dataManagerGui.getImportMenu();
        if (importMenu != null) {
            this.add(importMenu);
        }
        if ((exportMenu = this.createExportMenu()) != null) {
            this.add(exportMenu);
        }
    }

    private JMenu createEditMenu() {
        JMenu edit = new JMenu(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.edit", new Serializable[0]));
        JMenuItem saveChanges = new JMenuItem("Speichern");
        edit.add(saveChanges);
        JMenuItem undo = new JMenuItem("R\u00fcckg\u00e4ngig");
        edit.add(undo);
        JMenuItem redo = new JMenuItem("Wiederherstellen");
        edit.add(redo);
        edit.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        return edit;
    }

    private JMenu createViewMenu() {
        JMenu view = new JMenu(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.view", new Serializable[0]));
        view.add(new JCheckBoxMenuItem(this.dataManagerGui.getShowMotorSegmentAction()));
        view.add(new JCheckBoxMenuItem(this.dataManagerGui.getShowBikeSegmentAction()));
        view.add(new JCheckBoxMenuItem(this.dataManagerGui.getShowFootSegmentAction()));
        return view;
    }

    private JMenu createExportMenu() {
        JMenu export = this.dataManagerGui.getExportMenu();
        boolean isAdminOrSuperUser = ModelEnviroment.getUserInformation().hasAtLeastOneRole(UserRole.ADMIN, UserRole.DISPONENT_SUPER);
        if (isAdminOrSuperUser) {
            if (export == null) {
                export = new JMenu(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.export", new Serializable[0]));
            }
            this.exportResult = new DataClientExportFileAction(SwingUtilities.getWindowAncestor(this.dataManagerGui), "csv", this.dataManagerGui, false);
            this.menuItemExportResult = export.add(this.exportResult);
            this.exportMarked = new DataClientExportFileAction(SwingUtilities.getWindowAncestor(this.dataManagerGui), "csv", this.dataManagerGui, true);
            this.menuItemExportMarked = export.add(this.exportMarked);
            this.exportResult.setEnabled(false);
            this.exportMarked.setEnabled(false);
            export.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        }
        return export;
    }

    public void setExportResultEnabled(boolean enabled) {
        if (this.exportResult != null) {
            this.exportResult.setEnabled(enabled);
        }
    }

    public void setExportMarkedEnabled(boolean enabled) {
        if (this.exportMarked != null) {
            this.exportMarked.setEnabled(enabled);
        }
    }

    public void removeMenuItems() {
        JMenu export = this.dataManagerGui.getExportMenu();
        if (export != null) {
            export.remove(this.menuItemExportResult);
            export.remove(this.menuItemExportMarked);
        }
    }
}

